/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.manager;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentInstall;
import com.ibm.cic.agent.core.AgentRelaunch;
import com.ibm.cic.agent.core.CacheLocationManager;
import com.ibm.cic.agent.core.CacheManager;
import com.ibm.cic.agent.core.IHeadlessApplication;
import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.agent.core.internal.headless.AgentInput;
import com.ibm.cic.agent.core.internal.headless.ICommand;
import com.ibm.cic.agent.core.internal.headless.IInput;
import com.ibm.cic.agent.core.internal.response.Response;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.console.ConAgentReopenRepositoryPrompter;
import com.ibm.cic.agent.internal.console.Messages;
import com.ibm.cic.agent.internal.console.pages.ConPageWelcome;
import com.ibm.cic.common.core.console.actions.IConAction;
import com.ibm.cic.common.core.console.manager.AConManager;
import com.ibm.cic.common.core.console.manager.IConIO;
import com.ibm.cic.common.core.console.pages.AConPage;
import com.ibm.cic.common.core.console.shared.pages.ConCredentialPrompter;
import com.ibm.cic.common.core.console.shared.pages.ConDiskChangePrompter;
import com.ibm.cic.common.core.repository.IReopenRepositoryPrompter;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.ConsoleProgressMonitor;
import com.ibm.cic.common.core.utils.RebootRequest;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.volrepo.DiskPrompter;
import com.ibm.cic.common.core.volrepo.IDiskChangePrompter;
import com.ibm.cic.common.downloads.CredentialPrompter;
import com.ibm.cic.common.downloads.ICredentialPrompter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ConManager
extends AConManager {
    IHeadlessApplication m_consoleApp;
    private static IConIO m_overrideConIO;

    ConManager(IHeadlessApplication a_consoleApp, String productName) {
        super(m_overrideConIO, productName);
        this.m_consoleApp = a_consoleApp;
    }

    public static IStatus start(IHeadlessApplication a_consoleApp) {
        Agent agent = Agent.getInstance();
        IStatus return_value = null;
        if (AgentInstall.getInstance().isInstallFromMultipleDisks()) {
            return ConManager.relaunchWithTemporaryInstaller();
        }
        String productName = SharedUIUtils.getFullProductName();
        if (productName == null || productName.length() == 0) {
            productName = Messages.PageWelcome_Header;
        }
        try {
            return_value = ConManager.initializeAgent(productName);
            if (!StatusUtil.isErrorOrCancel((IStatus)return_value)) {
                a_consoleApp.setAgent(Agent.getInstance());
                ConManager conMan = new ConManager(a_consoleApp, productName);
                return_value = conMan.run();
                ConManager.setOverrideConIO(null);
            }
        }
        finally {
            agent.stop();
        }
        return return_value;
    }

    public IHeadlessApplication getConsoleApp() {
        return this.m_consoleApp;
    }

    protected AConPage getWelcomePage() {
        return new ConPageWelcome(this);
    }

    @Deprecated
    public static void setOverrideConIO(IConIO a_overrideConIO) {
        m_overrideConIO = a_overrideConIO;
    }

    protected boolean shouldExit(IConAction action) {
        if (AgentRelaunch.getInstance().needsRelaunch()) {
            return true;
        }
        return super.shouldExit(action);
    }

    private static void processArguments() {
        AgentInput agentInput = AgentInput.getInstance();
        agentInput.setMode(0);
        IProgressMonitor monitor = ConsoleProgressMonitor.createMonitorWithUnknownWork();
        try {
            agentInput.loadInput(monitor);
        }
        finally {
            monitor.done();
        }
    }

    private static void preprocessInputCommands(CicMultiStatus status) {
        Agent agent = Agent.getInstance();
        IInput input = AgentInput.getInstance().getInput();
        if (input == null) {
            return;
        }
        IProgressMonitor monitor = ConsoleProgressMonitor.createMonitorWithUnknownWork();
        monitor.beginTask(Messages.ConManager_InputPreprocessing, 2);
        try {
            SubProgressMonitor partMonitor;
            if (!input.isNewFormat()) {
                partMonitor = new SubProgressMonitor(monitor, 1);
                status.add(input.executeCommands(agent, 2, (IProgressMonitor)partMonitor));
            } else {
                status.add(input.getResponse().initializeAgentPreferences(agent));
            }
            if (!input.isNewFormat()) {
                partMonitor = new SubProgressMonitor(monitor, 1);
                status.add(input.executeCommands(agent, 8, (IProgressMonitor)partMonitor));
            } else {
                status.add(input.getResponse().initializeAgentRepositories(agent));
            }
        }
        finally {
            monitor.done();
        }
    }

    private static IStatus initialize() {
        Agent agent = Agent.getInstance();
        agent.initializeAgentPreferences();
        IInput input = AgentInput.getInstance().getInput();
        if (input == null) {
            agent.setCleanTemporaryMode(false, false);
            CacheLocationManager.getInstance().setSettingCacheLocationByPreference(false);
        } else if (!input.isNewFormat()) {
            IProgressMonitor monitor = ConsoleProgressMonitor.createMonitorWithUnknownWork();
            try {
                agent.setCleanTemporaryMode(input.isCleanMode(), input.isTemporaryMode());
                if (input.isRebootLater()) {
                    RebootRequest.setRebootLater();
                }
                input.executeCommands(agent, 1, monitor);
                CacheLocationManager.getInstance().setSettingCacheLocationByPreference(input.isSettingEclipseCacheLocation());
                ICommand[] commands = input.getCommands(12);
                AgentInput.getInstance().setMode(commands != null && commands.length > 0 ? 1 : 0);
            }
            finally {
                monitor.done();
            }
        } else {
            Response response = input.getResponse();
            response.initializeAgentPreferences(agent);
            response.initializeAgentRepositories(agent);
        }
        IStatus status = agent.start();
        if (!status.isOK()) {
            return status;
        }
        if (input != null) {
            agent.logInputFile(input);
        }
        agent.setValidating(CmdLine.CL.containsCommand("-validate"));
        String recordFile = CmdLine.CL.getParam1StrVal("-record");
        if (recordFile != null) {
            status = agent.setRecordMode(recordFile);
        }
        return status;
    }

    private static IStatus initializeAgent(String productName) {
        CredentialPrompter.INSTANCE.setPrompter((ICredentialPrompter)new ConCredentialPrompter(productName));
        DiskPrompter.INSTANCE.setPrompter((IDiskChangePrompter)new ConDiskChangePrompter(productName));
        ConAgentReopenRepositoryPrompter reopenRepositoryPrompter = new ConAgentReopenRepositoryPrompter(productName);
        CacheManager.setReopenRepositoryPrompter((String)"cache", (IReopenRepositoryPrompter)reopenRepositoryPrompter);
        ConManager.processArguments();
        CicMultiStatus result = Statuses.ST.createMultiStatus();
        result.add(ConManager.initialize());
        if (result.isErrorOrCancel()) {
            return result;
        }
        ConManager.preprocessInputCommands(result);
        if (result.isErrorOrCancel()) {
            return result;
        }
        AgentInput agentInput = AgentInput.getInstance();
        if (agentInput.getMode() == 1) {
            agentInput.setWizardJobs(null);
            int wizardSubMode = agentInput.getWizardSubMode();
            if (wizardSubMode != 0) {
                result.add((IStatus)Statuses.ERROR.get("Only install wizard mode is currently supported.", new Object[0]));
            }
            result.add(agentInput.getWizardStatus());
        }
        return result;
    }

    private static IStatus relaunchWithTemporaryInstaller() {
        IProgressMonitor monitor = ConsoleProgressMonitor.createMonitorWithUnknownWork();
        try {
            IStatus status = AgentInstall.getInstance().relaunchWithTemporaryInstaller(monitor);
            if (!status.isOK() || monitor.isCanceled()) {
                IStatus cancelStatus = AgentInstall.getInstance().cancelRelaunchWithTemporaryInstaller();
                if (status.isOK()) {
                    status = cancelStatus;
                }
            }
            IStatus iStatus = status;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }
}

