/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.manager;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.InstallJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.SortUtil;
import com.ibm.cic.agent.core.UpdateOfferingJob;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.agent.core.sharedUI.SharedUIDependenciesCheckUtils;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.console.ConUtils;
import com.ibm.cic.agent.internal.console.Messages;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtForProfiles;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtUpdate;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtUtils;
import com.ibm.cic.agent.internal.console.manager.InstalledPackagesForProfile;
import com.ibm.cic.agent.internal.console.manager.JobListManager;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.FixProperty;
import com.ibm.cic.common.core.utils.ConsoleProgressMonitor;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ConDataCtxtUpdateVersionSelector
extends ConDataCtxtForProfiles {
    private final IOffering[] NO_OFFERINGS = new IOffering[0];
    private static final Logger log = Logger.getLogger(ConDataCtxtUpdateVersionSelector.class);
    private final ConDataCtxtUpdate m_mainUpdateContext;
    private InstalledPackagesForProfile m_installed;
    private final Map<Profile, Map<IOffering, List<UpdateOfferingJob>>> m_availableUpdates = new HashMap<Profile, Map<IOffering, List<UpdateOfferingJob>>>();
    private final Map<String, UpdateOfferingJob> m_recommendedUpdateJob = new HashMap<String, UpdateOfferingJob>();
    private final Map<String, Map<IOffering, List<InstallJob>>> m_fixesForInstalledOffering = new HashMap<String, Map<IOffering, List<InstallJob>>>();
    private final Map<String, Map<IOffering, List<InstallJob>>> m_recommendedFixesForInstalledOffering = new HashMap<String, Map<IOffering, List<InstallJob>>>();
    private final Map<String, Map<UpdateOfferingJob, List<InstallJob>>> m_fixesForUpdateOffering = new HashMap<String, Map<UpdateOfferingJob, List<InstallJob>>>();
    private final Map<String, Map<UpdateOfferingJob, List<InstallJob>>> m_recommendedFixesForUpdateOffering = new HashMap<String, Map<UpdateOfferingJob, List<InstallJob>>>();
    private final Map<String, Map<IFix, InstallJob>> m_fixToJobMap = new HashMap<String, Map<IFix, InstallJob>>();
    private final Map<String, Map<IOffering, FixesForInstalledOffering>> m_installedOfferingToFixContainer = new HashMap<String, Map<IOffering, FixesForInstalledOffering>>();

    public ConDataCtxtUpdateVersionSelector(ConDataCtxtUpdate a_mainContext) {
        this.m_mainUpdateContext = a_mainContext;
    }

    public IStatus prepareInstalledOfferingsInSelectedProfiles() {
        Set<Profile> selectedProfiles = this.m_mainUpdateContext.getSelectedProfiles().toSet();
        try {
            this.m_installed = new InstalledPackagesForProfile(selectedProfiles, AgentJob.AgentJobType.UPDATE_JOB);
        }
        catch (CoreException e) {
            this.m_recommendedUpdateJob.clear();
            this.m_availableUpdates.clear();
            this.m_fixesForInstalledOffering.clear();
            this.m_fixesForUpdateOffering.clear();
            this.m_recommendedFixesForInstalledOffering.clear();
            this.m_recommendedFixesForUpdateOffering.clear();
            this.m_installedOfferingToFixContainer.clear();
            return e.getStatus();
        }
        this.loadUpdates();
        return Status.OK_STATUS;
    }

    private void loadUpdates() {
        List<Profile> selectedProfiles = this.m_mainUpdateContext.getSelectedProfiles().toList();
        if (!selectedProfiles.isEmpty()) {
            IProgressMonitor monitor = ConsoleProgressMonitor.createMonitorWithUnknownWork();
            try {
                monitor.beginTask(Messages.ConDataCtxtUpdateVersionSelector_SearchUpdate, -1);
                for (Profile profile : selectedProfiles) {
                    List<IOffering> installedOfferings = this.m_installed.getInstalledOfferings((IProfile)profile);
                    Map<IOffering, List<UpdateOfferingJob>> availableUpdateMap = this.m_availableUpdates.get(profile);
                    if (availableUpdateMap != null) continue;
                    availableUpdateMap = new HashMap<IOffering, List<UpdateOfferingJob>>();
                    if (!installedOfferings.isEmpty()) {
                        Map recommended = Agent.getInstance().getRecommendedUpdates(profile, Statuses.ST.createMultiStatus(), (IProgressMonitor)new SubProgressMonitor(monitor, 0));
                        for (IOffering offering : installedOfferings) {
                            FixesForInstalledOffering container;
                            Map<IOffering, FixesForInstalledOffering> containerMap;
                            IOffering[] updates;
                            List<UpdateOfferingJob> updateJobList = new ArrayList();
                            IOffering[] iOfferingArray = updates = Agent.getInstance().findUpdates(profile, offering, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
                            int n = updates.length;
                            int n2 = 0;
                            while (n2 < n) {
                                List fixesForUpdate;
                                IOffering update;
                                IOffering updateOffering = update = iOfferingArray[n2];
                                UpdateOfferingJob job = new UpdateOfferingJob(profile, updateOffering, offering);
                                updateJobList.add(job);
                                IOffering recommendedUpdate = (IOffering)recommended.get(offering.getIdentity());
                                if (recommendedUpdate != null && recommendedUpdate.equals(updateOffering)) {
                                    this.m_recommendedUpdateJob.put(offering.getIdentity().getId(), job);
                                }
                                if (!(fixesForUpdate = Agent.getInstance().findFixesForProfile(updateOffering, (IProgressMonitor)new SubProgressMonitor(monitor, 0), (IProfile)profile)).isEmpty()) {
                                    List recommendedFixJobs;
                                    List installFixJobs;
                                    Map<UpdateOfferingJob, List<InstallJob>> offeringRecommendedFixMap;
                                    Map<UpdateOfferingJob, List<InstallJob>> offeringFixesMap = this.m_fixesForUpdateOffering.get(profile.getProfileId());
                                    if (offeringFixesMap == null) {
                                        offeringFixesMap = new HashMap<UpdateOfferingJob, List<InstallJob>>();
                                        this.m_fixesForUpdateOffering.put(profile.getProfileId(), offeringFixesMap);
                                    }
                                    if ((offeringRecommendedFixMap = this.m_recommendedFixesForUpdateOffering.get(profile.getProfileId())) == null) {
                                        offeringRecommendedFixMap = new HashMap<UpdateOfferingJob, List<InstallJob>>();
                                        this.m_recommendedFixesForUpdateOffering.put(profile.getProfileId(), offeringRecommendedFixMap);
                                    }
                                    if ((installFixJobs = offeringFixesMap.get(job)) == null) {
                                        installFixJobs = new ArrayList<InstallJob>();
                                    }
                                    if ((recommendedFixJobs = offeringRecommendedFixMap.get(job)) == null) {
                                        recommendedFixJobs = new ArrayList<InstallJob>();
                                    }
                                    for (IFix fix : fixesForUpdate) {
                                        InstallJob fixJob;
                                        if (this.isFixInstalled(fix, Agent.getInstance().getInstalledFixes(profile, updateOffering))) continue;
                                        Map<IFix, InstallJob> fixToJob = this.m_fixToJobMap.get(profile.getProfileId());
                                        if (fixToJob == null) {
                                            fixToJob = new HashMap<IFix, InstallJob>();
                                            this.m_fixToJobMap.put(profile.getProfileId(), fixToJob);
                                        }
                                        if ((fixJob = fixToJob.get(fix)) == null) {
                                            fixJob = new InstallJob(profile, (IOfferingOrFix)fix);
                                            fixToJob.put(fix, fixJob);
                                        }
                                        installFixJobs.add(fixJob);
                                        if (!FixProperty.isRecommended((IFix)fix)) continue;
                                        recommendedFixJobs.add(fixJob);
                                    }
                                    installFixJobs = SortUtil.sortByNameAndVersion(installFixJobs);
                                    offeringFixesMap.put(job, installFixJobs);
                                    recommendedFixJobs = SortUtil.sortByNameAndVersion(recommendedFixJobs);
                                    offeringRecommendedFixMap.put(job, recommendedFixJobs);
                                }
                                ++n2;
                            }
                            updateJobList = SortUtil.sortByNameAndVersion(updateJobList);
                            availableUpdateMap.put(offering, updateJobList);
                            List fixesForInstalledOffering = Agent.getInstance().findFixesForProfile(offering, (IProgressMonitor)new SubProgressMonitor(monitor, 0), (IProfile)profile);
                            if (!fixesForInstalledOffering.isEmpty()) {
                                List recommendedFixJobs;
                                List installFixJobs;
                                Map<IOffering, List<InstallJob>> offeringRecommendedFixMap;
                                Map<IOffering, List<InstallJob>> offeringFixesMap = this.m_fixesForInstalledOffering.get(profile.getProfileId());
                                if (offeringFixesMap == null) {
                                    offeringFixesMap = new HashMap<IOffering, List<InstallJob>>();
                                    this.m_fixesForInstalledOffering.put(profile.getProfileId(), offeringFixesMap);
                                }
                                if ((offeringRecommendedFixMap = this.m_recommendedFixesForInstalledOffering.get(profile.getProfileId())) == null) {
                                    offeringRecommendedFixMap = new HashMap<IOffering, List<InstallJob>>();
                                    this.m_recommendedFixesForInstalledOffering.put(profile.getProfileId(), offeringRecommendedFixMap);
                                }
                                if ((installFixJobs = offeringFixesMap.get(offering)) == null) {
                                    installFixJobs = new ArrayList<InstallJob>();
                                }
                                if ((recommendedFixJobs = offeringRecommendedFixMap.get(offering)) == null) {
                                    recommendedFixJobs = new ArrayList<InstallJob>();
                                }
                                for (IFix fix : fixesForInstalledOffering) {
                                    InstallJob fixJob;
                                    if (this.isFixInstalled(fix, Agent.getInstance().getInstalledFixes(profile, offering))) continue;
                                    Map<IFix, InstallJob> fixToJob = this.m_fixToJobMap.get(profile.getProfileId());
                                    if (fixToJob == null) {
                                        fixToJob = new HashMap<IFix, InstallJob>();
                                        this.m_fixToJobMap.put(profile.getProfileId(), fixToJob);
                                    }
                                    if ((fixJob = fixToJob.get(fix)) == null) {
                                        fixJob = new InstallJob(profile, (IOfferingOrFix)fix);
                                        fixToJob.put(fix, fixJob);
                                    }
                                    installFixJobs.add(fixJob);
                                    if (!FixProperty.isRecommended((IFix)fix)) continue;
                                    recommendedFixJobs.add(fixJob);
                                }
                                installFixJobs = SortUtil.sortByNameAndVersion(installFixJobs);
                                offeringFixesMap.put(offering, installFixJobs);
                                recommendedFixJobs = SortUtil.sortByNameAndVersion(recommendedFixJobs);
                                offeringRecommendedFixMap.put(offering, recommendedFixJobs);
                            }
                            if ((containerMap = this.m_installedOfferingToFixContainer.get(profile.getProfileId())) == null) {
                                containerMap = new HashMap<IOffering, FixesForInstalledOffering>();
                                this.m_installedOfferingToFixContainer.put(profile.getProfileId(), containerMap);
                            }
                            if ((container = containerMap.get(offering)) != null) continue;
                            ArrayList<InstallJob> allFixes = new ArrayList();
                            Map<IOffering, List<InstallJob>> allMap = this.m_fixesForInstalledOffering.get(profile.getProfileId());
                            if (allMap != null) {
                                allFixes = allMap.get(offering);
                            }
                            if (allFixes == null || allFixes.isEmpty()) continue;
                            List<InstallJob> recommendedFixes = new ArrayList<InstallJob>();
                            Map<IOffering, List<InstallJob>> recommendedMap = this.m_recommendedFixesForInstalledOffering.get(profile.getProfileId());
                            if (recommendedMap != null) {
                                recommendedFixes = recommendedMap.get(offering);
                            }
                            container = new FixesForInstalledOffering(offering, recommendedFixes, allFixes);
                            containerMap.put(offering, container);
                        }
                    }
                    this.m_availableUpdates.put(profile, availableUpdateMap);
                }
                this.sortAvailableUpdates();
            }
            finally {
                monitor.done();
            }
        }
    }

    private void sortAvailableUpdates() {
        SortUtil.ProfileSorter sorter = new SortUtil.ProfileSorter();
        for (Profile profile : this.m_availableUpdates.keySet()) {
            for (IOffering offering : this.m_availableUpdates.get(profile).keySet()) {
                sorter.add(profile, (IOfferingOrFix)offering);
            }
        }
        for (Profile profile : sorter.getSortedProfiles()) {
            LinkedHashMap<IOffering, List<UpdateOfferingJob>> sorted = new LinkedHashMap<IOffering, List<UpdateOfferingJob>>();
            Map<IOffering, List<UpdateOfferingJob>> unsorted = this.m_availableUpdates.get(profile);
            for (IOfferingOrFix oof : sorter.getSortedOfferings(profile)) {
                IOffering offering = (IOffering)oof;
                sorted.put(offering, unsorted.get(offering));
            }
            this.m_availableUpdates.put(profile, sorted);
        }
    }

    private boolean isFixInstalled(IFix fix, IFix[] fixes) {
        IFix[] iFixArray = fixes;
        int n = fixes.length;
        int n2 = 0;
        while (n2 < n) {
            IFix installedFix = iFixArray[n2];
            if (fix.getIdentity().equals(installedFix.getIdentity())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public IStatus validateSelectedUpdates(boolean isUpdateAll) {
        IStatus return_result = Status.OK_STATUS;
        IProgressMonitor monitor = ConsoleProgressMonitor.createMonitorWithUnknownWork();
        try {
            monitor.beginTask(Messages.ConDataCtxtUpdateVersionSelector_ValidateMsg, -1);
            return_result = ConUtils.checkOfferingSupportConsoleMode(this.getSelectedUpdateJobs().toList());
            if (!StatusUtil.isErrorOrCancel((IStatus)return_result)) {
                return_result = ConUtils.checkOfferingSupportCurrentPlatform(this.getSelectedUpdateJobs().toList());
            }
            if (!StatusUtil.isErrorOrCancel((IStatus)return_result)) {
                return_result = ConUtils.performPreCheck(this.getSelectedUpdateJobs().toList());
            }
            if (!StatusUtil.isErrorOrCancel((IStatus)return_result)) {
                return_result = SharedUIUtils.getAgentToleranceStatus(this.getAllSelectedJobs());
            }
            if (!StatusUtil.isErrorOrCancel((IStatus)return_result) && !StatusUtil.isErrorOrCancel((IStatus)(return_result = AgentUtil.getOfferingsApplicability(this.getSelectedUpdateJobs().toList(), (AgentJob[])this.getSelectedUpdateJobs().toArray())))) {
                return_result = Agent.getInstance().checkInstall(this.getSelectedUpdateJobs().toArray(), (IProgressMonitor)new SubProgressMonitor(monitor, 0));
            }
            if (isUpdateAll) {
                if (!StatusUtil.isErrorOrCancel((IStatus)return_result)) {
                    List<AgentJob> allSelectedJobs = this.getAllSelectedJobs();
                    return_result = SharedUIDependenciesCheckUtils.checkDependenciesMultiFinalProfilesPrepareUnprepare((AgentJob[])allSelectedJobs.toArray(new AgentJob[allSelectedJobs.size()]), (IProgressMonitor)new SubProgressMonitor(monitor, 0));
                }
                if (!StatusUtil.isErrorOrCancel((IStatus)return_result)) {
                    List<UpdateOfferingJob> selectedUpdateJobs = this.getSelectedUpdateJobs().toList();
                    for (UpdateOfferingJob job : selectedUpdateJobs) {
                        IFeature[] defaultSelectedFeatures = Agent.getInstance().getDefaultFeatures(job);
                        job.setFeatures(Arrays.asList(defaultSelectedFeatures));
                    }
                    return_result = Agent.getInstance().checkDiskSpaceInfo(selectedUpdateJobs, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
                }
            }
        }
        finally {
            monitor.done();
        }
        return return_result;
    }

    public IStatus selectUpdateJob(UpdateOfferingJob updateJob, boolean validate) {
        FixesForInstalledOffering container;
        IStatus return_value = Status.OK_STATUS;
        this.unselectSimilarUpdateJob(updateJob.getOfferingOrFix());
        Profile profile = updateJob.getProfile();
        IOffering baseOffering = updateJob.getUpdatedOffering();
        Map<IOffering, FixesForInstalledOffering> map = this.m_installedOfferingToFixContainer.get(profile.getProfileId());
        if (map != null && (container = map.get(baseOffering)) != null && container.isSelected()) {
            container.setSelected(false);
        }
        if (this.getSelectedUpdateJobs().addJob(updateJob)) {
            IProgressMonitor monitor = ConsoleProgressMonitor.createMonitorWithUnknownWork();
            try {
                monitor.beginTask(Messages.General_ConDataCtxt_PrepareAndResolve, -1);
                ArrayList<UpdateOfferingJob> jobsToPrepare = new ArrayList<UpdateOfferingJob>();
                jobsToPrepare.add(updateJob);
                IStatus status = SharedUIUtils.prepareAndResolveSelectedJobs(jobsToPrepare, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
                log.statusNotOK(status);
            }
            finally {
                monitor.done();
            }
            this.getSelectedUpdateJobs().sortByNameAndVersion();
            if (validate) {
                return_value = this.validateSelectedUpdates(false);
            }
        }
        return return_value;
    }

    public IStatus selectFixJob(InstallJob fixJob, boolean validate) {
        IStatus return_value = Status.OK_STATUS;
        if (this.getSelectedInstallFixJobs().addJob(fixJob)) {
            IProgressMonitor monitor = ConsoleProgressMonitor.createMonitorWithUnknownWork();
            try {
                monitor.beginTask(Messages.General_ConDataCtxt_PrepareAndResolve, -1);
                ArrayList<InstallJob> jobsToPrepare = new ArrayList<InstallJob>();
                jobsToPrepare.add(fixJob);
                IStatus status = SharedUIUtils.prepareAndResolveSelectedJobs(jobsToPrepare, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
                log.statusNotOK(status);
            }
            finally {
                monitor.done();
            }
            this.getSelectedInstallFixJobs().sortByNameAndVersion();
        }
        return return_value;
    }

    public void unselectInstallFixJob(InstallJob fixJob) {
        if (this.getSelectedInstallFixJobs().removeJob(fixJob)) {
            IProgressMonitor monitor = ConsoleProgressMonitor.createMonitorWithUnknownWork();
            try {
                IOfferingOrFix oof = fixJob.getOfferingOrFix();
                ConDataCtxtUtils.unloadBundlesForOfferingOrFix(oof, monitor);
            }
            finally {
                monitor.done();
            }
        }
    }

    private void unselectUpdateJob(UpdateOfferingJob updateJob) {
        if (this.getSelectedUpdateJobs().removeJob(updateJob)) {
            IProgressMonitor monitor = ConsoleProgressMonitor.createMonitorWithUnknownWork();
            try {
                IOfferingOrFix oof = updateJob.getOfferingOrFix();
                ConDataCtxtUtils.unloadBundlesForOfferingOrFix(oof, monitor);
            }
            finally {
                monitor.done();
            }
        }
    }

    public IStatus flipFixContainerSelection(FixesForInstalledOffering container) {
        if (container.isSelected()) {
            container.setSelected(false);
        } else {
            this.unselectSimilarUpdateJob((IOfferingOrFix)container.getInstalledOffering());
            container.setSelected(true);
        }
        return this.validateSelectedUpdates(false);
    }

    public IStatus flipUpdateVersionSelection(UpdateOfferingJob updateJob) {
        if (this.isUpdateVersionSelected(updateJob)) {
            this.unselectUpdateJob(updateJob);
            return this.validateSelectedUpdates(false);
        }
        return this.selectUpdateJob(updateJob, true);
    }

    public IStatus flipFixJobSelection(InstallJob fixJob) {
        if (this.isFixJobSelected(fixJob)) {
            this.unselectInstallFixJob(fixJob);
            return this.validateSelectedUpdates(false);
        }
        return this.selectFixJob(fixJob, true);
    }

    public IStatus setFixJobSelection(InstallJob fixJob, boolean select) {
        if (select) {
            return this.selectFixJob(fixJob, true);
        }
        this.unselectInstallFixJob(fixJob);
        return this.validateSelectedUpdates(false);
    }

    private void unselectSimilarUpdateJob(IOfferingOrFix oof) {
        for (UpdateOfferingJob job : this.getSelectedUpdateJobs().toList()) {
            if (!job.getOfferingOrFix().getIdentity().equals(oof.getIdentity())) continue;
            this.unselectUpdateJob(job);
            break;
        }
    }

    public void unselectAllUpdateJobs() {
        for (UpdateOfferingJob job : this.getSelectedUpdateJobs().toList()) {
            this.unselectUpdateJob(job);
        }
    }

    public void unselectAllFixJobs() {
        for (InstallJob fixJob : this.getSelectedInstallFixJobs().toList()) {
            this.unselectInstallFixJob(fixJob);
        }
    }

    public boolean isUpdateVersionSelected(UpdateOfferingJob updateJob) {
        return this.getSelectedUpdateJobs().contains(updateJob);
    }

    public boolean isFixJobSelected(InstallJob fixJob) {
        return this.getSelectedInstallFixJobs().contains(fixJob);
    }

    public IOffering[] getOfferingsToUpdate() {
        Profile profile = this.m_mainUpdateContext.getSingleSelectedProfile();
        if (profile != null) {
            return this.getOfferingsToUpdate(profile);
        }
        return this.NO_OFFERINGS;
    }

    public IOffering[] getOfferingsToUpdate(Profile a_profile) {
        Map<IOffering, List<UpdateOfferingJob>> map = this.m_availableUpdates.get(a_profile);
        if (map == null) {
            return this.NO_OFFERINGS;
        }
        return map.keySet().toArray(new IOffering[map.keySet().size()]);
    }

    public IStatus checkUpdateStatusOfAllProfile() {
        IStatus return_value = Status.OK_STATUS;
        List<Profile> profiles = this.m_mainUpdateContext.getSelectedProfiles().toList();
        for (Profile p : profiles) {
            IStatus stat = this.checkUpdateStatusOfSelectedProfile(p);
            if (stat.isOK()) {
                return stat;
            }
            if (stat.getSeverity() <= return_value.getSeverity()) continue;
            return_value = stat;
        }
        return return_value;
    }

    public IStatus checkUpdateStatusOfSelectedProfile(Profile a_profile) {
        String profileId = a_profile.getProfileId();
        Map<IOffering, List<UpdateOfferingJob>> updateMap = this.m_availableUpdates.get(a_profile);
        Map<IOffering, List<InstallJob>> fixMap = this.m_fixesForInstalledOffering.get(profileId);
        if (updateMap == null && fixMap == null) {
            return Statuses.ERROR.get(460, Messages.PageUpdate_Pkg_NoOfferingsToUpdate, new Object[0]);
        }
        if (updateMap != null) {
            Collection<List<UpdateOfferingJob>> offeringJobLists = updateMap.values();
            for (List<UpdateOfferingJob> list : offeringJobLists) {
                if (list.isEmpty()) continue;
                return Status.OK_STATUS;
            }
        }
        if (fixMap != null) {
            Collection<List<InstallJob>> fixJobLists = fixMap.values();
            for (List<UpdateOfferingJob> list : fixJobLists) {
                if (list.isEmpty()) continue;
                return Status.OK_STATUS;
            }
        }
        return Statuses.ERROR.get(461, Messages.PageUpdate_Pkg_NoUpdatesForOfferings, new Object[0]);
    }

    public IStatus unselectAllJobsButRecommended() {
        Collection<UpdateOfferingJob> allRecommendedJobs = this.m_recommendedUpdateJob.values();
        ArrayList<UpdateOfferingJob> toUnselect = new ArrayList<UpdateOfferingJob>();
        for (UpdateOfferingJob ouj : this.getSelectedUpdateJobs().toList()) {
            boolean found = false;
            for (UpdateOfferingJob oujToKeep : allRecommendedJobs) {
                if (ouj != oujToKeep) continue;
                found = true;
                break;
            }
            if (found) continue;
            toUnselect.add(ouj);
        }
        for (UpdateOfferingJob ouj : toUnselect) {
            this.unselectUpdateJob(ouj);
        }
        if (!toUnselect.isEmpty()) {
            return this.validateSelectedUpdates(false);
        }
        Map<IOffering, FixesForInstalledOffering> maps = this.m_installedOfferingToFixContainer.get(this.m_mainUpdateContext.getSingleSelectedProfile().getProfileId());
        Collection<FixesForInstalledOffering> values = maps.values();
        for (FixesForInstalledOffering container : values) {
            if (container == null || !container.isSelected()) continue;
            String installedOfferingId = container.getInstalledOffering().getIdentity().getId();
            UpdateOfferingJob recommendedUpdate = this.m_recommendedUpdateJob.get(installedOfferingId);
            if (recommendedUpdate != null) {
                container.setSelected(false);
                continue;
            }
            List<InstallJob> recommendedFixes = container.getRecommendedFixes();
            if (!recommendedFixes.isEmpty()) continue;
            container.setSelected(false);
        }
        return Status.OK_STATUS;
    }

    public IStatus selectAllRecommended() {
        if (this.m_mainUpdateContext.isUpdateAllRequested()) {
            boolean hasRecommendedUpdateOrFix = false;
            this.unselectAllFixJobs();
            Collection<UpdateOfferingJob> allRecommendedJobs = this.m_recommendedUpdateJob.values();
            for (UpdateOfferingJob uoJ : allRecommendedJobs) {
                if (!hasRecommendedUpdateOrFix) {
                    hasRecommendedUpdateOrFix = true;
                }
                this.selectUpdateJob(uoJ, false);
            }
            List<Profile> selectedProfiles = this.m_mainUpdateContext.getSelectedProfiles().toList();
            for (Profile profile : selectedProfiles) {
                List<IOffering> installedOfferings = this.m_installed.getInstalledOfferings((IProfile)profile);
                for (IOffering installedOffering : installedOfferings) {
                    List<InstallJob> recommendedFixJob;
                    Map<UpdateOfferingJob, List<InstallJob>> map;
                    UpdateOfferingJob updateOfferingJob = this.m_recommendedUpdateJob.get(installedOffering.getIdentity().getId());
                    if (updateOfferingJob != null) {
                        List<InstallJob> recommendedFixes;
                        map = this.m_recommendedFixesForUpdateOffering.get(profile.getProfileId());
                        if (map == null || (recommendedFixes = map.get(updateOfferingJob)) == null || recommendedFixes.size() <= 0) continue;
                        for (InstallJob fixJob : recommendedFixes) {
                            this.selectFixJob(fixJob, false);
                        }
                        continue;
                    }
                    map = this.m_recommendedFixesForInstalledOffering.get(profile.getProfileId());
                    if (map == null || (recommendedFixJob = map.get(installedOffering)) == null || recommendedFixJob.size() <= 0) continue;
                    for (InstallJob fixJob : recommendedFixJob) {
                        if (!hasRecommendedUpdateOrFix) {
                            hasRecommendedUpdateOrFix = true;
                        }
                        this.selectFixJob(fixJob, false);
                    }
                }
            }
            if (!hasRecommendedUpdateOrFix) {
                return Statuses.ST.ERROR_STATUS.get(com.ibm.cic.agent.core.sharedUI.Messages.NoValidRecommendedUpdates, new Object[0]);
            }
        } else {
            IOffering[] offerings;
            IOffering[] iOfferingArray = offerings = this.getOfferingsToUpdate();
            int n = offerings.length;
            int n2 = 0;
            while (n2 < n) {
                IOffering of = iOfferingArray[n2];
                UpdateOfferingJob uoJ = this.m_recommendedUpdateJob.get(of.getIdentity().getId());
                if (uoJ != null) {
                    this.selectUpdateJob(uoJ, false);
                } else {
                    this.selectRecommendedFixContainer(this.m_mainUpdateContext.getSingleSelectedProfile(), of);
                }
                ++n2;
            }
        }
        return this.validateSelectedUpdates(this.m_mainUpdateContext.isUpdateAllRequested());
    }

    private void selectRecommendedFixContainer(Profile profile, IOffering offering) {
        FixesForInstalledOffering container;
        Map<IOffering, FixesForInstalledOffering> map = this.m_installedOfferingToFixContainer.get(profile.getProfileId());
        if (map != null && (container = map.get(offering)) != null && !container.isSelected() && !container.getRecommendedFixes().isEmpty()) {
            container.setSelected(true);
        }
    }

    public List<UpdateOfferingJob> getSelectedOfferingJobWithFix(boolean recommendedOnly) {
        ArrayList<UpdateOfferingJob> return_result = new ArrayList<UpdateOfferingJob>();
        List<UpdateOfferingJob> selectedUpdates = this.getSelectedUpdateJobs().toList();
        for (UpdateOfferingJob updateJob : selectedUpdates) {
            List<InstallJob> fixes = this.getAvailableFixJobsForUpdate(updateJob, recommendedOnly);
            if (fixes == null || fixes.size() <= 0) continue;
            return_result.add(updateJob);
        }
        return return_result;
    }

    public List<InstallJob> getFixesForSelectedOfferingNUpdate(boolean recommended) {
        ArrayList<InstallJob> return_value = new ArrayList<InstallJob>();
        List<UpdateOfferingJob> updates = this.getSelectedOfferingJobWithFix(recommended);
        for (UpdateOfferingJob updateJob : updates) {
            List<InstallJob> fixes = this.getAvailableFixJobsForUpdate(updateJob, recommended);
            if (fixes == null || fixes.size() <= 0) continue;
            return_value.addAll(fixes);
        }
        List<FixesForInstalledOffering> containers = this.getSelectedFixContainer();
        for (FixesForInstalledOffering container : containers) {
            List<InstallJob> fixes = recommended ? container.getRecommendedFixes() : container.getAllFixes();
            return_value.addAll(fixes);
        }
        return return_value;
    }

    public void selectRecommendedFixes() {
        List<InstallJob> allFixes = this.getFixesForSelectedOfferingNUpdate(false);
        List<InstallJob> allRecommendedFixes = this.getFixesForSelectedOfferingNUpdate(true);
        for (InstallJob job : allFixes) {
            if (allRecommendedFixes.contains(job)) {
                this.selectFixJob(job, false);
                continue;
            }
            this.unselectInstallFixJob(job);
        }
    }

    public void unselectNonRecommendedFixJobs() {
        List<InstallJob> allFixes = this.getFixesForSelectedOfferingNUpdate(false);
        List<InstallJob> allRecommendedFixes = this.getFixesForSelectedOfferingNUpdate(true);
        for (InstallJob job : allFixes) {
            if (allRecommendedFixes.contains(job)) continue;
            this.unselectInstallFixJob(job);
        }
    }

    public UpdateOfferingJob[] getAvailableOfferingJobs(IOffering offeringToUpdate, boolean recommendedOnly) {
        UpdateOfferingJob[] return_value = new UpdateOfferingJob[]{};
        Profile profile = this.m_mainUpdateContext.getSingleSelectedProfile();
        if (recommendedOnly) {
            UpdateOfferingJob recommendedUpdate = this.m_recommendedUpdateJob.get(offeringToUpdate.getIdentity().getId());
            if (recommendedUpdate != null) {
                return_value = new UpdateOfferingJob[]{recommendedUpdate};
            }
        } else {
            List<UpdateOfferingJob> availableJobList = this.m_availableUpdates.get(profile).get(offeringToUpdate);
            return_value = availableJobList.toArray(new UpdateOfferingJob[availableJobList.size()]);
        }
        return return_value;
    }

    public List<InstallJob> getAvailableFixJobsForUpdate(UpdateOfferingJob update, boolean recommendedOnly) {
        List<InstallJob> fixes;
        ArrayList<InstallJob> return_value = new ArrayList<InstallJob>();
        Profile profile = this.m_mainUpdateContext.getSingleSelectedProfile();
        Map<UpdateOfferingJob, List<InstallJob>> map = recommendedOnly ? this.m_recommendedFixesForUpdateOffering.get(profile.getProfileId()) : this.m_fixesForUpdateOffering.get(profile.getProfileId());
        if (map != null && (fixes = map.get(update)) != null) {
            return_value.addAll(fixes);
        }
        return return_value;
    }

    public List<InstallJob> getAvailableFixJobs(IOffering installedOffering, boolean recommendedOnly) {
        List<InstallJob> fixes;
        ArrayList<InstallJob> return_value = new ArrayList<InstallJob>();
        Profile profile = this.m_mainUpdateContext.getSingleSelectedProfile();
        Map<IOffering, List<InstallJob>> map = recommendedOnly ? this.m_recommendedFixesForInstalledOffering.get(profile.getProfileId()) : this.m_fixesForInstalledOffering.get(profile.getProfileId());
        if (map != null && (fixes = map.get(installedOffering)) != null) {
            return_value.addAll(fixes);
        }
        return return_value;
    }

    public JobListManager<InstallJob> getSelectedInstallFixJobs() {
        return this.m_mainUpdateContext.getSelectedInstallFixJobs();
    }

    public JobListManager<UpdateOfferingJob> getSelectedUpdateJobs() {
        return this.m_mainUpdateContext.getSelectedJobs();
    }

    public List<AgentJob> getAllSelectedJobs() {
        return this.m_mainUpdateContext.getAllSelectedJobs();
    }

    public boolean hasSelectedNonRecommendedFix() {
        for (InstallJob fixInstallJob : this.getSelectedInstallFixJobs().getSelectedFixJobs()) {
            if (FixProperty.isRecommended((IFix)fixInstallJob.getFix())) continue;
            return true;
        }
        return false;
    }

    public FixesForInstalledOffering getInstalledOfferingFixContainer(IOffering offering) {
        Map<IOffering, FixesForInstalledOffering> map = this.m_installedOfferingToFixContainer.get(this.m_mainUpdateContext.getSingleSelectedProfile().getProfileId());
        if (map != null) {
            return map.get(offering);
        }
        return null;
    }

    public List<FixesForInstalledOffering> getSelectedFixContainer() {
        ArrayList<FixesForInstalledOffering> return_result = new ArrayList<FixesForInstalledOffering>();
        Map<IOffering, FixesForInstalledOffering> map = this.m_installedOfferingToFixContainer.get(this.m_mainUpdateContext.getSingleSelectedProfile().getProfileId());
        if (map != null) {
            Collection<FixesForInstalledOffering> collection = map.values();
            for (FixesForInstalledOffering container : collection) {
                if (container == null || !container.isSelected()) continue;
                return_result.add(container);
            }
        }
        return return_result;
    }

    public static class FixesForInstalledOffering {
        private final IOffering installedOffering;
        private final List<InstallJob> recommendedFixes;
        private final List<InstallJob> allFixes;
        private boolean selected = false;

        public FixesForInstalledOffering(IOffering installed, List<InstallJob> recommendedFixes, List<InstallJob> allFixes) {
            this.installedOffering = installed;
            this.recommendedFixes = recommendedFixes != null ? recommendedFixes : Collections.emptyList();
            this.allFixes = allFixes != null ? allFixes : Collections.emptyList();
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        public IOffering getInstalledOffering() {
            return this.installedOffering;
        }

        public List<InstallJob> getRecommendedFixes() {
            return this.recommendedFixes;
        }

        public List<InstallJob> getAllFixes() {
            return this.allFixes;
        }
    }
}

