/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.manager;

import com.ibm.cic.agent.internal.console.Messages;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtPrefsInternet;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtPrefsMain;
import com.ibm.cic.common.core.preferences.CicPreferenceManager;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.downloads.ProxyProtocol;
import com.ibm.cic.common.downloads.ProxySupport;
import com.ibm.cic.common.downloads.TransferManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ConDataCtxtPrefsProxy
extends ConDataCtxtPrefsInternet {
    public static final String HttpProtocol = "http";
    public static final String FtpProtocol = "ftp";
    public static final ICicPreferenceConstants.PreferenceTag m_enableHttpProxyTag = ICicPreferenceConstants.ProxyPreferences.getProxyEnabled((String)"http");
    public static final ICicPreferenceConstants.PreferenceTag m_enableFtpProxyTag = ICicPreferenceConstants.ProxyPreferences.getProxyEnabled((String)"ftp");
    private final ICicPreferenceConstants.PreferenceTag m_useSocksTag = ICicPreferenceConstants.ProxyPreferences.getProxyUseSocks((String)ProxyProtocol.HTTP.getKey());
    private final ICicPreferenceConstants.PreferenceTag m_proxyHostTag = ICicPreferenceConstants.ProxyPreferences.getProxyHost((String)ProxyProtocol.HTTP.getKey());
    private final ICicPreferenceConstants.PreferenceTag m_proxyPortTag = ICicPreferenceConstants.ProxyPreferences.getProxyPort((String)ProxyProtocol.HTTP.getKey());
    private final ICicPreferenceConstants.PreferenceTag m_socksHostTag = ICicPreferenceConstants.ProxyPreferences.getSocksProxyHost();
    private final ICicPreferenceConstants.PreferenceTag m_socksPortTag = ICicPreferenceConstants.ProxyPreferences.getSocksProxyPort();
    private boolean m_enableHttpProxy;
    private String m_proxyHost;
    private String m_proxyPort;
    private boolean m_useSocks;
    private String m_socksHost;
    private String m_socksPort;
    private boolean m_enableFtpProxy;
    private IStatus status = Status.OK_STATUS;

    ConDataCtxtPrefsProxy(ConDataCtxtPrefsMain a_mainPreferenceDataContext) {
        super(a_mainPreferenceDataContext);
        this.determineInitialValues();
    }

    private void determineInitialValues() {
        this.m_enableHttpProxy = CicPreferenceManager.getInstance().getBoolean(m_enableHttpProxyTag.key());
        this.m_enableFtpProxy = CicPreferenceManager.getInstance().getBoolean(m_enableFtpProxyTag.key());
        this.m_useSocks = CicPreferenceManager.getInstance().getBoolean(this.m_useSocksTag.key());
        this.m_proxyHost = CicPreferenceManager.getInstance().getString(this.m_proxyHostTag.key());
        this.m_proxyPort = CicPreferenceManager.getInstance().getString(this.m_proxyPortTag.key());
        this.m_socksHost = CicPreferenceManager.getInstance().getString(this.m_socksHostTag.key());
        this.m_socksPort = CicPreferenceManager.getInstance().getString(this.m_socksPortTag.key());
    }

    @Override
    public void savePreferences() {
        this.m_mainPrefDataContext.getCurrentPrefHandler().setValue(m_enableHttpProxyTag.key(), this.m_enableHttpProxy);
        this.m_mainPrefDataContext.getCurrentPrefHandler().setValue(m_enableFtpProxyTag.key(), this.m_enableFtpProxy);
        this.m_mainPrefDataContext.getCurrentPrefHandler().setValue(this.m_useSocksTag.key(), this.m_useSocks);
        this.m_mainPrefDataContext.getCurrentPrefHandler().setValue(this.m_proxyHostTag.key(), this.m_proxyHost);
        this.m_mainPrefDataContext.getCurrentPrefHandler().setValue(this.m_proxyPortTag.key(), this.m_proxyPort);
        this.m_mainPrefDataContext.getCurrentPrefHandler().setValue(this.m_socksHostTag.key(), this.m_socksHost);
        this.m_mainPrefDataContext.getCurrentPrefHandler().setValue(this.m_socksPortTag.key(), this.m_socksPort);
        super.savePreferences();
    }

    @Override
    public void restoreDefaults() {
        this.m_enableHttpProxy = this.m_mainPrefDataContext.getDefaultPrefHandler().getBoolean(m_enableHttpProxyTag);
        this.m_enableFtpProxy = this.m_mainPrefDataContext.getDefaultPrefHandler().getBoolean(m_enableFtpProxyTag);
        this.m_useSocks = this.m_mainPrefDataContext.getDefaultPrefHandler().getBoolean(this.m_useSocksTag);
        this.m_proxyHost = this.m_mainPrefDataContext.getDefaultPrefHandler().getString(this.m_proxyHostTag.key());
        this.m_proxyPort = this.m_mainPrefDataContext.getDefaultPrefHandler().getString(this.m_proxyPortTag.key());
        this.m_socksHost = this.m_mainPrefDataContext.getDefaultPrefHandler().getString(this.m_socksHostTag.key());
        this.m_socksPort = this.m_mainPrefDataContext.getDefaultPrefHandler().getString(this.m_socksPortTag.key());
        this.propertyChanged();
    }

    public void flipUseSocks() {
        this.m_useSocks = !this.m_useSocks;
        this.propertyChanged();
    }

    private void propertyChanged() {
        this.status = this.validateProxySettings();
        this.setValid(this.status.isOK());
        if (this.status.isOK()) {
            this.m_preferencesChanged = true;
        }
    }

    public boolean supportProxy(String protocol) {
        ProxySupport proxySupport = TransferManager.INSTANCE.getProxySupport(protocol);
        return proxySupport != null;
    }

    public String getProxyHost() {
        return this.m_proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.m_proxyHost = proxyHost;
        this.propertyChanged();
    }

    public String getProxyPort() {
        return this.m_proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.m_proxyPort = proxyPort;
        this.propertyChanged();
    }

    public String getSocksHost() {
        return this.m_socksHost;
    }

    public void setSocksHost(String sockHost) {
        this.m_socksHost = sockHost;
        this.propertyChanged();
    }

    public String getSocksPort() {
        return this.m_socksPort;
    }

    public void setSocksPort(String sockPort) {
        this.m_socksPort = sockPort;
        this.propertyChanged();
    }

    public boolean getEnableHttpProxy() {
        return this.m_enableHttpProxy;
    }

    public void setEnableHttpProxy(boolean enableHttpProxy) {
        this.m_enableHttpProxy = enableHttpProxy;
        this.propertyChanged();
    }

    public boolean getUseSocks() {
        return this.m_useSocks;
    }

    public void setUseSocks(boolean useSocks) {
        this.m_useSocks = useSocks;
        this.propertyChanged();
    }

    public void setEnableFtpProxy(boolean enableFtpProxy) {
        this.m_enableFtpProxy = enableFtpProxy;
        this.propertyChanged();
    }

    public boolean getEnableFtpProxy() {
        return this.m_enableFtpProxy;
    }

    private IStatus validateProxySettings() {
        IStatus socksStatus;
        if (this.m_enableHttpProxy) {
            if (!this.m_useSocks) {
                IStatus proxyStatus = this.validateHostPort(this.m_proxyHost, this.m_proxyPort, false);
                if (!proxyStatus.isOK()) {
                    return proxyStatus;
                }
            } else {
                socksStatus = this.validateHostPort(this.m_socksHost, this.m_socksPort, true);
                if (!socksStatus.isOK()) {
                    return socksStatus;
                }
            }
        }
        if (this.m_enableFtpProxy && !(socksStatus = this.validateHostPort(this.m_socksHost, this.m_socksPort, true)).isOK()) {
            return socksStatus;
        }
        return Status.OK_STATUS;
    }

    private IStatus validateHostPort(String host, String port, boolean socks) {
        if (host == null || host.trim().length() == 0) {
            String errorMsg = Messages.PagePreference_Proxy_InvalidHost;
            if (socks) {
                errorMsg = Messages.PagePreference_Socks_InvalidHost;
            }
            return Statuses.ERROR.get(errorMsg, new Object[0]);
        }
        if (port == null || port.trim().length() == 0) {
            return Statuses.ERROR.get(com.ibm.cic.common.core.sharedUI.Messages.ProxyPreferencePage_PortField_OutOfRangeError, new Object[0]);
        }
        int portNum = 0;
        try {
            portNum = Integer.valueOf(port);
        }
        catch (NumberFormatException numberFormatException) {
            portNum = -1;
        }
        if (portNum < 0 || portNum > 65535) {
            return Statuses.ERROR.get(com.ibm.cic.common.core.sharedUI.Messages.ProxyPreferencePage_PortField_OutOfRangeError, new Object[0]);
        }
        return Status.OK_STATUS;
    }

    public IStatus getValidationStatus() {
        return this.status;
    }
}

