/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.manager;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.console.Messages;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtPrefsBase;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtPrefsMain;
import com.ibm.cic.common.core.definitions.CommonDef;
import com.ibm.cic.common.core.downloads.RememberDownloadUserPrompts;
import com.ibm.cic.common.core.preferences.CicPreferenceManager;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.RepositoryGroup;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.core.utils.ConsoleProgressMonitor;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ConDataCtxtPrefsPassportAdvantage
extends ConDataCtxtPrefsBase {
    private final ICicPreferenceConstants.PreferenceTag m_ppaTag = ICicPreferenceConstants.PASSPORT_ADVANTAGE_ENABLED;
    private boolean m_enablePPA = CicPreferenceManager.getInstance().getBoolean(this.m_ppaTag.key());
    private boolean m_forceRefreshPPAConnection = true;
    private IStatus m_connectionStatus = Status.OK_STATUS;

    ConDataCtxtPrefsPassportAdvantage(ConDataCtxtPrefsMain a_mainPreferenceDataContext) {
        super(a_mainPreferenceDataContext);
    }

    public boolean getEnablePPA() {
        return this.m_enablePPA;
    }

    public void connectPPA(boolean enablePPA) {
        if (enablePPA) {
            this.m_connectionStatus = this.connectPPA();
            this.m_enablePPA = this.m_connectionStatus.getSeverity() == 8 ? false : enablePPA;
        } else {
            Agent.getInstance().resetPassportAdvantageRepository();
            this.m_enablePPA = enablePPA;
            this.m_connectionStatus = Status.OK_STATUS;
        }
        this.setValid(!StatusUtil.isErrorOrCancel((IStatus)this.m_connectionStatus));
    }

    public void setEnablePPA(boolean enablePPA) {
        this.connectPPA(enablePPA);
        if (!StatusUtil.isErrorOrCancel((IStatus)this.m_connectionStatus)) {
            this.m_preferencesChanged = true;
        }
    }

    public IStatus getStatus() {
        return this.m_connectionStatus;
    }

    public void setRefreshPPAConnection(boolean forceRefresh) {
        this.m_forceRefreshPPAConnection = forceRefresh;
    }

    public boolean getForceRefreshPPAConnection() {
        return this.m_forceRefreshPPAConnection;
    }

    public void refreshPPAConnection() {
        this.connectPPA(this.m_enablePPA);
        this.m_forceRefreshPPAConnection = false;
    }

    private IStatus connectPPA() {
        IStatus return_result = Status.OK_STATUS;
        IProgressMonitor monitor = ConsoleProgressMonitor.createMonitorWithUnknownWork();
        monitor.beginTask(com.ibm.cic.agent.core.sharedUI.Messages.PreferencePage_PPA_ProgressInfo, -1);
        RememberDownloadUserPrompts rememberPrompts = new RememberDownloadUserPrompts();
        try {
            RepositoryGroup repGroup = RepositoryGroup.getDefault();
            IRepositoryInfo repInfo = RepositoryUtils.createRepInfoForExistingRepository((IRepositoryGroup)repGroup, (String)CommonDef.Urls.EntitledRepositoryUrl, null, (String)"0.0.0.1", (String)CommonDef.Urls.EntitledRepositoryUrl, (String)"");
            repGroup.getFileCacheManager().resetPathTree(repInfo.getLocation());
            IStatus status = RepositoryUtils.addRepositoryOrRefreshStatus((IRepositoryInfo)repInfo, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
            if (status.getSeverity() == 4) {
                return_result = Statuses.ERROR.get(com.ibm.cic.agent.core.sharedUI.Messages.PreferencePage_PPA_connectionFailedMsg, new Object[0]);
            } else if (status.getSeverity() == 8) {
                return_result = new Status(8, Agent.getBundleId(), Messages.PagePreference_PPA_Connect_Cancel);
            } else {
                IRepository repository = repGroup.findRepository(repInfo);
                if (repository == null) {
                    return_result = Statuses.ERROR.get(com.ibm.cic.agent.core.sharedUI.Messages.PreferencePage_PPA_connectionFailedMsg, new Object[0]);
                } else {
                    List offerings = repository.getAllOfferings((IProgressMonitor)new NullProgressMonitor());
                    if (offerings.size() == 0) {
                        return_result = Statuses.ERROR.get(Messages.PreferencePage_PPA_noOfferingsMsg, new Object[0]);
                    }
                }
            }
        }
        finally {
            monitor.done();
            rememberPrompts.forget();
        }
        if (monitor.isCanceled()) {
            return_result = new Status(8, Agent.getBundleId(), Messages.PagePreference_PPA_Connect_Cancel);
        }
        return return_result;
    }

    @Override
    public boolean isPreferenceEditable() {
        return SharedUIUtils.isPreferenceEditable((ICicPreferenceConstants.PreferenceTag)this.m_ppaTag);
    }

    @Override
    public void savePreferences() {
        this.m_mainPrefDataContext.getCurrentPrefHandler().setValue(this.m_ppaTag.key(), this.m_enablePPA);
        Agent.getInstance().addOrRemovePPA(this.m_enablePPA);
        super.savePreferences();
    }

    @Override
    public void restoreDefaults() {
        this.setEnablePPA(this.m_mainPrefDataContext.getDefaultPrefHandler().getBoolean(this.m_ppaTag));
    }
}

