/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.manager;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.sharedUI.OfferingFeatureStatus;
import com.ibm.cic.agent.core.sharedUI.PrerequisiteCheckerUtils;
import com.ibm.cic.common.core.console.manager.AConDataCtxt;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.ConsoleProgressMonitor;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public class ConDataCtxtPreChecks
extends AConDataCtxt {
    private final List<? extends AbstractJob> selectedProductJobs;
    private List<OfferingFeatureStatus> validationStatuses = null;
    private CicMultiStatus preChecksValidationStatus = null;

    public ConDataCtxtPreChecks(List<? extends AbstractJob> selectedJobs) {
        this.selectedProductJobs = AgentUtil.getSelectedProductAbstractJobs(selectedJobs);
    }

    public IStatus getPreChecksValidationStatus() {
        return this.getPreChecksValidationStatus(false);
    }

    public IStatus getPreChecksValidationStatus(boolean recheck) {
        if (this.validationStatuses == null || recheck) {
            this.preChecksValidationStatus = null;
            this.runPrerequisiteChecks();
        }
        if (this.preChecksValidationStatus == null) {
            this.preChecksValidationStatus = Statuses.ST.createMultiStatus();
            for (OfferingFeatureStatus ofs : this.validationStatuses) {
                this.preChecksValidationStatus.addAll((IStatus)ofs.getOfferingValidationSummaryStatus());
            }
        }
        return this.preChecksValidationStatus;
    }

    public List<? extends AbstractJob> getSelectedProductJobs() {
        return this.selectedProductJobs;
    }

    public List<OfferingFeatureStatus> getSelectedProductValidationStatuses() {
        return this.validationStatuses;
    }

    private void runPrerequisiteChecks() {
        IProgressMonitor monitor = ConsoleProgressMonitor.createMonitorWithUnknownWork();
        this.validationStatuses = PrerequisiteCheckerUtils.validateFeatures((IProgressMonitor)monitor, this.selectedProductJobs, (boolean)false, (boolean)false);
    }
}

