/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.manager;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.AbstractVariableSubstitution;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.CacheLocationManager;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.SpaceInfoUtils;
import com.ibm.cic.agent.internal.console.Messages;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtUtils;
import com.ibm.cic.agent.internal.core.AgentPathValidator;
import com.ibm.cic.common.core.console.manager.AConDataCtxt;
import com.ibm.cic.common.core.definitions.ProfileLanguageUtils;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.OfferingProperty;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.ExceptionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class ConDataCtxtInstSharedResourceLocation
extends AConDataCtxt {
    private final List<AbstractJob> m_selectedJobs;
    private final List<AbstractJob> m_selectedProductJobs;
    private final AbstractJob m_installIMJob;
    private IOffering m_imOffering;
    private Profile m_imProfile;
    private String m_sharedResourceLocation;

    public ConDataCtxtInstSharedResourceLocation(List<? extends AbstractJob> selectedJobs) {
        this.m_selectedJobs = selectedJobs;
        this.m_selectedProductJobs = AgentUtil.getSelectedProductAbstractJobs(selectedJobs);
        this.m_installIMJob = this.getInstallIMJob(selectedJobs);
        if (this.m_installIMJob != null) {
            this.m_imOffering = this.m_installIMJob.getOffering();
        }
    }

    public String getSharedResourceLocation() throws AbstractVariableSubstitution.VariableSubstitutionException {
        if (this.m_sharedResourceLocation == null) {
            this.setSharedResourceLocation(CacheLocationManager.getInstance().getEclipseCacheLocation(this.m_selectedProductJobs));
        }
        return this.m_sharedResourceLocation;
    }

    public String getSharedResourceLocationNoExceptions() {
        String return_value = "";
        try {
            return_value = this.getSharedResourceLocation();
        }
        catch (AbstractVariableSubstitution.VariableSubstitutionException e) {
            ExceptionUtil.debugLogToReview((Throwable)e);
        }
        return return_value;
    }

    public void setSharedResourceLocation(String location) {
        if (!location.equals(this.m_sharedResourceLocation)) {
            this.m_sharedResourceLocation = location;
            try {
                CacheLocationManager.getInstance().setCacheLocation(this.m_sharedResourceLocation);
            }
            catch (IllegalArgumentException e) {
                ExceptionUtil.debugLogToReview((Throwable)e);
            }
        }
    }

    public boolean isSharedResourceLocationEditable() {
        return CacheLocationManager.getInstance().isCacheLocationChangeable();
    }

    public ICicStatus validateSharedResourceLocation(String directory) {
        ICicStatus vistaLocationStatus;
        if (directory == null || directory.length() == 0) {
            return Statuses.ERROR.get(Messages.CommonLocationPage_enterCommonDirectory, new Object[0]);
        }
        CicMultiStatus status = Statuses.ST.createMultiStatus();
        IStatus fileNameStatus = PlatformUtils.validatePath((String)directory);
        if (StatusUtil.isErrorOrCancel((IStatus)fileNameStatus)) {
            return Statuses.ERROR.get(Messages.CommonLocationPage_invalidCommonDirectory, new Object[0]);
        }
        if (fileNameStatus.matches(2)) {
            status = Statuses.ST.createMultiStatusFromStatus(fileNameStatus);
        }
        if (!FileUtil.directoryIsWriteable((String)directory)) {
            return Statuses.ERROR.get(String.valueOf(Messages.CommonLocationPage_writableCommonDirectory) + " " + status.getMessage(), new Object[0]);
        }
        IOffering[] ofs = ConDataCtxtUtils.getSelectedProductOfferingArray(this.m_selectedProductJobs);
        ICicStatus cacheLocationStatus = AgentUtil.validateCacheLocation(this.m_selectedJobs, (String)directory, (IOffering[])ofs);
        if (cacheLocationStatus.matches(4) || cacheLocationStatus.matches(8)) {
            return cacheLocationStatus;
        }
        if (cacheLocationStatus.matches(2)) {
            if (status.isOK()) {
                status = Statuses.ST.createMultiStatusFromStatus((IStatus)cacheLocationStatus);
            } else {
                status.add((IStatus)cacheLocationStatus);
            }
        }
        if ((vistaLocationStatus = AgentUtil.validateVistaVirtualizationLocation((String)directory, (IOffering[])ConDataCtxtUtils.getSelectedProductOfferingArray(this.m_selectedProductJobs))).matches(4) || vistaLocationStatus.matches(8)) {
            return vistaLocationStatus;
        }
        if (vistaLocationStatus.matches(2)) {
            if (status.isOK()) {
                status = Statuses.ST.createMultiStatusFromStatus((IStatus)vistaLocationStatus);
            } else {
                status.add((IStatus)vistaLocationStatus);
            }
        }
        status.add(AgentPathValidator.checkSymbolicLinks((String)directory));
        return status;
    }

    public Map<String, String> getDriveAvailableSpace() {
        HashMap<String, String> return_result = new HashMap<String, String>();
        String driveName = PlatformUtils.getLocationDevice((String)this.m_sharedResourceLocation);
        String availableSpace = SpaceInfoUtils.getAvailableSpace((String)driveName);
        return_result.put(driveName, availableSpace);
        if (this.m_imProfile != null) {
            String imLocationVolumeName = PlatformUtils.getLocationDevice((String)this.m_imProfile.getInstallLocation());
            boolean sameVolumeName = driveName.equals(imLocationVolumeName);
            if ("win32".equals(Platform.getOS())) {
                sameVolumeName = driveName.equalsIgnoreCase(imLocationVolumeName);
            }
            if (!sameVolumeName) {
                String imAvailableSpace = SpaceInfoUtils.getAvailableSpace((String)imLocationVolumeName);
                return_result.put(imLocationVolumeName, imAvailableSpace);
            }
        }
        return return_result;
    }

    public boolean hasInstallIMJob() {
        return this.m_installIMJob != null;
    }

    private void createIMProfile() {
        if (this.m_imProfile == null) {
            IOffering agentOffering = Agent.getInstance().getAgentOffering();
            boolean hasAgentInstalled = agentOffering != null;
            Profile profile = Agent.getInstance().getAgentProfile();
            if (profile == null) {
                profile = AgentUtil.makeNewIMProfileForJob((AbstractJob)this.m_installIMJob);
            } else if (!hasAgentInstalled) {
                Agent.getInstance().deleteProfile(profile);
            }
            if (profile.isShadow()) {
                Set supportedLangSet = OfferingProperty.getSupportedLocales((IOffering)this.m_imOffering);
                String supportedLangString = ProfileLanguageUtils.convertCodeSetToString((Set)supportedLangSet);
                String currentLocaleLangs = profile.getData("cic.selector.nl");
                if (currentLocaleLangs == null || currentLocaleLangs.length() == 0) {
                    profile.setData("cic.selector.nl", supportedLangString);
                }
            }
            this.m_imProfile = profile;
            Profile.setLicenseProfileInstallLocation((Profile)this.m_imProfile);
            this.setIMProfileToJob();
        }
    }

    private void setIMProfileToJob() {
        if (this.m_imProfile != null) {
            if (this.m_imProfile.isShadow() && this.m_imOffering != null) {
                int length = Integer.MAX_VALUE;
                int pathLength = PlatformUtils.getMaxInstallLocationLengthForOffering((IOffering)this.m_imOffering);
                if (pathLength < length) {
                    length = pathLength;
                }
                this.m_imProfile.setMaxInstallLocationLength(length);
            }
            if (this.m_installIMJob != null) {
                this.m_installIMJob.setProfile(this.m_imProfile);
            }
        }
    }

    public Profile getIMProfile() {
        if (this.m_imProfile == null) {
            this.createIMProfile();
        }
        return this.m_imProfile;
    }

    public IStatus setIMInstallLocation(String location) {
        String oldLocation = this.m_imProfile.getInstallLocation();
        if (oldLocation.equals(location)) {
            return Status.OK_STATUS;
        }
        IStatus status = this.m_imProfile.setInstallLocation(location);
        if (!StatusUtil.isErrorOrCancel((IStatus)status)) {
            this.m_imProfile.setNeedsRequalification();
            Profile.setLicenseProfileInstallLocation((Profile)this.m_imProfile);
        }
        return status;
    }

    public IStatus validateIMInstallLocation() {
        CicMultiStatus return_status = Statuses.ST.createMultiStatus();
        if (this.m_installIMJob == null) {
            return return_status;
        }
        ArrayList<AbstractJob> agentJobList = new ArrayList<AbstractJob>();
        agentJobList.add(this.m_installIMJob);
        String commonLocation = null;
        try {
            commonLocation = this.getSharedResourceLocation();
        }
        catch (AbstractVariableSubstitution.VariableSubstitutionException variableSubstitutionException) {}
        IStatus status = AgentUtil.validateJobsInstallLocation(agentJobList, (String)commonLocation);
        if (StatusUtil.isErrorOrCancel((IStatus)status)) {
            return status;
        }
        return_status.add(status);
        status = AgentUtil.getOfferingsApplicability(agentJobList);
        if (StatusUtil.isErrorOrCancel((IStatus)status)) {
            return status;
        }
        return_status.add(status);
        status = AgentUtil.validateVistaVirtualizationLocation(agentJobList, (IOffering[])new IOffering[]{this.m_imOffering});
        if (status.matches(4) || status.matches(8)) {
            return status;
        }
        return_status.add(status);
        return return_status;
    }

    private AbstractJob getInstallIMJob(List<? extends AbstractJob> selectedJobs) {
        for (AbstractJob abstractJob : selectedJobs) {
            IOfferingOrFix offeringOrFix = abstractJob.getOfferingOrFix();
            if (!Agent.getInstance().isAgentOffering(offeringOrFix)) continue;
            return abstractJob;
        }
        return null;
    }
}

