/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.manager;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.BitModeUtils;
import com.ibm.cic.agent.core.CommandRecorder;
import com.ibm.cic.agent.core.InstallJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.SortUtil;
import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.agent.core.console.manager.InstalledOfferingsState;
import com.ibm.cic.agent.core.console.manager.SelectedLicensesState;
import com.ibm.cic.agent.core.console.manager.licensePanel.AgentLicensePageData;
import com.ibm.cic.agent.core.internal.headless.AgentInput;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.console.Messages;
import com.ibm.cic.agent.internal.console.manager.AConDataAgentWizard;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtCustomPanelList;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtCustomPanels;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtFeatures;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtInstLocation;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtInstPackageVersionSelector;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtInstSharedResourceLocation;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtLocaleLangs;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtPreChecks;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtUtils;
import com.ibm.cic.agent.internal.console.manager.ConManager;
import com.ibm.cic.agent.internal.console.manager.JobListManager;
import com.ibm.cic.common.core.console.manager.IConDataCtxt;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.shared.manager.licensePanel.LicensePageDataContext;
import com.ibm.cic.common.core.definitions.ProfileLanguageUtils;
import com.ibm.cic.common.core.model.FixUtil;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.FixProperty;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.preferences.CicPreferenceManager;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.RepositoryGroup;
import com.ibm.cic.common.core.repository.ServiceRepositoryUtils;
import com.ibm.cic.common.core.repository.UpdateOfferingUtils;
import com.ibm.cic.common.core.sharedUI.CommonSharedUIUtils;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.ConsoleProgressMonitor;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ConDataCtxtInst
extends AConDataAgentWizard {
    private static final Logger log = Logger.getLogger(ConDataCtxtInst.class);
    private final IConManager m_manager;
    Map<String, List<InstallJob>> m_availableOfferingJobs = null;
    private final Map<InstallJob, FixJobsModel> m_allFixJobModels = new HashMap<InstallJob, FixJobsModel>();
    Map<IFix, InstallJob> m_fixToJobMap = new HashMap<IFix, InstallJob>();
    private final JobListManager<InstallJob> m_selectedJobs = new JobListManager();
    InstallJob m_processedJob = null;
    ConDataCtxtInstPackageVersionSelector m_packageVersionSelector = null;
    LicensePageDataContext m_licesePageContext = null;
    ConDataCtxtInstSharedResourceLocation m_sharedResourceLocationContext = null;
    ConDataCtxtInstLocation m_installLocationContext = null;
    ConDataCtxtLocaleLangs m_localeLangs = null;
    ConDataCtxtFeatures m_installFeaturesContext = null;
    ConDataCtxtCustomPanels m_installCustomPanelsContext = null;
    ConDataCtxtCustomPanelList m_installCustomPanelListCtxt = null;
    ConDataCtxtPreChecks m_prerequisiteChecksCtxt = null;
    private final InstalledOfferingsState installedOfferings;
    boolean searchedOtherVersions = false;

    public ConDataCtxtInst(IConManager a_manager) {
        this.m_manager = a_manager;
        Agent.getInstance().getRepositoryGroupStatus(true, ConsoleProgressMonitor.createMonitorWithUnknownWork());
        this.installedOfferings = new InstalledOfferingsState();
    }

    public <T extends IConDataCtxt> T getAdapter(Class<T> cls) {
        if (cls == ConDataCtxtInstPackageVersionSelector.class) {
            if (this.m_packageVersionSelector == null) {
                this.m_packageVersionSelector = new ConDataCtxtInstPackageVersionSelector(this);
            }
            return (T)((Object)this.m_packageVersionSelector);
        }
        if (cls == LicensePageDataContext.class) {
            if (this.m_licesePageContext == null || this.getSelectedJobs().isChanged()) {
                this.clear();
                SelectedLicensesState licenseState = new SelectedLicensesState(this.installedOfferings, this.m_selectedJobs.toList());
                AgentLicensePageData agentLicensePageData = AgentLicensePageData.create(licenseState);
                this.m_licesePageContext = new LicensePageDataContext(agentLicensePageData.getLicenses());
            }
            return (T)this.m_licesePageContext;
        }
        if (cls == ConDataCtxtPreChecks.class) {
            if (this.m_prerequisiteChecksCtxt == null) {
                this.m_prerequisiteChecksCtxt = new ConDataCtxtPreChecks(this.getSelectedJobs().toList());
            }
            return (T)((Object)this.m_prerequisiteChecksCtxt);
        }
        if (cls == ConDataCtxtInstSharedResourceLocation.class) {
            if (this.m_sharedResourceLocationContext == null) {
                this.m_sharedResourceLocationContext = new ConDataCtxtInstSharedResourceLocation(this.getSelectedJobs().toList());
            }
            return (T)((Object)this.m_sharedResourceLocationContext);
        }
        if (cls == ConDataCtxtInstLocation.class) {
            if (this.m_installLocationContext == null) {
                this.m_installLocationContext = new ConDataCtxtInstLocation(this.getSelectedJobs().toList());
            }
            return (T)((Object)this.m_installLocationContext);
        }
        if (cls == ConDataCtxtLocaleLangs.class) {
            if (this.m_localeLangs == null) {
                this.m_localeLangs = new ConDataCtxtLocaleLangs(this.getSelectedJobs().toList());
            }
            return (T)((Object)this.m_localeLangs);
        }
        if (cls == ConDataCtxtFeatures.class) {
            if (this.m_installFeaturesContext == null) {
                this.m_installFeaturesContext = new ConDataCtxtFeatures(this.getSelectedJobs());
            }
            return (T)((Object)this.m_installFeaturesContext);
        }
        if (cls == ConDataCtxtCustomPanelList.class) {
            if (this.m_installCustomPanelListCtxt == null) {
                this.m_installCustomPanelListCtxt = new ConDataCtxtCustomPanelList(AgentUtil.getSelectedProductAgentJobArray((AgentJob[])this.getSelectedJobs().toArray()));
            }
            return (T)((Object)this.m_installCustomPanelListCtxt);
        }
        if (cls == ConDataCtxtCustomPanels.class) {
            if (this.m_installCustomPanelsContext == null) {
                this.m_installCustomPanelsContext = new ConDataCtxtCustomPanels(AgentUtil.getSelectedProductAgentJobArray((AgentJob[])this.getSelectedJobs().toArray()));
            }
            return (T)((Object)this.m_installCustomPanelsContext);
        }
        return (T)super.getAdapter(cls);
    }

    private void clear() {
        this.m_licesePageContext = null;
        this.m_sharedResourceLocationContext = null;
        this.m_installLocationContext = null;
        this.m_localeLangs = null;
        Agent.getInstance().clearProfileLanguageMap();
        this.m_installFeaturesContext = null;
        this.m_installCustomPanelsContext = null;
        this.m_installCustomPanelListCtxt = null;
        this.m_prerequisiteChecksCtxt = null;
        this.getSelectedJobs().resetChanged();
    }

    public List<InstallJob> getProposedJobs() {
        ArrayList<InstallJob> return_value = new ArrayList();
        Map<String, List<InstallJob>> availableJobs = this.getAvailableOfferingJobs();
        for (List<InstallJob> list : availableJobs.values()) {
            InstallJob selectedJob = null;
            for (InstallJob job : list) {
                if (this.m_selectedJobs.contains(job)) {
                    selectedJob = job;
                    break;
                }
                if (selectedJob != null) {
                    IOfferingOrFix oof;
                    IOfferingOrFix selectedOof = selectedJob.getOfferingOrFix();
                    if (selectedOof.compareVersion((IContent)(oof = job.getOfferingOrFix())) >= 0) continue;
                    selectedJob = job;
                    continue;
                }
                selectedJob = job;
            }
            return_value.add(selectedJob);
        }
        return_value = SortUtil.sortByProfileNameAndVersion(return_value, (boolean)false);
        return return_value;
    }

    public JobListManager<InstallJob> getSelectedJobs() {
        return this.m_selectedJobs;
    }

    public boolean hasSelectedNonRecommendedFix() {
        for (InstallJob fixInstallJob : this.m_selectedJobs.getSelectedFixJobs()) {
            if (FixProperty.isRecommended((IFix)fixInstallJob.getFix())) continue;
            return true;
        }
        return false;
    }

    public boolean isProcessedJobSelected() {
        InstallJob job = this.getProcessedJob();
        if (job != null) {
            return this.getSelectedJobs().contains(job);
        }
        return false;
    }

    public void addSelectedJob(InstallJob a_job) {
        if (this.m_selectedJobs.addJob(a_job)) {
            IProgressMonitor monitor = ConsoleProgressMonitor.createMonitorWithUnknownWork();
            try {
                monitor.beginTask(Messages.General_ConDataCtxt_PrepareAndResolve, -1);
                ArrayList<InstallJob> jobsToPrepare = new ArrayList<InstallJob>();
                jobsToPrepare.add(a_job);
                IStatus status = SharedUIUtils.prepareAndResolveSelectedJobs(jobsToPrepare, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
                log.statusNotOK(status);
            }
            finally {
                monitor.done();
            }
            this.m_selectedJobs.sortByNameAndVersion();
        }
    }

    public void removeSelectedJob(InstallJob a_job) {
        if (this.m_selectedJobs.removeJob(a_job)) {
            IProgressMonitor monitor = ConsoleProgressMonitor.createMonitorWithUnknownWork();
            try {
                IOfferingOrFix oof = a_job.getOfferingOrFix();
                ConDataCtxtUtils.unloadBundlesForOfferingOrFix(oof, monitor);
            }
            finally {
                monitor.done();
            }
        }
    }

    public void removeAllSelectedJobs() {
        List<InstallJob> list = this.m_selectedJobs.toList();
        for (InstallJob job : list) {
            this.removeSelectedJob(job);
        }
    }

    public InstallJob getProcessedJob() {
        return this.m_processedJob;
    }

    public void setProcessedJob(InstallJob a_selectedJob) {
        this.m_processedJob = a_selectedJob;
    }

    public void flipInstallJobSelection() {
        if (this.isProcessedJobSelected()) {
            this.removeSelectedJob(this.getProcessedJob());
        } else {
            this.addSelectedJob(this.getProcessedJob());
        }
    }

    public void setAvailableJobs(AbstractJob[] wizardJobs) {
        AbstractJob job;
        this.m_availableOfferingJobs = new HashMap<String, List<InstallJob>>();
        AbstractJob[] abstractJobArray = wizardJobs;
        int n = wizardJobs.length;
        int n2 = 0;
        while (n2 < n) {
            IOffering offering;
            job = abstractJobArray[n2];
            if (job instanceof InstallJob && (offering = job.getOffering()) != null) {
                String id = offering.getIdentity().getId();
                List list = this.m_availableOfferingJobs.get(id);
                if (list == null) {
                    list = new ArrayList<InstallJob>();
                }
                InstallJob installJob = (InstallJob)job;
                list.add((InstallJob)installJob);
                if (!StatusUtil.isErrorOrCancel((IStatus)this.getJobStatus(installJob)) && job.isSelected()) {
                    this.addSelectedJob(installJob);
                }
                list = SortUtil.sortByNameAndVersion(list);
                this.m_availableOfferingJobs.put(id, list);
                this.initializeFixesModel(installJob);
            }
            ++n2;
        }
        abstractJobArray = wizardJobs;
        n = wizardJobs.length;
        n2 = 0;
        while (n2 < n) {
            InstallJob fixJob;
            IFix fix;
            job = abstractJobArray[n2];
            if (job instanceof InstallJob && (fix = (fixJob = (InstallJob)job).getFix()) != null) {
                this.m_fixToJobMap.put(fix, fixJob);
                Collection<List<InstallJob>> jobList = this.m_availableOfferingJobs.values();
                for (List<InstallJob> offeringJobList : jobList) {
                    for (InstallJob offeringJob : offeringJobList) {
                        IOffering offering = offeringJob.getOffering();
                        if (offering == null || !FixUtil.isFixApplicable((IFix)fix, (IOffering)offering)) continue;
                        this.addNewFixJob(offeringJob, fixJob);
                        if (!fixJob.isSelected()) continue;
                        this.addSelectedJob(fixJob);
                    }
                }
            }
            ++n2;
        }
    }

    public boolean hasRecommendedFixes() {
        List<InstallJob> selectedOfferingJobs = this.getSelectedJobs().getSelectedOfferingJobs();
        for (InstallJob offeringJob : selectedOfferingJobs) {
            List<InstallJob> recommendedFixJobs = this.getFixJobs(offeringJob, true);
            if (recommendedFixJobs == null || recommendedFixJobs.size() <= 0) continue;
            return true;
        }
        return false;
    }

    public List<InstallJob> getFixJobs(InstallJob offeringJob, boolean isRecommendedOnly) {
        FixJobsModel fixesModel = this.getRelevantFixesModel(offeringJob);
        return isRecommendedOnly ? fixesModel.getRecommendedFixJobs() : fixesModel.getAllFixJobs();
    }

    public List<InstallJob> getFixJobs(List<InstallJob> offeringJobs, boolean isRecommendedOnly) {
        ArrayList<InstallJob> result = new ArrayList<InstallJob>();
        for (InstallJob offeringJob : offeringJobs) {
            result.addAll(this.getFixJobs(offeringJob, isRecommendedOnly));
        }
        return result;
    }

    public void addNewFixJob(InstallJob offeringJob, IFix fix) {
        FixJobsModel fixesModel = this.getRelevantFixesModel(offeringJob);
        fixesModel.addFixJob(this.getFixJob(fix));
    }

    public void addNewFixJob(InstallJob offeringJob, InstallJob fixJob) {
        FixJobsModel fixesModel = this.getRelevantFixesModel(offeringJob);
        this.m_fixToJobMap.put(fixJob.getFix(), fixJob);
        fixesModel.addFixJob(fixJob);
    }

    private FixJobsModel getRelevantFixesModel(InstallJob offeringJob) {
        FixJobsModel fixesModel = this.m_allFixJobModels.get(offeringJob);
        if (fixesModel == null) {
            fixesModel = new FixJobsModel(offeringJob);
            fixesModel.updateAndAddFixJobs();
            this.m_allFixJobModels.put(offeringJob, fixesModel);
        }
        return fixesModel;
    }

    private FixJobsModel initializeFixesModel(InstallJob offeringJob) {
        FixJobsModel fixesModel = new FixJobsModel(offeringJob);
        this.m_allFixJobModels.put(offeringJob, fixesModel);
        return fixesModel;
    }

    public Map<String, List<InstallJob>> getAvailableOfferingJobs() {
        if (this.m_availableOfferingJobs == null) {
            this.m_availableOfferingJobs = new LinkedHashMap<String, List<InstallJob>>();
            IProgressMonitor monitor = ConsoleProgressMonitor.createMonitorWithUnknownWork();
            monitor.beginTask(Messages.ProgressDialog_Obtain_offerings, 1);
            try {
                SubProgressMonitor partMonitor = new SubProgressMonitor(monitor, 1);
                List offerings = this.getAllOfferingsAndUpdates((IProgressMonitor)partMonitor);
                HashSet<IOffering> seenOfferings = new HashSet<IOffering>(offerings.size());
                for (IOffering o : offerings) {
                    if (seenOfferings.contains(o) || SharedUIUtils.isHiddenAgentOffering((IOfferingOrFix)o, (AgentInput.getInstance().getMode() == 1 ? 1 : 0) != 0)) continue;
                    String id = o.getIdentity().getId();
                    List list = this.m_availableOfferingJobs.get(id);
                    if (list == null) {
                        list = new ArrayList<InstallJob>();
                    }
                    if (!Agent.getInstance().isAgentOffering((IOfferingOrFix)o)) {
                        InstallJob j = new InstallJob((IOfferingOrFix)o);
                        list.add((InstallJob)j);
                        j.setSelected(false);
                    } else if (list.isEmpty()) {
                        list.add((InstallJob)new InstallJob((IOfferingOrFix)o));
                    } else {
                        InstallJob existingAgentJob = list.get(0);
                        IOffering existingAgentOffering = existingAgentJob.getOffering();
                        if (o.getVersion().compareTo(existingAgentOffering.getVersion()) > 0) {
                            list.clear();
                            list.add(new InstallJob((IOfferingOrFix)o));
                        }
                    }
                    list = SortUtil.sortByNameAndVersion(list);
                    this.m_availableOfferingJobs.put(id, list);
                    seenOfferings.add(o);
                }
            }
            finally {
                monitor.done();
            }
        }
        return this.m_availableOfferingJobs;
    }

    private List getAllOfferingsAndUpdates(IProgressMonitor monitor) {
        return UpdateOfferingUtils.getAllOfferingsAndTheirUpdates((IRepository)Agent.getInstance().getRepositoryGroup(), (boolean)true, (IProgressMonitor)monitor);
    }

    public IStatus getJobStatus(InstallJob job) {
        CicMultiStatus result = Statuses.ST.createMultiStatus();
        boolean displayInternalVersion = CicPreferenceManager.getInstance().getBoolean(ICicPreferenceConstants.DISPLAY_INTERNAL_VERSION.key());
        IOfferingOrFix oof = job.getOfferingOrFix();
        result.add(Agent.getInstance().checkAgentRequirement(oof, displayInternalVersion));
        if (oof instanceof IOffering) {
            IOffering offering = (IOffering)oof;
            result.add(OfferingUtil.supportsConsoleMode((IOffering)offering));
        }
        result.add(BitModeUtils.checkSupportedPlatforms((IOfferingOrFix)oof));
        return result;
    }

    public IStatus getSelectedJobsStatus() {
        IStatus bitnessConflictStatus;
        CicMultiStatus returnStatus = Statuses.ST.createMultiStatus(com.ibm.cic.agent.internal.core.Messages.Agent_unsatisfiedDependencies, new Object[0]);
        List<InstallJob> jobs = this.getSelectedJobs().toList();
        if (BitModeUtils.isMultiBitModePlatform() && StatusUtil.isErrorOrCancel((IStatus)(bitnessConflictStatus = BitModeUtils.checkBitnessConflictAgainstSingleProfile(jobs)))) {
            returnStatus.add(bitnessConflictStatus);
        }
        for (InstallJob job : jobs) {
            IStatus status = this.getJobStatus(job);
            if (!StatusUtil.isErrorOrCancel((IStatus)status)) continue;
            returnStatus.add(status);
        }
        if (returnStatus.getLeaves().length == 1) {
            return returnStatus.getLeaves()[0];
        }
        return returnStatus;
    }

    private void unselectNonRecommendedFixJobs(List<InstallJob> allRecommendedFixJobs) {
        List<InstallJob> selectedFixJobs = this.m_selectedJobs.getSelectedFixJobs();
        ArrayList<InstallJob> selectedNonRecommendedJobs = new ArrayList<InstallJob>(selectedFixJobs.size());
        for (InstallJob fixJob : selectedFixJobs) {
            if (allRecommendedFixJobs.contains(fixJob)) continue;
            selectedNonRecommendedJobs.add(fixJob);
        }
        for (InstallJob selectedNonRecommendedJob : selectedNonRecommendedJobs) {
            this.removeSelectedJob(selectedNonRecommendedJob);
        }
    }

    public void unselectNonRecommendedFixJobs() {
        this.unselectNonRecommendedFixJobs(this.getAllRecommendedFixJobs());
    }

    public void selectRecommendedFixes() {
        List<InstallJob> allRecommendedFixJobs = this.getAllRecommendedFixJobs();
        this.unselectNonRecommendedFixJobs(allRecommendedFixJobs);
        for (InstallJob fixJob : allRecommendedFixJobs) {
            if (this.m_selectedJobs.contains(fixJob) || StatusUtil.isErrorOrCancel((IStatus)this.getJobStatus(fixJob))) continue;
            this.addSelectedJob(fixJob);
        }
    }

    private List<InstallJob> getAllRecommendedFixJobs() {
        List<InstallJob> offeringJobs = this.m_selectedJobs.getSelectedOfferingJobs();
        ArrayList<InstallJob> allRecommendedFixJobs = new ArrayList<InstallJob>();
        if (offeringJobs.isEmpty()) {
            return allRecommendedFixJobs;
        }
        Profile profile = offeringJobs.get(0).getProfile();
        String arch = profile.isInstallLocationChangeable() || profile.isAgentProfile() ? BitModeUtils.getRecommendedProfileArch((AgentJob[])offeringJobs.toArray(new AgentJob[offeringJobs.size()])) : profile.getArch();
        for (InstallJob offeringJob : offeringJobs) {
            List<InstallJob> recommendedFixJobs = this.getFixJobs(offeringJob, true);
            if (recommendedFixJobs == null) continue;
            for (InstallJob fixJob : recommendedFixJobs) {
                if (!BitModeUtils.checkSupportsSpecificPlatform((IOfferingOrFix)fixJob.getFix(), (String)Platform.getOS(), (String)arch)) continue;
                allRecommendedFixJobs.add(fixJob);
            }
        }
        return allRecommendedFixJobs;
    }

    public CommandRecorder getCommandRecorder(boolean a_convertShadowProfiles) {
        ConDataCtxtInstLocation installLocation;
        Profile profile;
        List<InstallJob> jobs = this.getSelectedJobs().toList();
        for (InstallJob j : jobs) {
            j.setAcceptLicense(true);
            j.setSelected(true);
        }
        if (!AgentUtil.onlyInstallAgent(jobs) && (profile = (installLocation = (ConDataCtxtInstLocation)this.m_manager.getDataContext(ConDataCtxtInstLocation.class)).getSelectedProfile()).isShadow()) {
            ConDataCtxtLocaleLangs langs = (ConDataCtxtLocaleLangs)this.m_manager.getDataContext(ConDataCtxtLocaleLangs.class);
            Set<String> codes = langs.getSelectedLangs();
            profile.setData("cic.selector.nl", ProfileLanguageUtils.convertCodeSetToString(codes));
        }
        AgentJob[] jobsToInstall = a_convertShadowProfiles ? AgentUtil.convertShadowProfiles(jobs) : jobs.toArray(new AgentJob[jobs.size()]);
        CommandRecorder commandRecorder = new CommandRecorder();
        commandRecorder.recordJobs(jobsToInstall, true);
        return commandRecorder;
    }

    public IStatus installSelectedPackages() {
        Agent.getInstance().setSkipInstall(CmdLine.CL.containsCommand("-skipInstall"));
        IStatus return_value = ((ConManager)this.m_manager).getConsoleApp().run(this.getCommandRecorder(true).getRecordedCommand(), CmdLine.CL.getParam1StrVal("-record"));
        return return_value;
    }

    public void searchOtherVersions() {
        if (this.searchedOtherVersions) {
            return;
        }
        IProgressMonitor monitor = ConsoleProgressMonitor.createMonitorWithUnknownWork();
        try {
            List offerings = this.getAllOfferingsAndUpdates(monitor);
            HashSet<IOffering> seenOfferings = new HashSet<IOffering>(offerings.size());
            Collection<List<InstallJob>> values = this.m_availableOfferingJobs.values();
            for (List<InstallJob> list : values) {
                for (InstallJob job : list) {
                    IOffering o = job.getOffering();
                    if (o == null) continue;
                    seenOfferings.add(o);
                }
            }
            for (IOffering o : offerings) {
                String id;
                List list;
                if (seenOfferings.contains(o) || (list = this.m_availableOfferingJobs.get(id = o.getIdentity().getId())) == null || "com.ibm.cic.agent".equals(id)) continue;
                list.add((InstallJob)new InstallJob((IOfferingOrFix)o));
                list = SortUtil.sortByNameAndVersion(list);
                this.m_availableOfferingJobs.put(id, list);
                seenOfferings.add(o);
            }
        }
        finally {
            monitor.done();
        }
        this.searchedOtherVersions = true;
    }

    public boolean displaySearchForOtherVersions() {
        if (!this.m_selectedJobs.toList().isEmpty()) {
            return true;
        }
        if (AgentInput.getInstance().getMode() == 1) {
            return false;
        }
        return !this.installedOfferings.isEmpty();
    }

    public IStatus searchServiceRepositories(boolean fixOnly) {
        String resultMsg;
        IStatus resultStatus = Status.OK_STATUS;
        HashMap<String, List<IStatus>> repStatusMap = new HashMap<String, List<IStatus>>();
        ArrayList<IOffering> offeringToSearchServiceRep = new ArrayList<IOffering>();
        if (AgentInput.getInstance().getMode() != 1) {
            offeringToSearchServiceRep.addAll(this.installedOfferings.getOfferings());
        }
        List<IOffering> selectedProductOfferings = this.m_selectedJobs.getSelectedProductOfferings();
        offeringToSearchServiceRep.addAll(selectedProductOfferings);
        RepositoryGroup tempGroup = new RepositoryGroup("searchForOtherVersionsExtensions");
        IRepositoryGroup repositories = Agent.getInstance().getRepositoryGroup();
        ServiceRepositoryUtils.moveServiceRepositories((IRepositoryGroup)tempGroup, (IRepositoryGroup)repositories);
        IProgressMonitor monitor = ConsoleProgressMonitor.createMonitorWithUnknownWork();
        IStatus searchServiceRepStatus = null;
        int newOfferingFixesNum = 0;
        try {
            String progressLabel = com.ibm.cic.agent.core.sharedUI.Messages.PageInstall_searchForOtherVersion_title;
            if (fixOnly) {
                progressLabel = Messages.PageInstallFix_Search;
            }
            monitor.beginTask(progressLabel, -1);
            searchServiceRepStatus = ServiceRepositoryUtils.loadServiceRepositoriesIfPrefIsSet(repStatusMap, (IRepositoryGroup)repositories, (IOffering[])offeringToSearchServiceRep.toArray(new IOffering[offeringToSearchServiceRep.size()]), (IProgressMonitor)new SubProgressMonitor(monitor, 0));
            newOfferingFixesNum = fixOnly ? this.getNewFixNum(monitor) : this.getNewOfferingNum(monitor) + this.getNewFixNum(monitor);
        }
        finally {
            monitor.done();
        }
        if (newOfferingFixesNum > 0) {
            resultMsg = "";
            if (fixOnly) {
                resultMsg = NLS.bind((String)com.ibm.cic.agent.core.sharedUI.Messages.AvailableOfferingSection_oneFixFound, (Object)newOfferingFixesNum);
                if (newOfferingFixesNum > 1) {
                    resultMsg = NLS.bind((String)com.ibm.cic.agent.core.sharedUI.Messages.AvailableOfferingSection_fixesFound, (Object)newOfferingFixesNum);
                }
            } else {
                resultMsg = NLS.bind((String)com.ibm.cic.agent.core.sharedUI.Messages.PageInstall_searchForOtherVersion_1, (Object)newOfferingFixesNum);
                if (newOfferingFixesNum > 1) {
                    resultMsg = NLS.bind((String)com.ibm.cic.agent.core.sharedUI.Messages.PageInstall_searchForOtherVersion_M, (Object)newOfferingFixesNum);
                }
                resultMsg = String.valueOf(resultMsg) + " " + Messages.PageInstall_SearchOtherVersion;
            }
            resultMsg = this.attachMessageFromRepositories(resultMsg, repStatusMap);
            resultStatus = Statuses.INFO.get(resultMsg, new Object[0]);
            this.selectLatestOfferingVersions();
        } else {
            resultMsg = "";
            resultMsg = fixOnly ? com.ibm.cic.agent.core.sharedUI.Messages.AvailableFixSection_noFixFoundMsg : com.ibm.cic.agent.core.sharedUI.Messages.AvailableOfferingSection_noUpdateMessage;
            if (StatusUtil.isErrorOrCancel((IStatus)searchServiceRepStatus)) {
                resultMsg = String.valueOf(resultMsg) + "\n\n";
                resultMsg = fixOnly ? String.valueOf(resultMsg) + com.ibm.cic.agent.core.sharedUI.Messages.PageInstall_searchForFix_connectionError : String.valueOf(resultMsg) + com.ibm.cic.agent.core.sharedUI.Messages.PageInstall_searchForOtherVersion_connectionError;
                resultMsg = this.attachMessageFromRepositories(resultMsg, repStatusMap);
                resultStatus = Statuses.INFO.get(resultMsg, new Object[0]);
            } else {
                resultMsg = this.attachMessageFromRepositories(resultMsg, repStatusMap);
                resultStatus = Statuses.INFO.get(resultMsg, new Object[0]);
            }
        }
        return resultStatus;
    }

    private String attachMessageFromRepositories(String message, Map<String, List<IStatus>> repStatusMap) {
        StringBuffer buffer = new StringBuffer(message);
        String repStatusMessage = CommonSharedUIUtils.constructRepositoryMessages(repStatusMap, (boolean)true);
        if (repStatusMessage.length() > 0) {
            buffer.append("\n\n");
            buffer.append(repStatusMessage);
        }
        return buffer.toString();
    }

    private int getNewOfferingNum(IProgressMonitor monitor) {
        int newOfferingNum = 0;
        if (!monitor.isCanceled()) {
            HashSet<Object> seenOfferingOrFix = new HashSet<Object>();
            Collection<List<InstallJob>> allAvailableOfferingJobs = this.m_availableOfferingJobs.values();
            for (List<InstallJob> listJobs : allAvailableOfferingJobs) {
                for (InstallJob job : listJobs) {
                    IOfferingOrFix offering = job.getOfferingOrFix();
                    if (offering == null) continue;
                    seenOfferingOrFix.add(offering);
                }
            }
            List allOfferings = this.getAllOfferingsAndUpdates((IProgressMonitor)new SubProgressMonitor(monitor, 0));
            for (IOffering o : allOfferings) {
                String id;
                if (seenOfferingOrFix.contains(o) || "com.ibm.cic.agent".equals(id = o.getIdentity().getId())) continue;
                List list = this.m_availableOfferingJobs.get(id);
                if (list == null) {
                    if (Agent.isExtensionOffering((IOfferingOrFix)o)) {
                        list = new ArrayList<InstallJob>();
                        list.add(new InstallJob((IOfferingOrFix)o));
                        ++newOfferingNum;
                    }
                } else {
                    list.add((InstallJob)new InstallJob((IOfferingOrFix)o));
                    ++newOfferingNum;
                }
                if (list != null) {
                    list = SortUtil.sortByNameAndVersion(list);
                    this.m_availableOfferingJobs.put(id, list);
                }
                seenOfferingOrFix.add(o);
            }
        }
        return newOfferingNum;
    }

    private int getNewFixNum(IProgressMonitor monitor) {
        int newFixNum = 0;
        if (!monitor.isCanceled()) {
            HashSet<IFix> seenFixes = new HashSet<IFix>();
            List<InstallJob> allAvailableFixJobsForCurrentSelection = this.getFixJobs(this.m_selectedJobs.getSelectedOfferingJobs(), false);
            for (InstallJob job : allAvailableFixJobsForCurrentSelection) {
                IFix fix = job.getFix();
                if (fix == null) continue;
                seenFixes.add(fix);
            }
            List<InstallJob> selectedOfferingJobs = this.m_selectedJobs.getSelectedOfferingJobs();
            for (InstallJob offeringJob : selectedOfferingJobs) {
                IOffering offering = offeringJob.getOffering();
                if (offering == null) continue;
                List fixes = Agent.getInstance().findFixes(offering, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
                for (IFix f : fixes) {
                    if (!BitModeUtils.checkFixSupportedPlatforms((IFix)f, (IOffering)offering) || seenFixes.contains(f)) continue;
                    this.addNewFixJob(offeringJob, f);
                    seenFixes.add(f);
                    ++newFixNum;
                }
            }
        }
        return newFixNum;
    }

    private void selectLatestOfferingVersions() {
        List<InstallJob> selectedJobs = this.m_selectedJobs.toList();
        for (InstallJob selectedJob : selectedJobs) {
            String id;
            List<InstallJob> jobs;
            InstallJob job;
            IOffering offering;
            IOffering selectedOffering = selectedJob.getOffering();
            if (selectedOffering == null || (offering = (job = (jobs = this.m_availableOfferingJobs.get(id = selectedOffering.getIdentity().getId())).get(jobs.size() - 1)).getOffering()).equals(selectedOffering)) continue;
            this.removeSelectedJob(selectedJob);
            if (StatusUtil.isErrorOrCancel((IStatus)this.getJobStatus(job))) continue;
            this.addSelectedJob(job);
        }
    }

    private InstallJob getFixJob(IFix fix) {
        InstallJob fixJob = this.m_fixToJobMap.get(fix);
        if (fixJob == null) {
            fixJob = new InstallJob((IOfferingOrFix)fix);
            this.m_fixToJobMap.put(fix, fixJob);
        }
        return fixJob;
    }

    class FixJobsModel {
        private final InstallJob offeringJob;
        private List<InstallJob> allFixJobs = new ArrayList<InstallJob>();
        private List<InstallJob> recommendedFixJobs = new ArrayList<InstallJob>();

        List<InstallJob> getAllFixJobs() {
            return this.allFixJobs;
        }

        List<InstallJob> getRecommendedFixJobs() {
            return this.recommendedFixJobs;
        }

        FixJobsModel(InstallJob offeringJob) {
            this.offeringJob = offeringJob;
        }

        void updateAndAddFixJobs() {
            IProgressMonitor monitor = ConsoleProgressMonitor.createMonitorWithUnknownWork();
            monitor.beginTask(Messages.ProgressDialog_Obtain_fixes, 1);
            try {
                SubProgressMonitor partMonitor = new SubProgressMonitor(monitor, 1);
                IOffering offering = this.offeringJob.getOffering();
                List fixes = Agent.getInstance().findFixesForCurrentPlatform(offering, (IProgressMonitor)partMonitor);
                for (IFix fix : fixes) {
                    InstallJob fixJob = ConDataCtxtInst.this.getFixJob(fix);
                    this.addFixJobWithoutSorting(fixJob);
                }
                this.sortLists();
            }
            finally {
                monitor.done();
            }
        }

        void addFixJob(InstallJob fixJob) {
            this.addFixJobWithoutSorting(fixJob);
            this.sortLists();
        }

        private void addFixJobWithoutSorting(InstallJob fixJob) {
            this.allFixJobs.add(fixJob);
            if (FixProperty.isRecommended((IFix)fixJob.getFix())) {
                this.recommendedFixJobs.add(fixJob);
            }
        }

        private void sortLists() {
            this.allFixJobs = SortUtil.sortByNameAndVersion(this.allFixJobs);
            this.recommendedFixJobs = SortUtil.sortByNameAndVersion(this.recommendedFixJobs);
        }
    }
}

