/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.manager;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.ModifyJob;
import com.ibm.cic.agent.core.UpdateOfferingJob;
import com.ibm.cic.agent.internal.console.manager.JobListManager;
import com.ibm.cic.common.core.console.manager.AConDataCtxt;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFeatureBase;
import com.ibm.cic.common.core.model.IFeatureGroup;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.utils.LicenseUtils;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.ConsoleProgressMonitor;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;

public class ConDataCtxtFeatures
extends AConDataCtxt {
    private final List<? extends AgentJob> m_selectedJobs;
    private final List<? extends AgentJob> m_selectedOfferingJobs;
    private final Map<AgentJob, List<IFeature>> m_jobToAllFeatureList;
    private final Map<AgentJob, List<IFeature>> m_jobToAllVisibleFeatures;
    private final Map<AgentJob, Map<IFeature, Boolean>> m_featureToStatus;
    private boolean canMoveNext = true;

    public ConDataCtxtFeatures(JobListManager<? extends AgentJob> selectedJobs) {
        this.m_selectedJobs = selectedJobs.toList();
        this.m_selectedOfferingJobs = selectedJobs.getSelectedOfferingJobs();
        this.m_jobToAllFeatureList = new HashMap<AgentJob, List<IFeature>>();
        this.m_jobToAllVisibleFeatures = new HashMap<AgentJob, List<IFeature>>();
        this.m_featureToStatus = new HashMap<AgentJob, Map<IFeature, Boolean>>();
        this.generateAllFeatureList();
        this.generateDefaultSelectedFeatureList();
        for (AgentJob agentJob : this.m_selectedOfferingJobs) {
            agentJob.resetFeatureStatus();
        }
    }

    public List<IFeature> getAllVisibleFeatures(AgentJob job) {
        return this.m_jobToAllVisibleFeatures.get(job);
    }

    public boolean noVisibleFeatures() {
        return this.m_jobToAllVisibleFeatures.isEmpty();
    }

    public IStatus selectFeature(AgentJob job, IFeature feature, boolean select) {
        CicMultiStatus status = Statuses.ST.createMultiStatus();
        if (!select && feature.isRequired() && !this.isAnyParentGroupNotRequired(feature.getParent())) {
            return status;
        }
        if (select) {
            if (job.canBeSelected((IFeatureBase)feature)) {
                status.add(this.updateFeatureState(job, feature, select));
            }
            status.add(job.getFeatureOrGroupApplicabilityStatus((IFeatureBase)feature));
        } else {
            if (job.canBeRemoved((IFeatureBase)feature)) {
                status.add(this.updateFeatureState(job, feature, select));
            }
            status.add(job.getFeatureOrGroupApplicabilityStatus((IFeatureBase)feature));
        }
        return status;
    }

    private IStatus updateFeatureState(AgentJob job, IFeature feature, boolean select) {
        if (select) {
            job.addFeature(feature);
            Map<IFeature, Boolean> featureStatusMap = this.m_featureToStatus.get(job);
            featureStatusMap.put(feature, Boolean.TRUE);
        } else {
            job.removeFeature(feature);
            Map<IFeature, Boolean> featureStatusMap = this.m_featureToStatus.get(job);
            featureStatusMap.put(feature, Boolean.FALSE);
        }
        return this.checkDiskSpaceInfoStatus();
    }

    public boolean isFeatureSelected(AgentJob job, IFeature feature) {
        Map<IFeature, Boolean> featureToStatusMap = this.m_featureToStatus.get(job);
        if (featureToStatusMap != null) {
            Boolean selected = featureToStatusMap.get(feature);
            if (selected != null) {
                return selected;
            }
            return false;
        }
        return false;
    }

    private void generateDefaultSelectedFeatureList() {
        for (AgentJob agentJob : this.m_selectedOfferingJobs) {
            IOffering offering = agentJob.getOffering();
            if (offering == null || LicenseUtils.isPEKOffering((IOffering)offering)) continue;
            HashMap<IFeature, Boolean> featureStatusMap = new HashMap<IFeature, Boolean>();
            List<IFeature> defaultSelectedFeatures = new ArrayList();
            agentJob.resetFeatures();
            if (agentJob.isInstall()) {
                defaultSelectedFeatures = agentJob.getFeatures();
            } else if (agentJob.isUpdate()) {
                defaultSelectedFeatures.addAll(Arrays.asList(Agent.getInstance().getDefaultFeatures((UpdateOfferingJob)agentJob)));
            } else if (agentJob.isModify()) {
                ModifyJob modifyJob = (ModifyJob)agentJob;
                Set installedFeatures = Agent.getInstance().getInstalledFeatures(modifyJob.getProfile(), offering);
                for (IFeature feature : installedFeatures) {
                    agentJob.addFeature(feature);
                }
                defaultSelectedFeatures.addAll(installedFeatures);
            }
            List<IFeature> allFeatures = this.m_jobToAllFeatureList.get(agentJob);
            for (IFeature feature : allFeatures) {
                if (this.isDefaultSelectedFeature(feature, defaultSelectedFeatures)) {
                    featureStatusMap.put(feature, Boolean.TRUE);
                    continue;
                }
                featureStatusMap.put(feature, Boolean.FALSE);
            }
            this.m_featureToStatus.put(agentJob, featureStatusMap);
        }
    }

    private boolean isDefaultSelectedFeature(IFeature feature, List defaultSelectedFeatureList) {
        int i = 0;
        while (i < defaultSelectedFeatureList.size()) {
            IFeature selectedFeature = (IFeature)defaultSelectedFeatureList.get(i);
            if (feature.equals(selectedFeature)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void generateAllFeatureList() {
        for (AgentJob agentJob : this.m_selectedOfferingJobs) {
            IOffering offering = agentJob.getOffering();
            if (offering == null) continue;
            ArrayList allFeatureList = new ArrayList();
            ArrayList visibleFeatureList = new ArrayList();
            this.collectFeatures(agentJob, offering.getFeatureGroup(), allFeatureList, visibleFeatureList, true);
            this.m_jobToAllFeatureList.put(agentJob, allFeatureList);
            if (visibleFeatureList.isEmpty()) continue;
            this.m_jobToAllVisibleFeatures.put(agentJob, visibleFeatureList);
        }
    }

    private void collectFeatures(AgentJob job, IFeatureGroup group, List allList, List visibleList, boolean visibleGroup) {
        List children = group.getChildren();
        for (IFeatureBase base : children) {
            if (base instanceof IFeature) {
                allList.add(base);
                if (!job.isFeatureOrGroupVisible(base) && (base.isVisible() || !base.isRequired() || !this.isAnyParentGroupNotRequired(group))) continue;
                visibleList.add(base);
                continue;
            }
            if (!(base instanceof IFeatureGroup)) continue;
            this.collectFeatures(job, (IFeatureGroup)base, allList, visibleList, visibleGroup && base.isVisible());
        }
    }

    private boolean isAnyParentGroupNotRequired(IFeatureGroup group) {
        IFeatureGroup gr = group;
        while (gr != null && gr.isRequired()) {
            gr = gr.getParent();
        }
        return gr != null;
    }

    public List<AgentJob> getSelectedOfferingJobs() {
        return Collections.unmodifiableList(this.m_selectedOfferingJobs);
    }

    public IStatus checkDiskSpaceInfoStatus() {
        IStatus status = Agent.getInstance().checkDiskSpaceInfo(this.m_selectedJobs, ConsoleProgressMonitor.createMonitorWithUnknownWork());
        this.canMoveNext = !StatusUtil.isErrorOrCancel((IStatus)status);
        return status;
    }

    public boolean isPageComplete() {
        return this.canMoveNext;
    }
}

