/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.custompanel;

import com.ibm.cic.agent.core.api.ICustomPanel;
import com.ibm.cic.agent.core.custompanel.api.CustomPanelWrapper;
import com.ibm.cic.agent.core.custompanel.api.TemplateCheckBox;
import com.ibm.cic.agent.core.custompanel.api.TemplateConstants;
import com.ibm.cic.agent.core.custompanel.api.TemplateCustomPanel;
import com.ibm.cic.agent.core.custompanel.api.TemplateLabel;
import com.ibm.cic.agent.core.custompanel.api.TemplateProperty;
import com.ibm.cic.agent.core.custompanel.api.TemplatePushButton;
import com.ibm.cic.agent.core.custompanel.api.TemplateRadioButton;
import com.ibm.cic.agent.core.custompanel.api.TemplateRadioGroup;
import com.ibm.cic.agent.core.custompanel.api.TemplateReadonlyList;
import com.ibm.cic.agent.core.custompanel.api.TemplateSelectableList;
import com.ibm.cic.agent.core.custompanel.api.TemplateSelectableWidget;
import com.ibm.cic.agent.core.custompanel.api.TemplateText;
import com.ibm.cic.agent.core.custompanel.api.TemplateWidget;
import com.ibm.cic.agent.core.custompanel.api.TemplateWidgetContainer;
import com.ibm.cic.agent.core.custompanel.template.ICustomPanelGenerator;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.console.custompanel.ConsoleCommandKeyHandler;
import com.ibm.cic.agent.internal.console.custompanel.GeneratedConsoleUICustomPanel;
import com.ibm.cic.common.core.console.actions.AConActionEntry;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.views.ConViewGroup;
import com.ibm.cic.common.core.console.views.ConViewList;
import com.ibm.cic.common.core.console.views.ConViewListEntry;
import com.ibm.cic.common.core.console.views.ConViewListNumbered;
import com.ibm.cic.common.core.console.views.ConViewProperties;
import com.ibm.cic.common.core.console.views.ConViewText;
import com.ibm.cic.common.core.console.views.IConView;
import com.ibm.cic.common.core.sharedUI.CommonSharedUIUtils;
import com.ibm.cic.common.core.utils.StatusUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Status;

public class ConsoleCustomPanelGenerator
implements ICustomPanelGenerator {
    private static final ConsoleCustomPanelGenerator INSTANCE = new ConsoleCustomPanelGenerator();
    private static final int ConstantFromPixelToTab = 15;
    public static final int TemplateSelectableWidgetChildrenIndent = 4;
    private static final int TemplateTextIndent = 15;
    private static final char MaskChar = '*';

    public static ICustomPanelGenerator getInstance() {
        return INSTANCE;
    }

    public ICustomPanel generateCustomPanel(CustomPanelWrapper template) {
        return new GeneratedConsoleUICustomPanel(template);
    }

    public static ConViewGroup createViewForContainer(ConViewGroup parentGroup, TemplateWidgetContainer container) {
        return ConsoleCustomPanelGenerator.createViewForContainer(parentGroup, container, 0);
    }

    public static ConViewGroup createViewForContainer(ConViewGroup parentGroup, TemplateWidgetContainer container, int indent) {
        if (!ConsoleCustomPanelGenerator.isVisibleAndEnabled((TemplateWidget)container)) {
            return null;
        }
        String displayLabel = CommonSharedUIUtils.removeAmpersand((String)container.getDisplayLabel());
        if (displayLabel != null && displayLabel.length() > 0) {
            ConViewText text = new ConViewText(displayLabel, true);
            parentGroup.addView((IConView)text);
        }
        int containerIndent = container.getIndent() / 15;
        ConViewGroup group = new ConViewGroup(indent + containerIndent);
        return group;
    }

    public static ConViewText createViewForLabel(ConViewGroup group, TemplateLabel labelTemplate) {
        if (!ConsoleCustomPanelGenerator.isVisibleAndEnabled((TemplateWidget)labelTemplate)) {
            return null;
        }
        String displayLabel = CommonSharedUIUtils.removeAmpersand((String)labelTemplate.getDisplayLabel());
        TemplateConstants.LabelStyle style = labelTemplate.getStyle();
        if (style == TemplateConstants.LabelStyle.LINK) {
            displayLabel = StatusUtil.combineAnchors((String)displayLabel);
        }
        int indent = labelTemplate.getIndent();
        return new ConViewText(displayLabel, indent / 15);
    }

    public static ConViewList createViewForPushButton(final TemplatePushButton pushButtonTemplate, ConsoleCommandKeyHandler consoleKeyHandler, final CustomPanelWrapper cpTemplate, final GeneratedConsoleUICustomPanel customPanel) {
        if (!ConsoleCustomPanelGenerator.isVisibleAndEnabled((TemplateWidget)pushButtonTemplate)) {
            return null;
        }
        int indent = pushButtonTemplate.getIndent();
        ConViewList pushButtonList = new ConViewList(null, true, false, indent / 15);
        String commandKey = consoleKeyHandler.getCommandKeyForWidget(pushButtonTemplate.getConsoleKey(), pushButtonTemplate.getDisplayLabel());
        final TemplateCustomPanel.UserData userData = pushButtonTemplate.getUserData();
        pushButtonList.addEntry(CommonSharedUIUtils.removeAmpersand((String)pushButtonTemplate.getDisplayLabel()), commandKey, (AConActionEntry)new AConActionEntry<ConViewListEntry>(){

            public void run(IConManager a_conManager) {
                customPanel.setValidationStatus(Status.OK_STATUS);
                customPanel.setPageComplete(true);
                if (pushButtonTemplate.getTriggerUpdate()) {
                    cpTemplate.updateWidgets(userData);
                }
                super.run(a_conManager);
            }
        });
        return pushButtonList;
    }

    public static ConViewList createViewForCheckBox(final TemplateCheckBox checkBoxTemplate, ConsoleCommandKeyHandler consoleKeyHandler, final CustomPanelWrapper customPanelTemplate, final GeneratedConsoleUICustomPanel customPanel) {
        if (!ConsoleCustomPanelGenerator.isVisibleAndEnabled((TemplateWidget)checkBoxTemplate)) {
            return null;
        }
        int indent = checkBoxTemplate.getIndent();
        ConViewList checkBoxList = new ConViewList(null, true, true, indent / 15);
        String commandKey = consoleKeyHandler.getCommandKeyForWidget(checkBoxTemplate.getConsoleKey(), checkBoxTemplate.getDisplayLabel());
        final TemplateCustomPanel.UserData userData = checkBoxTemplate.getUserData();
        ConViewListEntry entry = checkBoxList.addEntry(CommonSharedUIUtils.removeAmpersand((String)checkBoxTemplate.getDisplayLabel()), commandKey, (AConActionEntry)new AConActionEntry<ConViewListEntry>(){

            public void run(IConManager a_conManager) {
                checkBoxTemplate.setSelected(!checkBoxTemplate.isSelected());
                customPanel.setValidationStatus(Status.OK_STATUS);
                customPanel.setPageComplete(true);
                if (checkBoxTemplate.getTriggerUpdate()) {
                    customPanelTemplate.updateWidgets(userData);
                }
                super.run(a_conManager);
            }
        });
        boolean selected = checkBoxTemplate.isSelected();
        entry.setSelected(selected);
        ConsoleCustomPanelGenerator.updateChildrenStatus((TemplateSelectableWidget)checkBoxTemplate, selected);
        return checkBoxList;
    }

    public static ConViewListNumbered createViewForTemplateReadonlyList(TemplateReadonlyList listTemplate, int[] nextAvailableNumber, CustomPanelWrapper customPanelTemplate) {
        if (!ConsoleCustomPanelGenerator.isVisibleAndEnabled((TemplateWidget)listTemplate)) {
            return null;
        }
        int indent = listTemplate.getIndent() / 15;
        ConViewListNumbered listView = new ConViewListNumbered("", false, nextAvailableNumber[0], indent);
        String[] stringArray = listTemplate.getLabels();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String label = stringArray[n2];
            listView.addEntry(label, null);
            ++n2;
        }
        nextAvailableNumber[0] = nextAvailableNumber[0] + listTemplate.getLabels().length;
        return listView;
    }

    public static ConViewListNumbered createViewForTemplateSelectableList(final TemplateSelectableList listTemplate, int[] nextAvailableNumber, final CustomPanelWrapper customPanelTemplate, final GeneratedConsoleUICustomPanel customPanel) {
        if (!ConsoleCustomPanelGenerator.isVisibleAndEnabled((TemplateWidget)listTemplate)) {
            return null;
        }
        int indent = listTemplate.getIndent() / 15;
        ConViewListNumbered listView = new ConViewListNumbered("", true, nextAvailableNumber[0], indent);
        final TemplateCustomPanel.UserData userData = listTemplate.getUserData();
        int i = 0;
        while (i < listTemplate.size()) {
            String displayLabel = listTemplate.getLabel(i);
            ConViewListEntry entry = listView.addEntry(displayLabel, (AConActionEntry)new AConActionEntry<ConViewListEntry>(){

                public void run(IConManager a_conManager) {
                    listTemplate.setSelected((String)((ConViewListEntry)this.getEntry()).getContext());
                    customPanel.setValidationStatus(Status.OK_STATUS);
                    customPanel.setPageComplete(true);
                    if (listTemplate.getTriggerUpdate()) {
                        customPanelTemplate.updateWidgets(userData);
                    }
                }
            }, listTemplate.isSelected(i));
            entry.setContext((Object)listTemplate.getValue(i));
            ++i;
        }
        nextAvailableNumber[0] = nextAvailableNumber[0] + listTemplate.size();
        return listView;
    }

    public static ConViewGroup createViewForRadioButtonGroup(final TemplateRadioGroup radioGroupTemplate, int[] nextAvailableNumber, final CustomPanelWrapper customPanelTemplate, final GeneratedConsoleUICustomPanel customPanel) {
        if (!ConsoleCustomPanelGenerator.isVisibleAndEnabled((TemplateWidget)radioGroupTemplate)) {
            return null;
        }
        int indent = radioGroupTemplate.getIndent() / 15;
        ConViewGroup radioButtonGroupView = new ConViewGroup(indent);
        boolean generateRadioButtonListView = false;
        ConViewListNumbered buttonListView = new ConViewListNumbered("", true, nextAvailableNumber[0], indent);
        final TemplateCustomPanel.UserData userData = radioGroupTemplate.getUserData();
        List radioButtons = radioGroupTemplate.getItems();
        for (TemplateSelectableWidget selectableWidget : radioButtons) {
            if (generateRadioButtonListView) {
                buttonListView = new ConViewListNumbered("", true, nextAvailableNumber[0], indent);
            }
            TemplateRadioButton radioButtonTemplate = (TemplateRadioButton)selectableWidget;
            boolean isSelected = radioButtonTemplate.isSelected();
            ConViewListEntry listEntry = buttonListView.addEntry(CommonSharedUIUtils.removeAmpersand((String)radioButtonTemplate.getDisplayLabel()), (AConActionEntry)new AConActionEntry<ConViewListEntry>(){

                public void run(IConManager a_conManager) {
                    String selectedValue = (String)((ConViewListEntry)this.getEntry()).getContext();
                    userData.setValue(selectedValue);
                    customPanel.setValidationStatus(Status.OK_STATUS);
                    customPanel.setPageComplete(true);
                    if (radioGroupTemplate.getTriggerUpdate() || SharedUIUtils.anyRadioButtonTriggerUpdate((TemplateRadioGroup)radioGroupTemplate)) {
                        customPanelTemplate.updateWidgets(userData);
                    }
                }
            }, isSelected);
            listEntry.setContext((Object)radioButtonTemplate.getSelectedValue());
            nextAvailableNumber[0] = nextAvailableNumber[0] + 1;
            ConsoleCustomPanelGenerator.updateChildrenStatus((TemplateSelectableWidget)radioButtonTemplate, isSelected);
            Map radioButtonChildren = radioButtonTemplate.getChildren();
            if (!radioButtonChildren.isEmpty()) {
                HashMap<TemplateWidgetContainer, TemplateSelectableWidget.DeselectAction> visibleChildren = new HashMap<TemplateWidgetContainer, TemplateSelectableWidget.DeselectAction>();
                for (Map.Entry entry : radioButtonChildren.entrySet()) {
                    TemplateWidgetContainer radioButtonChildrenContainer = (TemplateWidgetContainer)entry.getKey();
                    if (!radioButtonChildrenContainer.getEnabled() || !radioButtonChildrenContainer.getVisible()) continue;
                    visibleChildren.put((TemplateWidgetContainer)entry.getKey(), (TemplateSelectableWidget.DeselectAction)entry.getValue());
                }
                if (visibleChildren.isEmpty()) {
                    generateRadioButtonListView = false;
                    continue;
                }
                generateRadioButtonListView = true;
                radioButtonGroupView.addView((IConView)buttonListView);
                for (Map.Entry entry : visibleChildren.entrySet()) {
                    TemplateWidgetContainer childContainer = (TemplateWidgetContainer)entry.getKey();
                    ConViewGroup childView = ConsoleCustomPanelGenerator.createViewForContainer(radioButtonGroupView, childContainer, 4);
                    if (childView == null) continue;
                    radioButtonGroupView.addView((IConView)childView);
                    customPanel.createChildrenWidgets(childView, childContainer);
                }
                continue;
            }
            generateRadioButtonListView = false;
        }
        if (!generateRadioButtonListView) {
            radioButtonGroupView.addView((IConView)buttonListView);
        }
        return radioButtonGroupView;
    }

    public static ConViewText createViewForTemplateText(TemplateText templateText) {
        if (!ConsoleCustomPanelGenerator.isVisibleAndEnabled((TemplateWidget)templateText)) {
            return null;
        }
        String value = "";
        TemplateConstants.TextStyle style = templateText.getStyle();
        if (style.equals((Object)TemplateConstants.TextStyle.PASSWORD)) {
            char[] pwd = templateText.getProfileValueChars();
            char[] maskedPwd = ConsoleCustomPanelGenerator.maskPassword(pwd);
            value = String.valueOf(maskedPwd);
        } else {
            value = templateText.getProfileValue();
        }
        int indent = templateText.getIndent() / 15;
        return new ConViewText(value, true, indent);
    }

    public static ConViewProperties createViewForTemplateProperty(List<TemplateProperty> properties, List<TemplateProperty> editableProperties) {
        if (editableProperties == null || !editableProperties.isEmpty()) {
            return null;
        }
        for (TemplateProperty templateProperty : properties) {
            if (!ConsoleCustomPanelGenerator.isVisibleAndEnabled((TemplateWidget)templateProperty)) continue;
            editableProperties.add(templateProperty);
        }
        if (editableProperties.isEmpty()) {
            return null;
        }
        TemplateProperty firstProperty = editableProperties.get(0);
        int indent = firstProperty.getIndent() / 15;
        ConViewProperties propertyView = new ConViewProperties(null, null, null, indent, true);
        for (TemplateProperty templateProperty : editableProperties) {
            TemplateCustomPanel.UserData userData = templateProperty.getUserData();
            String key = CommonSharedUIUtils.removeAmpersand((String)templateProperty.getDisplayLabel());
            if (key.endsWith(":")) {
                key = key.substring(0, key.length() - 1);
            }
            String value = "";
            TemplateConstants.TextStyle style = templateProperty.getStyle();
            if (style.equals((Object)TemplateConstants.TextStyle.PASSWORD)) {
                char[] pwd = userData.getValueChars();
                char[] maskedPwd = ConsoleCustomPanelGenerator.maskPassword(pwd);
                value = String.valueOf(maskedPwd);
            } else {
                value = userData.getValue();
            }
            propertyView.addProperty(key, value);
        }
        return propertyView;
    }

    private static char[] maskPassword(char[] pwd) {
        if (pwd != null && pwd.length > 0) {
            char[] maskedPwd = new char[pwd.length];
            Arrays.fill(maskedPwd, '*');
            SharedUIUtils.clearText((char[])pwd);
            return maskedPwd;
        }
        return new char[0];
    }

    private static boolean isVisibleAndEnabled(TemplateWidget widget) {
        return widget.getVisible() && widget.getEnabled();
    }

    private static void updateChildrenStatus(TemplateSelectableWidget selectableWidget, boolean select) {
        Map selectableChildren = selectableWidget.getChildren();
        for (Map.Entry childEntry : selectableChildren.entrySet()) {
            TemplateWidgetContainer childContainer = (TemplateWidgetContainer)childEntry.getKey();
            TemplateSelectableWidget.DeselectAction action = (TemplateSelectableWidget.DeselectAction)childEntry.getValue();
            if (action == TemplateSelectableWidget.DeselectAction.DISABLE) {
                childContainer.enabled(select);
                continue;
            }
            if (action != TemplateSelectableWidget.DeselectAction.HIDE) continue;
            childContainer.visible(select);
        }
    }
}

