/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.console.manager;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.agent.core.console.manager.InstalledOfferingsState;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.LicenseUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SelectedLicensesState {
    private final Map<IOfferingOrFix, String> offeringOrFixLicenseTypeMap;
    private final List<AbstractJob> selectedJobs;
    private final InstalledOfferingsState installedOfferings;

    public SelectedLicensesState(InstalledOfferingsState installedOfferings, List<? extends AbstractJob> alljobs) {
        this.installedOfferings = installedOfferings;
        this.selectedJobs = new ArrayList<AbstractJob>();
        ArrayList<AbstractJob> prodjobs = new ArrayList<AbstractJob>();
        ArrayList<AbstractJob> pekjobs = new ArrayList<AbstractJob>();
        ArrayList<IOffering> pekofferings = new ArrayList<IOffering>();
        for (AbstractJob abstractJob : alljobs) {
            AbstractJob job = abstractJob;
            IOffering offering = job.getOffering();
            if (offering != null && LicenseUtils.isPEKOffering((IOffering)offering)) {
                pekjobs.add(job);
                pekofferings.add(offering);
                continue;
            }
            prodjobs.add(job);
        }
        this.offeringOrFixLicenseTypeMap = new HashMap<IOfferingOrFix, String>();
        for (AbstractJob job : prodjobs) {
            String typeToMap;
            if (!job.isSelected()) continue;
            this.selectedJobs.add(job);
            this.offeringOrFixLicenseTypeMap.put(job.getOfferingOrFix(), "TRIAL");
            IOffering productOffering = job.getOffering();
            if (productOffering == null) continue;
            ArrayList<IOffering> offeringPool = CmdLine.CL.isLiveInput() ? null : pekofferings;
            IOffering[] appliedPEKOfferings = AgentUtil.getApplicablePekOfferings((IOffering)productOffering, offeringPool);
            AbstractJob[] detectedpekjobs = this.detectPEKVersionsToSelect(appliedPEKOfferings, pekjobs);
            IOffering pekOfferingToInstall = null;
            if (detectedpekjobs.length != 0) {
                AbstractJob[] abstractJobArray = detectedpekjobs;
                int n = detectedpekjobs.length;
                int n2 = 0;
                while (n2 < n) {
                    AbstractJob pekjob = abstractJobArray[n2];
                    IOffering pekOffering = pekjob.getOffering();
                    if (pekOffering != null && !AgentUtil.isPekInstalled((IOffering)pekOffering) && !this.selectedJobs.contains(pekjob)) {
                        pekOfferingToInstall = pekOffering;
                        pekjob.setSelected(true);
                        this.selectedJobs.add(pekjob);
                    }
                    ++n2;
                }
            }
            if ((typeToMap = this.determineLicenseTypeToDisplay(pekOfferingToInstall, productOffering, appliedPEKOfferings)) == null) continue;
            this.offeringOrFixLicenseTypeMap.put((IOfferingOrFix)productOffering, typeToMap);
        }
    }

    public AbstractJob[] getSelectedJobs() {
        return this.selectedJobs.toArray(new AbstractJob[this.selectedJobs.size()]);
    }

    public Map<IOfferingOrFix, String> getOfferingOrFixLicenseTypeMap() {
        return this.offeringOrFixLicenseTypeMap;
    }

    private AbstractJob[] detectPEKVersionsToSelect(IOffering[] pekofferings, List pekjobs) {
        ArrayList<AbstractJob> result = new ArrayList<AbstractJob>();
        IOffering[] iOfferingArray = pekofferings;
        int n = pekofferings.length;
        int n2 = 0;
        while (n2 < n) {
            IOffering pekoffering = iOfferingArray[n2];
            for (AbstractJob pekjob : pekjobs) {
                IOffering joboffering = pekjob.getOffering();
                if (joboffering == null || !joboffering.equals(pekoffering)) continue;
                result.add(pekjob);
            }
            ++n2;
        }
        return result.toArray(new AbstractJob[result.size()]);
    }

    private String determineLicenseTypeToDisplay(IOffering pekOfferingToInstall, IOffering productOffering, IOffering[] appliedPEKOfferings) {
        String[] licenseType;
        String typeToMap = null;
        if (pekOfferingToInstall != null) {
            String[] licenseType2 = LicenseUtils.getUnlocalizedLicenseKindsArray((IOffering)pekOfferingToInstall);
            if (licenseType2 != null && licenseType2.length > 0) {
                if (licenseType2[0].equals("perm")) {
                    typeToMap = "PERMANENT";
                } else if (licenseType2[0].equals("term")) {
                    typeToMap = "TERM";
                }
            }
        } else if (this.installedOfferings.isInstalled(productOffering)) {
            String[] runtimeType = LicenseUtils.getRuntimeLicenseKindsArray((IOffering)productOffering, (int)1);
            if (runtimeType != null && runtimeType.length > 0) {
                if (runtimeType[0] != null && runtimeType[0].equals(LicenseUtils.LICENSE_TYPE_PERM)) {
                    typeToMap = "PERMANENT";
                } else if (runtimeType[0] != null && runtimeType[0].equals(LicenseUtils.LICENSE_TYPE_TERM)) {
                    typeToMap = "TERM";
                } else if (runtimeType[0] != null && runtimeType[0].equals(LicenseUtils.LICENSE_TYPE_FLOATING)) {
                    typeToMap = "FLOATING";
                }
            }
        } else if (appliedPEKOfferings.length > 0 && (licenseType = LicenseUtils.getLicenseKindsArray((IOffering[])appliedPEKOfferings, (boolean)false)) != null && licenseType.length > 0) {
            if (licenseType[0].equals("perm")) {
                typeToMap = "PERMANENT";
            } else if (licenseType[0].equals("term")) {
                typeToMap = "TERM";
            }
        }
        return typeToMap;
    }
}

