/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.console.manager;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOffering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class InstalledOfferingsState {
    private final HashSet<IOffering> installedOfferings;

    public InstalledOfferingsState() {
        this(true);
    }

    public InstalledOfferingsState(boolean checkInstalledOfferings) {
        this.installedOfferings = checkInstalledOfferings ? InstalledOfferingsState.getInstalledProductOfferings() : new HashSet(0);
    }

    public static HashSet<IOffering> getInstalledProductOfferings() {
        HashSet<IOffering> installedOfferings = new HashSet<IOffering>();
        Profile[] profiles = Agent.getInstance().getProfiles();
        int i = 0;
        while (i < profiles.length) {
            if (!profiles[i].isAgentProfile() && !profiles[i].isLicenseProfile()) {
                IOffering[] offerings;
                IOffering[] iOfferingArray = offerings = Agent.getInstance().getInstalledOfferings(profiles[i]);
                int n = offerings.length;
                int n2 = 0;
                while (n2 < n) {
                    IOffering offering = iOfferingArray[n2];
                    installedOfferings.add(offering);
                    ++n2;
                }
            }
            ++i;
        }
        return installedOfferings;
    }

    public boolean isEmpty() {
        return this.installedOfferings.isEmpty();
    }

    public boolean isInstalled(IOffering offering) {
        return this.installedOfferings.contains(offering);
    }

    public Collection<IOffering> getOfferings() {
        return Collections.unmodifiableCollection(this.installedOfferings);
    }

    public boolean isInstalled(IIdentity id) {
        for (IOffering element : this.installedOfferings) {
            IOffering installedOffering = element;
            if (!installedOffering.getIdentity().equals(id)) continue;
            return true;
        }
        return false;
    }

    public List<IOffering> getInstalledList(IIdentity id) {
        ArrayList<IOffering> return_result = new ArrayList<IOffering>();
        for (IOffering element : this.installedOfferings) {
            IOffering installedOffering = element;
            if (!installedOffering.getIdentity().equals(id)) continue;
            return_result.add(installedOffering);
        }
        return return_result;
    }

    public IOffering getInstalled(IIdentity id) {
        for (IOffering element : this.installedOfferings) {
            IOffering installedOffering = element;
            if (!installedOffering.getIdentity().equals(id)) continue;
            return installedOffering;
        }
        return null;
    }
}

