/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig.dom;

import com.ibm.xml.crypto.dsig.dom.AlgorithmFactory;
import com.ibm.xml.crypto.dsig.dom.DigestMethodImpl;
import com.ibm.xml.crypto.dsig.dom.ManifestImpl;
import com.ibm.xml.crypto.dsig.dom.ObjectImpl;
import com.ibm.xml.crypto.dsig.dom.ReferenceImpl;
import com.ibm.xml.crypto.dsig.dom.SignatureMethodImpl;
import com.ibm.xml.crypto.dsig.dom.SignaturePropertiesImpl;
import com.ibm.xml.crypto.dsig.dom.SignaturePropertyImpl;
import com.ibm.xml.crypto.dsig.dom.SignedInfoImpl;
import com.ibm.xml.crypto.dsig.dom.URIDereferencerImpl;
import com.ibm.xml.crypto.dsig.dom.Unmarshalling;
import com.ibm.xml.crypto.dsig.dom.XMLSignatureImpl;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Manifest;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignatureProperties;
import javax.xml.crypto.dsig.SignatureProperty;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.XMLValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.DigestMethodParameterSpec;
import javax.xml.crypto.dsig.spec.SignatureMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;

public class FactoryImpl
extends XMLSignatureFactory {
    private AlgorithmFactory afactory = null;

    protected void setAlgorithmFactory(AlgorithmFactory af) {
        this.afactory = af;
    }

    public AlgorithmFactory getAlgorithmFactory() {
        if (this.afactory == null) {
            this.afactory = AlgorithmFactory.getInstance();
        }
        return this.afactory;
    }

    public XMLSignature newXMLSignature(SignedInfo si, KeyInfo ki) {
        return this.newXMLSignature(si, ki, (List)null, (String)null, (String)null);
    }

    public XMLSignature newXMLSignature(SignedInfo si, KeyInfo ki, List objects, String id, String signatureValueId) {
        return new XMLSignatureImpl(this.getAlgorithmFactory(), si, ki, objects, id, signatureValueId);
    }

    public Reference newReference(String uri, DigestMethod dm) {
        return this.newReference(uri, dm, (List)null, (String)null, (String)null);
    }

    public Reference newReference(String uri, DigestMethod dm, List transforms, String type, String id) {
        return new ReferenceImpl(this.getAlgorithmFactory(), uri, dm, null, null, transforms, type, id, null);
    }

    public Reference newReference(String uri, DigestMethod dm, List transforms, String type, String id, byte[] digestValue) {
        if (digestValue == null) {
            throw new NullPointerException("'byte[] digestValue' is null.");
        }
        return new ReferenceImpl(this.getAlgorithmFactory(), uri, dm, null, null, transforms, type, id, digestValue);
    }

    public Reference newReference(String uri, DigestMethod dm, List applied, Data result, List transforms, String type, String id) {
        if (applied == null) {
            throw new NullPointerException("'List appliedTransforms' is null.");
        }
        if (result == null) {
            throw new NullPointerException("'Data result' is null.");
        }
        return new ReferenceImpl(this.getAlgorithmFactory(), uri, dm, applied, result, transforms, type, id, null);
    }

    public SignedInfo newSignedInfo(CanonicalizationMethod cm, SignatureMethod sm, List references) {
        return this.newSignedInfo(cm, sm, references, (String)null);
    }

    public SignedInfo newSignedInfo(CanonicalizationMethod cm, SignatureMethod sm, List references, String id) {
        return new SignedInfoImpl(this.getAlgorithmFactory(), cm, sm, references, id);
    }

    public XMLObject newXMLObject(List content, String id, String mimeType, String encoding) {
        return new ObjectImpl(this.getAlgorithmFactory(), content, id, mimeType, encoding);
    }

    public Manifest newManifest(List references) {
        return this.newManifest(references, (String)null);
    }

    public Manifest newManifest(List references, String id) {
        return new ManifestImpl(this.getAlgorithmFactory(), references, id);
    }

    public SignatureProperty newSignatureProperty(List content, String target, String id) {
        return new SignaturePropertyImpl(this.getAlgorithmFactory(), content, target, id);
    }

    public SignatureProperties newSignatureProperties(List properties, String id) {
        return new SignaturePropertiesImpl(this.getAlgorithmFactory(), properties, id);
    }

    public DigestMethod newDigestMethod(String algorithm, DigestMethodParameterSpec params) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (algorithm == null) {
            throw new NullPointerException("Algorithm is null");
        }
        AlgorithmFactory f = this.getAlgorithmFactory();
        return new DigestMethodImpl(this.getAlgorithmFactory(), algorithm, params);
    }

    public SignatureMethod newSignatureMethod(String algorithm, SignatureMethodParameterSpec params) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (algorithm == null) {
            throw new NullPointerException("Algorithm is null");
        }
        AlgorithmFactory f = this.getAlgorithmFactory();
        return new SignatureMethodImpl(this.getAlgorithmFactory(), algorithm, params);
    }

    public Transform newTransform(String algorithm, TransformParameterSpec params) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (algorithm == null) {
            throw new NullPointerException("Algorithm is null");
        }
        TransformService ts = TransformService.getInstance(algorithm, this.getMechanismType());
        ts.init(params);
        return ts;
    }

    public Transform newTransform(String algorithm, XMLStructure xsparams) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (algorithm == null) {
            throw new NullPointerException("Algorithm is null");
        }
        TransformService ts = TransformService.getInstance(algorithm, this.getMechanismType());
        if (xsparams == null) {
            ts.init(null);
        } else {
            ts.init(xsparams, null);
        }
        return ts;
    }

    public CanonicalizationMethod newCanonicalizationMethod(String algorithm, C14NMethodParameterSpec params) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (algorithm == null) {
            throw new NullPointerException("Algorithm is null");
        }
        TransformService ts = TransformService.getInstance(algorithm, this.getMechanismType());
        ts.init(params);
        return (CanonicalizationMethod)((Object)ts);
    }

    public CanonicalizationMethod newCanonicalizationMethod(String algorithm, XMLStructure xsparams) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (algorithm == null) {
            throw new NullPointerException("Algorithm is null");
        }
        TransformService ts = TransformService.getInstance(algorithm, this.getMechanismType());
        if (xsparams == null) {
            ts.init(null);
        } else {
            ts.init(xsparams, null);
        }
        return (CanonicalizationMethod)((Object)ts);
    }

    public XMLSignature unmarshalXMLSignature(XMLValidateContext context) throws MarshalException {
        return Unmarshalling.unmarshal((XMLSignatureFactory)this, context);
    }

    public XMLSignature unmarshalXMLSignature(XMLStructure sig) throws MarshalException {
        return Unmarshalling.unmarshal((XMLSignatureFactory)this, sig);
    }

    public boolean isFeatureSupported(String feature) {
        if (feature == null) {
            throw new NullPointerException("feature must not be null.");
        }
        return false;
    }

    public URIDereferencer getURIDereferencer() {
        return URIDereferencerImpl.getInstance();
    }
}

