/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.tools.ddrinteractive.commands;

import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm26.structure.ExtendedMethodBlockConsts;
import com.ibm.j9ddr.vm26.types.U64;
import java.io.PrintStream;

public class ExtendedMethodFlagInfoCommand
extends Command {
    public ExtendedMethodFlagInfoCommand() {
        this.addCommand("j9extendedmethodflaginfo", "<flags>", "give information about extended method flags");
    }

    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        U64 flags = new U64(Long.decode(args[0]));
        if (flags.anyBitsIn(ExtendedMethodBlockConsts.J9_RAS_METHOD_UNSEEN)) {
            out.println("J9_RAS_METHOD_UNSEEN");
        }
        if (flags.anyBitsIn(ExtendedMethodBlockConsts.J9_RAS_METHOD_SEEN)) {
            out.println("J9_RAS_METHOD_SEEN");
        }
        if (flags.anyBitsIn(ExtendedMethodBlockConsts.J9_RAS_METHOD_TRACING)) {
            out.println("J9_RAS_METHOD_TRACING");
        }
        if (flags.anyBitsIn(ExtendedMethodBlockConsts.J9_RAS_METHOD_TRACE_ARGS)) {
            out.println("J9_RAS_METHOD_TRACE_ARGS");
        }
        if (flags.anyBitsIn(ExtendedMethodBlockConsts.J9_RAS_METHOD_TRIGGERING)) {
            out.println("J9_RAS_METHOD_TRIGGERING");
        }
        if (flags.anyBitsIn(ExtendedMethodBlockConsts.J9_JVMTI_METHOD_SELECTIVE_ENTRY_EXIT)) {
            out.println("J9_JVMTI_METHOD_SELECTIVE_ENTRY_EXIT");
        }
    }
}

