/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm26.j9.Pool;
import com.ibm.j9ddr.vm26.j9.gc.GCClassLoaderIterator;
import com.ibm.j9ddr.vm26.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm26.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9HashTablePointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9PoolPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9PoolPuddlePointer;
import java.io.PrintStream;

public class DumpAllClassloadersCommand
extends Command {
    public DumpAllClassloadersCommand() {
        this.addCommand("dumpallclassloaders", "", "dump all class loaders");
    }

    private void printUsage(PrintStream out) {
        out.println("dumpallclassloaders - dump all class loaders");
    }

    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        if (args.length != 0) {
            this.printUsage(out);
            return;
        }
        try {
            if (J9BuildFlags.env_data64) {
                out.append("+------------------------------------------------------------------------- \n");
                out.append("|    ClassLoader    | SharedLibraries | ClassHashTable  |   jniIDs Pool   |\n");
                out.append("|                   |      Pool       |                 |                 |\n");
                out.append("|                   |-----------------+-----------------+-----------------| \n");
                out.append("|      Address      | used | capacity | used | capacity | used | capacity |\n");
                out.append("+-------------------+-----------------+-----------------+----------------- \n");
            } else {
                out.append("+----------------------------------------------------------------- \n");
                out.append("|ClassLoader| SharedLibraries | ClassHashTable  |   jniIDs Pool   |\n");
                out.append("|           |      Pool       |                 |                 |\n");
                out.append("|           |-----------------+-----------------+-----------------| \n");
                out.append("| Address   | used | capacity | used | capacity | used | capacity |\n");
                out.append("+-----------+-----------------+-----------------+----------------- \n");
            }
            GCClassLoaderIterator iterator = GCClassLoaderIterator.from();
            while (iterator.hasNext()) {
                long jniIDsPoolCapacity;
                long jniIDsPoolNumOfelements;
                long classHashTableCapacity;
                long classHashTableNumOfelements;
                Pool<J9PoolPuddlePointer> pool;
                long sharedLibPoolCapacity;
                long sharedLibPoolNumOfelements;
                J9ClassLoaderPointer classLoaderPointer = iterator.next();
                String classLoaderAddress = classLoaderPointer.getHexAddress();
                J9PoolPointer sharedLibraries = classLoaderPointer.sharedLibraries();
                if (!sharedLibraries.isNull()) {
                    Pool<J9PoolPuddlePointer> pool2 = Pool.fromJ9Pool(sharedLibraries, J9PoolPuddlePointer.class);
                    sharedLibPoolNumOfelements = pool2.numElements();
                    sharedLibPoolCapacity = pool2.capacity();
                } else {
                    sharedLibPoolNumOfelements = 0L;
                    sharedLibPoolCapacity = 0L;
                }
                J9HashTablePointer classHashTable = classLoaderPointer.classHashTable();
                if (!classHashTable.isNull()) {
                    if (!classHashTable.nodePool().isNull()) {
                        J9PoolPointer nodePool = classHashTable.nodePool();
                        pool = Pool.fromJ9Pool(nodePool, J9PoolPuddlePointer.class);
                        classHashTableNumOfelements = pool.numElements();
                        classHashTableCapacity = pool.capacity();
                    } else {
                        classHashTableNumOfelements = classHashTable.numberOfNodes().longValue();
                        classHashTableCapacity = classHashTable.tableSize().longValue();
                    }
                } else {
                    classHashTableNumOfelements = 0L;
                    classHashTableCapacity = 0L;
                }
                J9PoolPointer jniIDs = classLoaderPointer.jniIDs();
                if (!jniIDs.isNull()) {
                    pool = Pool.fromJ9Pool(jniIDs, J9PoolPuddlePointer.class);
                    jniIDsPoolNumOfelements = pool.numElements();
                    jniIDsPoolCapacity = pool.capacity();
                } else {
                    jniIDsPoolNumOfelements = 0L;
                    jniIDsPoolCapacity = 0L;
                }
                String output = this.format(classLoaderAddress, sharedLibPoolNumOfelements, sharedLibPoolCapacity, classHashTableNumOfelements, classHashTableCapacity, jniIDsPoolNumOfelements, jniIDsPoolCapacity);
                out.println(output);
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    private String format(String addr, long used1, long capacity1, long used2, long capacity2, long used3, long capacity3) {
        String format = " %s%4d%" + (7 - Long.toString(used1).length() + Long.toString(capacity1).length()) + "d" + "%" + (11 - Long.toString(capacity1).length() + Long.toString(used2).length()) + "d" + "%" + (7 - Long.toString(used2).length() + Long.toString(capacity2).length()) + "d" + "%" + (11 - Long.toString(capacity2).length() + Long.toString(used3).length()) + "d" + "%" + (7 - Long.toString(used3).length() + Long.toString(capacity3).length()) + "d";
        String output = String.format(format, addr, used1, capacity1, used2, capacity2, used3, capacity3);
        return output;
    }
}

