/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.pointer.generated;

import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.vm26.pointer.AbstractPointer;
import com.ibm.j9ddr.vm26.pointer.generated.RawChunkPointer;
import com.ibm.j9ddr.vm26.structure.Chunk;
import com.ibm.j9ddr.vm26.types.Scalar;
import com.ibm.j9ddr.vm26.types.UDATA;

@GeneratedPointerClass(structureClass=Chunk.class)
public class ChunkPointer
extends RawChunkPointer {
    public static final ChunkPointer NULL = new ChunkPointer(0L);
    private static final boolean CACHE_FIELDS = false;
    private static final boolean CACHE_CLASS = false;

    protected ChunkPointer(long address) {
        super(address);
    }

    public static ChunkPointer cast(AbstractPointer structure) {
        return ChunkPointer.cast(structure.getAddress());
    }

    public static ChunkPointer cast(UDATA udata) {
        return ChunkPointer.cast(udata.longValue());
    }

    public static ChunkPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new ChunkPointer(address);
    }

    public ChunkPointer add(long count) {
        return ChunkPointer.cast(this.address + Chunk.SIZEOF * count);
    }

    public ChunkPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    public ChunkPointer addOffset(long offset) {
        return ChunkPointer.cast(this.address + offset);
    }

    public ChunkPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    public ChunkPointer sub(long count) {
        return ChunkPointer.cast(this.address - Chunk.SIZEOF * count);
    }

    public ChunkPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    public ChunkPointer subOffset(long offset) {
        return ChunkPointer.cast(this.address - offset);
    }

    public ChunkPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    public ChunkPointer untag(long mask) {
        return ChunkPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public ChunkPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    protected long sizeOfBaseType() {
        return Chunk.SIZEOF;
    }
}

