/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.j9.walkers;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm26.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm26.j9.Pool;
import com.ibm.j9ddr.vm26.j9.walkers.ArrayIterator;
import com.ibm.j9ddr.vm26.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9HashTablePointer;
import com.ibm.j9ddr.vm26.structure.J9PackageIDTableEntry;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassIterator
implements Iterator<J9ClassPointer> {
    private static final AlgorithmVersion version;
    protected static final Logger logger;
    private final Iterator<J9ClassPointer> iterator;
    private J9ClassPointer next = null;

    protected ClassIterator(Iterator<J9ClassPointer> iterator) {
        this.iterator = iterator;
    }

    public static Iterator<J9ClassPointer> fromJ9Classloader(J9ClassLoaderPointer loader) throws CorruptDataException {
        J9HashTablePointer table = loader.classHashTable();
        Iterator<J9ClassPointer> iterator = null;
        switch (version.getVMMinorVersion()) {
            case 30: {
                logger.fine("Creating version 2.3.0 class walker");
                iterator = Pool.fromJ9Pool(table.nodePool(), J9ClassPointer.class, false).iterator();
                return iterator;
            }
            case 60: {
                logger.fine("Creating version 2.6.0 class walker");
                if (table.nodePool().notNull()) {
                    iterator = new ClassIterator(Pool.fromJ9Pool(table.nodePool(), J9ClassPointer.class, false).iterator());
                    break;
                }
                iterator = new ArrayIterator(J9ClassPointer.class, table.tableSize().intValue(), table.nodes()).iterator();
                break;
            }
            default: {
                iterator = Pool.fromJ9Pool(table.nodePool(), J9ClassPointer.class, false).iterator();
            }
        }
        return new ClassIterator(iterator);
    }

    @Override
    public boolean hasNext() {
        if (this.next == null) {
            this.setNextItem();
        }
        if (this.next == null) {
            return true;
        }
        return this.next.notNull();
    }

    private void setNextItem() {
        this.next = J9ClassPointer.NULL;
        if (this.iterator.hasNext()) {
            block0 : switch (version.getVMMinorVersion()) {
                case 60: {
                    do {
                        this.next = this.iterator.next();
                        if (this.next == null || this.next.isNull()) break block0;
                        if ((this.next.getAddress() & J9PackageIDTableEntry.J9PACKAGE_ID_TAG) == 0L) continue;
                        this.next = J9ClassPointer.NULL;
                    } while (this.next.isNull() && this.iterator.hasNext());
                    break;
                }
                default: {
                    this.next = this.iterator.next();
                }
            }
        }
    }

    @Override
    public J9ClassPointer next() {
        if (this.next == null) {
            this.setNextItem();
        }
        if (this.hasNext()) {
            J9ClassPointer ptr = this.next;
            this.setNextItem();
            return ptr;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    static {
        logger = Logger.getLogger("j9ddr.walkers");
        version = AlgorithmVersion.getVersionOf("ALG_POOL_VERSION");
    }
}

