/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.j9.stackwalker;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm26.j9.ROMHelp;
import com.ibm.j9ddr.vm26.j9.stackwalker.FrameCallbackResult;
import com.ibm.j9ddr.vm26.j9.stackwalker.IStackWalkerCallbacks;
import com.ibm.j9ddr.vm26.j9.stackwalker.StackWalkerUtils;
import com.ibm.j9ddr.vm26.j9.stackwalker.WalkState;
import com.ibm.j9ddr.vm26.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm26.pointer.PointerPointer;
import com.ibm.j9ddr.vm26.pointer.VoidPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm26.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm26.structure.J9SFStackFrame;

public class TerseStackWalkerCallbacks
implements IStackWalkerCallbacks {
    public FrameCallbackResult frameWalkFunction(J9VMThreadPointer walkThread, WalkState walkState) {
        try {
            if (walkState.method.notNull()) {
                J9MethodPointer method = walkState.method;
                J9UTF8Pointer className = StackWalkerUtils.UNTAGGED_METHOD_CP(method).ramClass().romClass().className();
                J9ROMMethodPointer romMethod = ROMHelp.J9_ROM_METHOD_FROM_RAM_METHOD(method);
                J9UTF8Pointer name = romMethod.nameAndSignature().name();
                J9UTF8Pointer sig = romMethod.nameAndSignature().signature();
                StackWalkerUtils.swPrintf(walkState, 0, "\t!j9method {3}   {0}.{1}{2}", J9UTF8Helper.stringValue(className), J9UTF8Helper.stringValue(name), J9UTF8Helper.stringValue(sig), walkState.method.getHexAddress());
                return FrameCallbackResult.KEEP_ITERATING;
            }
            if (walkState.pc.getAddress() == J9SFStackFrame.J9SF_FRAME_TYPE_JNI_NATIVE_METHOD) {
                StackWalkerUtils.swPrintf(walkState, 0, "\t                        Native method frame", new Object[0]);
            } else if (walkState.pc.getAddress() == J9SFStackFrame.J9SF_FRAME_TYPE_GENERIC_SPECIAL) {
                StackWalkerUtils.swPrintf(walkState, 0, "\t                        Generic special frame", new Object[0]);
            } else if (walkState.pc.getAddress() > J9SFStackFrame.J9SF_MAX_SPECIAL_FRAME_TYPE) {
                if (walkState.pc.getAddress() == walkState.walkThread.javaVM().callInReturnPC().getAddress() || walkState.pc.getAddress() == walkState.walkThread.javaVM().callInReturnPC().getAddress() + 3L) {
                    StackWalkerUtils.swPrintf(walkState, 0, "\t                        JNI call-in frame", new Object[0]);
                } else {
                    StackWalkerUtils.swPrintf(walkState, 0, "\t                        unknown frame type {0} *{1}", walkState.pc, walkState.pc.getHexAddress());
                }
            } else {
                StackWalkerUtils.swPrintf(walkState, 0, "\t                        known but unhandled frame type {0}", walkState.pc);
            }
        }
        catch (CorruptDataException e) {
            e.printStackTrace();
        }
        return FrameCallbackResult.KEEP_ITERATING;
    }

    public void objectSlotWalkFunction(J9VMThreadPointer walkThread, WalkState walkState, PointerPointer objectSlot, VoidPointer stackLocation) {
    }

    public void fieldSlotWalkFunction(J9VMThreadPointer walkThread, WalkState walkState, ObjectReferencePointer objectSlot, VoidPointer stackLocation) {
    }
}

