/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm26.events.EventManager;
import com.ibm.j9ddr.vm26.j9.ConstantPoolHelpers;
import com.ibm.j9ddr.vm26.j9.RootSet;
import com.ibm.j9ddr.vm26.j9.gc.GCClassIterator;
import com.ibm.j9ddr.vm26.j9.gc.GCClassIteratorClassSlots;
import com.ibm.j9ddr.vm26.j9.gc.GCIterator;
import com.ibm.j9ddr.vm26.j9.gc.GCObjectIterator;
import com.ibm.j9ddr.vm26.pointer.VoidPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm26.pointer.helper.J9ObjectHelper;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveSetWalker {
    public static void walkLiveSet(ObjectVisitor visitor, RootSet.RootSetType rootSetType) throws CorruptDataException {
        HashSet<J9ObjectPointer> visitedObjects = new HashSet<J9ObjectPointer>();
        RootSet rootSet = RootSet.from(rootSetType, false);
        GCIterator rootIterator = rootSet.gcIterator(rootSetType);
        GCIterator rootAddressIterator = rootSet.gcIterator(rootSetType);
        while (rootIterator.hasNext()) {
            J9ObjectPointer nextObject = (J9ObjectPointer)rootIterator.next();
            VoidPointer nextAddress = rootAddressIterator.nextAddress();
            if (!nextObject.notNull()) continue;
            LiveSetWalker.scanObject(visitedObjects, visitor, nextObject, nextAddress);
        }
    }

    public static void walkLiveSet(ObjectVisitor visitor) throws CorruptDataException {
        LiveSetWalker.walkLiveSet(visitor, RootSet.RootSetType.STRONG_REACHABLE);
    }

    private static void scanObject(HashSet<J9ObjectPointer> visitedObjects, ObjectVisitor visitor, J9ObjectPointer object, VoidPointer address) {
        if (visitedObjects.contains(object)) {
            return;
        }
        if (!visitor.visit(object, address)) {
            return;
        }
        visitedObjects.add(object);
        try {
            GCObjectIterator objectIterator = GCObjectIterator.fromJ9Object(object, true);
            GCObjectIterator addressIterator = GCObjectIterator.fromJ9Object(object, true);
            while (objectIterator.hasNext()) {
                J9ObjectPointer slot = objectIterator.next();
                VoidPointer addr = addressIterator.nextAddress();
                if (!slot.notNull()) continue;
                LiveSetWalker.scanObject(visitedObjects, visitor, slot, addr);
            }
            if (J9ObjectHelper.getClassName(object).equals("java/lang/Class")) {
                J9ClassPointer clazz = ConstantPoolHelpers.J9VM_J9CLASS_FROM_HEAPCLASS(object);
                GCClassIterator classIterator = GCClassIterator.fromJ9Class(clazz);
                GCClassIterator classAddressIterator = GCClassIterator.fromJ9Class(clazz);
                while (classIterator.hasNext()) {
                    J9ObjectPointer slot = classIterator.next();
                    VoidPointer addr = classAddressIterator.nextAddress();
                    if (!slot.notNull()) continue;
                    LiveSetWalker.scanObject(visitedObjects, visitor, slot, addr);
                }
                GCClassIteratorClassSlots classSlotIterator = GCClassIteratorClassSlots.fromJ9Class(clazz);
                GCClassIteratorClassSlots classSlotAddressIterator = GCClassIteratorClassSlots.fromJ9Class(clazz);
                while (classSlotIterator.hasNext()) {
                    J9ClassPointer slot = classSlotIterator.next();
                    VoidPointer addr = classSlotAddressIterator.nextAddress();
                    J9ObjectPointer classObject = ConstantPoolHelpers.J9VM_J9CLASS_TO_HEAPCLASS(slot);
                    if (!classObject.notNull()) continue;
                    LiveSetWalker.scanObject(visitedObjects, visitor, classObject, addr);
                }
            }
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Corruption found while walking the live set, object: " + object.getHexAddress(), e, false);
        }
        visitor.finishVisit(object, address);
    }

    public static interface ObjectVisitor {
        public boolean visit(J9ObjectPointer var1, VoidPointer var2);

        public void finishVisit(J9ObjectPointer var1, VoidPointer var2);
    }
}

