/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm24.j9.DataType;
import com.ibm.j9ddr.vm24.j9.gc.GCStringTableIterator;
import com.ibm.j9ddr.vm24.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm24.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm24.pointer.helper.J9RASHelper;
import java.io.PrintStream;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DumpStringTableCommand
extends Command {
    public DumpStringTableCommand() {
        this.addCommand("dumpstringtable", "", "Dump content of string table");
    }

    private Set<J9ObjectPointer> getStringTableObjects() throws CorruptDataException {
        TreeSet<J9ObjectPointer> sortedSet = new TreeSet<J9ObjectPointer>(new Comparator<J9ObjectPointer>(){

            @Override
            public int compare(J9ObjectPointer o1, J9ObjectPointer o2) {
                if (o1.getAddress() < o2.getAddress()) {
                    return -1;
                }
                if (o1.getAddress() > o2.getAddress()) {
                    return 1;
                }
                return 0;
            }
        });
        J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
        GCStringTableIterator it = GCStringTableIterator.fromJ9JavaVM(vm);
        while (it.hasNext()) {
            J9ObjectPointer next = it.next();
            sortedSet.add(next);
        }
        return sortedSet;
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        Set<J9ObjectPointer> stringTableObjects = null;
        try {
            stringTableObjects = this.getStringTableObjects();
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e.getMessage(), e);
        }
        for (J9ObjectPointer objectPointer : stringTableObjects) {
            String value = "** CORRUPT STRING TABLE ELEMENT **";
            try {
                value = J9ObjectHelper.stringValue(objectPointer);
            }
            catch (CorruptDataException e) {
                // empty catch block
            }
            String hexAddr = objectPointer.formatShortInteractive();
            out.println(String.format("%s value = <%s>", hexAddr, value));
        }
        out.println("Table Size = " + stringTableObjects.size());
    }
}

