/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm24.pointer.AbstractPointer;
import com.ibm.j9ddr.vm24.pointer.I32Pointer;
import com.ibm.j9ddr.vm24.pointer.PointerPointer;
import com.ibm.j9ddr.vm24.pointer.StructurePointer;
import com.ibm.j9ddr.vm24.pointer.U8Pointer;
import com.ibm.j9ddr.vm24.pointer.generated.UtDataHeaderPointer;
import com.ibm.j9ddr.vm24.structure.UtItem;
import com.ibm.j9ddr.vm24.types.I32;
import com.ibm.j9ddr.vm24.types.Scalar;
import com.ibm.j9ddr.vm24.types.U8;
import com.ibm.j9ddr.vm24.types.UDATA;

@GeneratedPointerClass(structureClass=UtItem.class)
public class UtItemPointer
extends StructurePointer {
    public static final UtItemPointer NULL = new UtItemPointer(0L);
    private static final boolean CACHE_FIELDS = false;
    private static final boolean CACHE_CLASS = false;

    protected UtItemPointer(long address) {
        super(address);
    }

    public static UtItemPointer cast(AbstractPointer structure) {
        return UtItemPointer.cast(structure.getAddress());
    }

    public static UtItemPointer cast(UDATA udata) {
        return UtItemPointer.cast(udata.longValue());
    }

    public static UtItemPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new UtItemPointer(address);
    }

    public UtItemPointer add(long count) {
        return UtItemPointer.cast(this.address + UtItem.SIZEOF * count);
    }

    public UtItemPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    public UtItemPointer addOffset(long offset) {
        return UtItemPointer.cast(this.address + offset);
    }

    public UtItemPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    public UtItemPointer sub(long count) {
        return UtItemPointer.cast(this.address - UtItem.SIZEOF * count);
    }

    public UtItemPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    public UtItemPointer subOffset(long offset) {
        return UtItemPointer.cast(this.address - offset);
    }

    public UtItemPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    public UtItemPointer untag(long mask) {
        return UtItemPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public UtItemPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    protected long sizeOfBaseType() {
        return UtItem.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_data$depthOffset_", declaredType="int")
    public I32 data$depth() throws CorruptDataException {
        return new I32(this.getIntAtOffset(UtItem._data$depthOffset_));
    }

    public I32Pointer data$depthEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return I32Pointer.cast(this.address + (long)UtItem._data$depthOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_destOffset_", declaredType="char")
    public U8 dest() throws CorruptDataException {
        return new U8(this.getByteAtOffset(UtItem._destOffset_));
    }

    public U8Pointer destEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U8Pointer.cast(this.address + (long)UtItem._destOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_headerOffset_", declaredType="UtDataHeader")
    public UtDataHeaderPointer header() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return UtDataHeaderPointer.cast(this.address + (long)UtItem._headerOffset_);
    }

    public PointerPointer headerEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)UtItem._headerOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_nextOffset_", declaredType="struct UtItem*")
    public UtItemPointer next() throws CorruptDataException {
        long pointer = this.getPointerAtOffset(UtItem._nextOffset_);
        return UtItemPointer.cast(pointer);
    }

    public PointerPointer nextEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)UtItem._nextOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_typeOffset_", declaredType="char")
    public U8 type() throws CorruptDataException {
        return new U8(this.getByteAtOffset(UtItem._typeOffset_));
    }

    public U8Pointer typeEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U8Pointer.cast(this.address + (long)UtItem._typeOffset_);
    }
}

