/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm24.pointer.AbstractPointer;
import com.ibm.j9ddr.vm24.pointer.IDATAPointer;
import com.ibm.j9ddr.vm24.pointer.PointerPointer;
import com.ibm.j9ddr.vm24.pointer.StructurePointer;
import com.ibm.j9ddr.vm24.pointer.U16Pointer;
import com.ibm.j9ddr.vm24.pointer.UDATAPointer;
import com.ibm.j9ddr.vm24.pointer.VoidPointer;
import com.ibm.j9ddr.vm24.pointer.WideSelfRelativePointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9PoolPuddlePointer;
import com.ibm.j9ddr.vm24.structure.J9Pool;
import com.ibm.j9ddr.vm24.types.IDATA;
import com.ibm.j9ddr.vm24.types.Scalar;
import com.ibm.j9ddr.vm24.types.U16;
import com.ibm.j9ddr.vm24.types.UDATA;

@GeneratedPointerClass(structureClass=J9Pool.class)
public class J9PoolPointer
extends StructurePointer {
    public static final J9PoolPointer NULL = new J9PoolPointer(0L);
    private static final boolean CACHE_FIELDS = false;
    private static final boolean CACHE_CLASS = false;

    protected J9PoolPointer(long address) {
        super(address);
    }

    public static J9PoolPointer cast(AbstractPointer structure) {
        return J9PoolPointer.cast(structure.getAddress());
    }

    public static J9PoolPointer cast(UDATA udata) {
        return J9PoolPointer.cast(udata.longValue());
    }

    public static J9PoolPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new J9PoolPointer(address);
    }

    public J9PoolPointer add(long count) {
        return J9PoolPointer.cast(this.address + J9Pool.SIZEOF * count);
    }

    public J9PoolPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    public J9PoolPointer addOffset(long offset) {
        return J9PoolPointer.cast(this.address + offset);
    }

    public J9PoolPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    public J9PoolPointer sub(long count) {
        return J9PoolPointer.cast(this.address - J9Pool.SIZEOF * count);
    }

    public J9PoolPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    public J9PoolPointer subOffset(long offset) {
        return J9PoolPointer.cast(this.address - offset);
    }

    public J9PoolPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    public J9PoolPointer untag(long mask) {
        return J9PoolPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public J9PoolPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    protected long sizeOfBaseType() {
        return J9Pool.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_activePuddleOffset_", declaredType="J9WSRP(struct J9PoolPuddle)")
    public J9PoolPuddlePointer activePuddle() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        long nextAddress = this.getPointerAtOffset(J9Pool._activePuddleOffset_);
        if (nextAddress == 0L) {
            return J9PoolPuddlePointer.NULL;
        }
        return J9PoolPuddlePointer.cast(this.address + ((long)J9Pool._activePuddleOffset_ + nextAddress));
    }

    public WideSelfRelativePointer activePuddleEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return WideSelfRelativePointer.cast(this.address + (long)J9Pool._activePuddleOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_alignmentOffset_", declaredType="U16")
    public U16 alignment() throws CorruptDataException {
        return new U16(this.getShortAtOffset(J9Pool._alignmentOffset_));
    }

    public U16Pointer alignmentEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U16Pointer.cast(this.address + (long)J9Pool._alignmentOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_allocPuddleOffset_", declaredType="IDATA")
    public IDATA allocPuddle() throws CorruptDataException {
        return new IDATA(this.getIDATAAtOffset(J9Pool._allocPuddleOffset_));
    }

    public IDATAPointer allocPuddleEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return IDATAPointer.cast(this.address + (long)J9Pool._allocPuddleOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_elementSizeOffset_", declaredType="UDATA")
    public UDATA elementSize() throws CorruptDataException {
        return new UDATA(this.getUDATAAtOffset(J9Pool._elementSizeOffset_));
    }

    public UDATAPointer elementSizeEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return UDATAPointer.cast(this.address + (long)J9Pool._elementSizeOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_flagsOffset_", declaredType="U16")
    public U16 flags() throws CorruptDataException {
        return new U16(this.getShortAtOffset(J9Pool._flagsOffset_));
    }

    public U16Pointer flagsEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U16Pointer.cast(this.address + (long)J9Pool._flagsOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_memAllocOffset_", declaredType="void*")
    public VoidPointer memAlloc() throws CorruptDataException {
        return VoidPointer.cast(this.getPointerAtOffset(J9Pool._memAllocOffset_));
    }

    public PointerPointer memAllocEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9Pool._memAllocOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_memFreeOffset_", declaredType="void*")
    public VoidPointer memFree() throws CorruptDataException {
        return VoidPointer.cast(this.getPointerAtOffset(J9Pool._memFreeOffset_));
    }

    public PointerPointer memFreeEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9Pool._memFreeOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_memPuddleAllocOffset_", declaredType="void*")
    public VoidPointer memPuddleAlloc() throws CorruptDataException {
        return VoidPointer.cast(this.getPointerAtOffset(J9Pool._memPuddleAllocOffset_));
    }

    public PointerPointer memPuddleAllocEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9Pool._memPuddleAllocOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_memPuddleFreeOffset_", declaredType="void*")
    public VoidPointer memPuddleFree() throws CorruptDataException {
        return VoidPointer.cast(this.getPointerAtOffset(J9Pool._memPuddleFreeOffset_));
    }

    public PointerPointer memPuddleFreeEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9Pool._memPuddleFreeOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_nextPuddleOffset_", declaredType="J9WSRP(struct J9PoolPuddle)")
    public J9PoolPuddlePointer nextPuddle() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        long nextAddress = this.getPointerAtOffset(J9Pool._nextPuddleOffset_);
        if (nextAddress == 0L) {
            return J9PoolPuddlePointer.NULL;
        }
        return J9PoolPuddlePointer.cast(this.address + ((long)J9Pool._nextPuddleOffset_ + nextAddress));
    }

    public WideSelfRelativePointer nextPuddleEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return WideSelfRelativePointer.cast(this.address + (long)J9Pool._nextPuddleOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_numberOfElementsOffset_", declaredType="UDATA")
    public UDATA numberOfElements() throws CorruptDataException {
        return new UDATA(this.getUDATAAtOffset(J9Pool._numberOfElementsOffset_));
    }

    public UDATAPointer numberOfElementsEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return UDATAPointer.cast(this.address + (long)J9Pool._numberOfElementsOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_puddleAllocSizeOffset_", declaredType="UDATA")
    public UDATA puddleAllocSize() throws CorruptDataException {
        return new UDATA(this.getUDATAAtOffset(J9Pool._puddleAllocSizeOffset_));
    }

    public UDATAPointer puddleAllocSizeEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return UDATAPointer.cast(this.address + (long)J9Pool._puddleAllocSizeOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_puddleUserDataOffset_", declaredType="void*")
    public VoidPointer puddleUserData() throws CorruptDataException {
        return VoidPointer.cast(this.getPointerAtOffset(J9Pool._puddleUserDataOffset_));
    }

    public PointerPointer puddleUserDataEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9Pool._puddleUserDataOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_userDataOffset_", declaredType="void*")
    public VoidPointer userData() throws CorruptDataException {
        return VoidPointer.cast(this.getPointerAtOffset(J9Pool._userDataOffset_));
    }

    public PointerPointer userDataEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9Pool._userDataOffset_);
    }
}

