/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.pointer.AbstractPointer;
import com.ibm.j9ddr.vm24.pointer.Pointer;
import com.ibm.j9ddr.vm24.types.Scalar;
import com.ibm.j9ddr.vm24.types.UDATA;

public class UDATAPointer
extends Pointer {
    public static final int SIZEOF = UDATA.SIZEOF;
    public static final UDATAPointer NULL = new UDATAPointer(0L);

    protected UDATAPointer(long address) {
        super(address);
    }

    public static UDATAPointer cast(AbstractPointer pointer) {
        return UDATAPointer.cast(pointer.getAddress());
    }

    public static UDATAPointer cast(UDATA udata) {
        return UDATAPointer.cast(udata.longValue());
    }

    public static UDATAPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new UDATAPointer(address);
    }

    public UDATA at(long index) throws CorruptDataException {
        return this.getUDATAAtOffset((long)SIZEOF * index);
    }

    public UDATA at(Scalar index) throws CorruptDataException {
        return this.at(index.longValue());
    }

    public UDATAPointer untag() {
        return this.untag(SIZEOF - 1);
    }

    public UDATAPointer untag(long mask) {
        return new UDATAPointer(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public UDATAPointer add(long count) {
        return new UDATAPointer(this.address + (long)SIZEOF * count);
    }

    public UDATAPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    public UDATAPointer addOffset(long offset) {
        return new UDATAPointer(this.address + offset);
    }

    public UDATAPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    public UDATAPointer sub(long count) {
        return new UDATAPointer(this.address - (long)SIZEOF * count);
    }

    public UDATAPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    public UDATAPointer subOffset(long offset) {
        return new UDATAPointer(this.address - offset);
    }

    public UDATAPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    protected long sizeOfBaseType() {
        return SIZEOF;
    }
}

