/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.pointer.AbstractPointer;
import com.ibm.j9ddr.vm24.pointer.Pointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm24.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm24.types.Scalar;
import com.ibm.j9ddr.vm24.types.UDATA;

public class ObjectReferencePointer
extends Pointer {
    public static final ObjectReferencePointer NULL = new ObjectReferencePointer(0L);
    public static final long SIZEOF = J9BuildFlags.gc_compressedPointers ? 4L : (long)UDATA.SIZEOF;

    protected ObjectReferencePointer(long address) {
        super(address);
    }

    public static ObjectReferencePointer cast(AbstractPointer pointer) {
        return ObjectReferencePointer.cast(pointer.getAddress());
    }

    public static ObjectReferencePointer cast(UDATA udata) {
        return ObjectReferencePointer.cast(udata.longValue());
    }

    public static ObjectReferencePointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new ObjectReferencePointer(address);
    }

    public ObjectReferencePointer add(long count) {
        return new ObjectReferencePointer(this.address + SIZEOF * count);
    }

    public ObjectReferencePointer add(Scalar count) {
        return this.add(count.longValue());
    }

    public ObjectReferencePointer addOffset(long offset) {
        return new ObjectReferencePointer(this.address + offset);
    }

    public ObjectReferencePointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    public J9ObjectPointer at(long index) throws CorruptDataException {
        return this.getObjectReferenceAtOffset(index * SIZEOF);
    }

    public J9ObjectPointer at(Scalar index) throws CorruptDataException {
        return this.at(index.longValue());
    }

    protected long sizeOfBaseType() {
        return SIZEOF;
    }

    public ObjectReferencePointer sub(long count) {
        return new ObjectReferencePointer(this.address - SIZEOF * count);
    }

    public ObjectReferencePointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    public ObjectReferencePointer subOffset(long offset) {
        return new ObjectReferencePointer(this.address - offset);
    }

    public ObjectReferencePointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    public ObjectReferencePointer untag(long tagBits) {
        return new ObjectReferencePointer(this.address & (tagBits ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public ObjectReferencePointer untag() {
        return this.untag(SIZEOF - 1L);
    }
}

