/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.j9.walkers;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.j9.walkers.ReadOnlyIterator;
import com.ibm.j9ddr.vm24.pointer.AbstractPointer;
import com.ibm.j9ddr.vm24.pointer.PointerPointer;
import com.ibm.j9ddr.vm24.pointer.StructurePointer;
import com.ibm.j9ddr.vm24.pointer.U32Pointer;
import com.ibm.j9ddr.vm24.pointer.VoidPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9RAMClassRefPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9RAMStringRefPointer;
import com.ibm.j9ddr.vm24.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm24.structure.J9ConstantPool;
import com.ibm.j9ddr.vm24.structure.J9RAMConstantPoolItem;
import java.util.ArrayList;
import java.util.Iterator;

public class ConstantPoolSlotIterator
extends ReadOnlyIterator {
    protected Iterator<AbstractPointer> slotIterator;
    protected Iterator<VoidPointer> addressIterator;

    protected ConstantPoolSlotIterator(J9ClassPointer clazz, boolean returnClassSlots, boolean returnObjectSlots) throws CorruptDataException {
        this.initializeSlots_V1(clazz, returnClassSlots, returnObjectSlots);
    }

    public static ConstantPoolSlotIterator fromJ9Class(J9ClassPointer clazz, boolean returnClassSlots, boolean returnObjectSlots) throws CorruptDataException {
        return new ConstantPoolSlotIterator(clazz, returnClassSlots, returnObjectSlots);
    }

    protected void initializeSlots_V1(J9ClassPointer clazz, boolean returnClassSlots, boolean returnObjectSlots) throws CorruptDataException {
        U32Pointer cpDescriptionSlots = clazz.romClass().cpShapeDescription();
        PointerPointer cpEntry = PointerPointer.cast(J9ClassHelper.ramConstantPool(clazz));
        long cpDescription = 0L;
        long cpEntryCount = clazz.romClass().ramConstantPoolCount().longValue();
        long cpDescriptionIndex = 0L;
        ArrayList<StructurePointer> slots = new ArrayList<StructurePointer>();
        ArrayList<VoidPointer> addresses = new ArrayList<VoidPointer>();
        while (cpEntryCount > 0L) {
            StructurePointer ref;
            StructurePointer slot;
            long slotType;
            if (0L == cpDescriptionIndex) {
                cpDescription = cpDescriptionSlots.at(0L).longValue();
                cpDescriptionSlots = cpDescriptionSlots.add(1L);
                cpDescriptionIndex = J9ConstantPool.J9_CP_DESCRIPTIONS_PER_U32;
            }
            if ((slotType = cpDescription & J9ConstantPool.J9_CP_DESCRIPTION_MASK) == J9ConstantPool.J9CPTYPE_STRING) {
                if (returnObjectSlots && (slot = ((J9RAMStringRefPointer)(ref = J9RAMStringRefPointer.cast(cpEntry))).stringObject()).notNull()) {
                    slots.add(slot);
                    addresses.add(VoidPointer.cast(((J9RAMStringRefPointer)ref).stringObjectEA()));
                }
            } else if (slotType == J9ConstantPool.J9CPTYPE_CLASS && returnClassSlots && (slot = ((J9RAMClassRefPointer)(ref = J9RAMClassRefPointer.cast(cpEntry))).value()).notNull()) {
                slots.add(slot);
                addresses.add(VoidPointer.cast(((J9RAMClassRefPointer)ref).valueEA()));
            }
            cpEntry = cpEntry.addOffset(J9RAMConstantPoolItem.SIZEOF);
            --cpEntryCount;
            cpDescription >>= (int)J9ConstantPool.J9_CP_BITS_PER_DESCRIPTION;
            --cpDescriptionIndex;
        }
        this.slotIterator = slots.iterator();
        this.addressIterator = addresses.iterator();
    }

    public boolean hasNext() {
        return this.slotIterator.hasNext();
    }

    public AbstractPointer next() {
        this.addressIterator.next();
        return this.slotIterator.next();
    }

    public VoidPointer nextAddress() {
        this.slotIterator.next();
        return this.addressIterator.next();
    }
}

