/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.j9.gc.GCClassModel;
import com.ibm.j9ddr.vm24.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm24.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm24.structure.J9Consts;
import com.ibm.j9ddr.vm24.structure.J9Object;
import com.ibm.j9ddr.vm24.types.UDATA;

class GCClassModel_V1
extends GCClassModel {
    GCClassModel_V1() {
    }

    public UDATA getClassDepth(J9ClassPointer clazz) throws CorruptDataException {
        return clazz.classDepthAndFlags().bitAnd(J9Consts.J9_JAVA_CLASS_DEPTH_MASK);
    }

    public UDATA getInstanceSizeInBytes(J9ClassPointer clazz) throws CorruptDataException {
        return clazz.totalInstanceSize();
    }

    public UDATA getSizeInBytes(J9ClassPointer clazz) throws CorruptDataException {
        return new UDATA(clazz.size().longValue() + J9Object.SIZEOF);
    }

    public UDATA getSizeInSlots(J9ClassPointer clazz) throws CorruptDataException {
        return UDATA.convertBytesToSlots(this.getSizeInBytes(clazz));
    }

    public J9ClassPointer getSuperclass(J9ClassPointer clazz) throws CorruptDataException {
        int classDepth = clazz.classDepthAndFlags().bitAnd(J9Consts.J9_JAVA_CLASS_DEPTH_MASK).intValue();
        return J9ClassPointer.cast(clazz.superclasses().at(classDepth - 1));
    }

    public boolean usesSharedITable(J9ClassPointer clazz) throws CorruptDataException {
        return J9ClassHelper.isArrayClass(clazz) && !clazz.eq(GCClassModel_V1.getJavaVM().booleanArrayClass());
    }
}

