/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.view.dtfj.java;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaMethod;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.java.JavaVMInitArgs;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.view.dtfj.image.J9DDRCorruptData;
import com.ibm.j9ddr.vm23.events.EventManager;
import com.ibm.j9ddr.vm23.j9.Pool;
import com.ibm.j9ddr.vm23.j9.gc.GCSegmentIterator;
import com.ibm.j9ddr.vm23.j9.gc.GCVMThreadListIterator;
import com.ibm.j9ddr.vm23.j9.gc.RootScanner;
import com.ibm.j9ddr.vm23.pointer.generated.GC_FinalizerJobPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9DebuggerReferencePointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9JITConfigPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9MemorySegmentListPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9MemorySegmentPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ThreadAbstractMonitorPointer;
import com.ibm.j9ddr.vm23.pointer.generated.MM_EnvironmentModronPointer;
import com.ibm.j9ddr.vm23.structure.J9JITConfig;
import com.ibm.j9ddr.vm23.structure.J9JavaVM;
import com.ibm.j9ddr.vm23.types.UDATA;
import com.ibm.j9ddr.vm23.view.dtfj.DTFJContext;
import com.ibm.j9ddr.vm23.view.dtfj.DTFJCorruptDataException;
import com.ibm.j9ddr.vm23.view.dtfj.java.DTFJJavaClass;
import com.ibm.j9ddr.vm23.view.dtfj.java.DTFJJavaClassloader;
import com.ibm.j9ddr.vm23.view.dtfj.java.DTFJJavaHeap;
import com.ibm.j9ddr.vm23.view.dtfj.java.DTFJJavaObject;
import com.ibm.j9ddr.vm23.view.dtfj.java.DTFJJavaReference;
import com.ibm.j9ddr.vm23.view.dtfj.java.DTFJJavaThread;
import com.ibm.j9ddr.vm23.view.dtfj.java.DTFJJavaVMInitArgs;
import com.ibm.j9ddr.vm23.view.dtfj.java.corrupt.AddCorruptionToListListener;
import com.ibm.j9ddr.vm23.view.dtfj.java.j9.DTFJMonitorIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class DTFJJavaRuntime
implements JavaRuntime {
    private final DTFJJavaVMInitArgs vminitargs = new DTFJJavaVMInitArgs();
    private List<Object> references;
    private LinkedList<Object> classLoaders = null;
    private Properties systemProperties;
    private List<Object> compiledMethods = null;

    public boolean equals(Object other) {
        if (!(other instanceof JavaRuntime)) {
            return false;
        }
        try {
            return this.getJavaVM().equals(((JavaRuntime)other).getJavaVM());
        }
        catch (com.ibm.dtfj.image.CorruptDataException e) {
            return false;
        }
    }

    public int hashCode() {
        try {
            return this.getJavaVM().hashCode();
        }
        catch (com.ibm.dtfj.image.CorruptDataException e) {
            return 0;
        }
    }

    public Iterator getCompiledMethods() {
        if (this.compiledMethods == null) {
            this.compiledMethods = new ArrayList<Object>();
            Iterator classLoaderIterators = this.getJavaClassLoaders();
            while (classLoaderIterators.hasNext()) {
                Object classLoaderObj = classLoaderIterators.next();
                if (classLoaderObj instanceof CorruptData) {
                    this.compiledMethods.add(classLoaderObj);
                    continue;
                }
                Iterator classesIterator = ((JavaClassLoader)classLoaderObj).getDefinedClasses();
                while (classesIterator.hasNext()) {
                    Object classObject = classesIterator.next();
                    if (classObject instanceof CorruptData) {
                        this.compiledMethods.add(classObject);
                        continue;
                    }
                    Iterator methodsIterator = ((JavaClass)classObject).getDeclaredMethods();
                    while (methodsIterator.hasNext()) {
                        Object methodObj = methodsIterator.next();
                        if (methodObj instanceof CorruptData) {
                            this.compiledMethods.add(methodObj);
                        }
                        if (!((JavaMethod)methodObj).getCompiledSections().hasNext()) continue;
                        this.compiledMethods.add(methodObj);
                    }
                }
            }
        }
        return this.compiledMethods.iterator();
    }

    public Iterator getHeapRoots() {
        if (null == this.references) {
            this.scanReferences();
        }
        return this.references.iterator();
    }

    public boolean isJITEnabled() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            J9JITConfigPointer jitConfig = DTFJContext.getVm().jitConfig();
            return jitConfig.notNull() && jitConfig.runtimeFlags().allBitsIn(J9JITConfig.J9JIT_JIT_ATTACHED);
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
    }

    public Properties getJITProperties() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        Properties properties = new Properties();
        try {
            J9JITConfigPointer jitConfig = DTFJContext.getVm().jitConfig();
            if (jitConfig.notNull()) {
                if (jitConfig.runtimeFlags().allBitsIn(J9JITConfig.J9JIT_JIT_ATTACHED)) {
                    properties.setProperty("JIT", "enabled");
                } else {
                    properties.setProperty("JIT", "disabled");
                }
                if (jitConfig.runtimeFlags().allBitsIn(J9JITConfig.J9JIT_AOT_ATTACHED)) {
                    properties.setProperty("AOT", "enabled");
                } else {
                    properties.setProperty("AOT", "disabled");
                }
                if (jitConfig.fsdEnabled().eq(new UDATA(0L))) {
                    properties.setProperty("FSD", "enabled");
                } else {
                    properties.setProperty("FSD", "disabled");
                }
                if (DTFJContext.getVm().requiredDebugAttributes().allBitsIn(J9JavaVM.J9VM_DEBUG_ATTRIBUTE_CAN_REDEFINE_CLASSES)) {
                    properties.setProperty("HCR", "enabled");
                } else {
                    properties.setProperty("HCR", "disabled");
                }
            } else {
                throw new DataUnavailable("JIT not enabled");
            }
            return properties;
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
    }

    private void scanReferences() {
        this.references = new LinkedList<Object>();
        MM_EnvironmentModronPointer env = null;
        try {
            env = MM_EnvironmentModronPointer.cast(DTFJContext.getVm().mainThread().gcExtensions());
            DTFJRootScanner scanner = new DTFJRootScanner(env);
            scanner.scanAllSlots();
        }
        catch (Throwable t) {
            CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
            this.references.add(cd);
        }
    }

    public Iterator getHeaps() {
        try {
            LinkedList<DTFJJavaHeap> heaps = new LinkedList<DTFJJavaHeap>();
            heaps.add(new DTFJJavaHeap());
            return heaps.iterator();
        }
        catch (Throwable t) {
            CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
            return J9DDRDTFJUtils.corruptIterator(cd);
        }
    }

    public Iterator getJavaClassLoaders() {
        if (this.classLoaders != null) {
            return this.classLoaders.iterator();
        }
        this.classLoaders = new LinkedList();
        try {
            Iterator<J9ClassLoaderPointer> poolIterator = Pool.fromJ9Pool(DTFJContext.getVm().classLoaderBlocks(), J9ClassLoaderPointer.class).iterator();
            while (poolIterator.hasNext()) {
                this.classLoaders.add(new DTFJJavaClassloader(poolIterator.next()));
            }
        }
        catch (Throwable t) {
            CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
            this.classLoaders.add(cd);
        }
        return this.classLoaders.iterator();
    }

    public ImagePointer getJavaVM() throws com.ibm.dtfj.image.CorruptDataException {
        return DTFJContext.getImagePointer(DTFJContext.getVm().getAddress());
    }

    public JavaVMInitArgs getJavaVMInitArgs() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        return this.vminitargs;
    }

    public Iterator getMonitors() {
        try {
            return new DTFJMonitorIterator();
        }
        catch (Throwable t) {
            CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
            return J9DDRDTFJUtils.corruptIterator(cd);
        }
    }

    public JavaObject getObjectAtAddress(ImagePointer address) throws com.ibm.dtfj.image.CorruptDataException, IllegalArgumentException, MemoryAccessException, DataUnavailable {
        try {
            J9MemorySegmentListPointer segments = DTFJContext.getVm().objectMemorySegments();
            GCSegmentIterator segmentIterator = GCSegmentIterator.fromJ9MemorySegmentList(segments, 0L);
            UDATA object = new UDATA(address.getAddress());
            if (object.anyBitsIn(7L)) {
                throw new IllegalArgumentException("Invalid alignment for JavaObject. Address = " + address);
            }
            while (segmentIterator.hasNext()) {
                J9MemorySegmentPointer segment = segmentIterator.next();
                if (!object.gte(UDATA.cast(segment.heapBase())) || !object.lt(UDATA.cast(segment.heapTop()))) continue;
                J9ObjectPointer ptr = J9ObjectPointer.cast(object);
                return new DTFJJavaObject(new DTFJJavaHeap(), ptr);
            }
            throw new IllegalArgumentException("Object address " + address + " is not in any heap");
        }
        catch (Throwable t) {
            Class[] whitelist = new Class[]{IllegalArgumentException.class};
            throw J9DDRDTFJUtils.handleAllButMemAccExAndDataUnavailAsCorruptDataException(DTFJContext.getProcess(), t, whitelist);
        }
    }

    public Iterator getThreads() {
        LinkedList<Object> toIterate = new LinkedList<Object>();
        AddCorruptionToListListener listener = new AddCorruptionToListListener(toIterate);
        EventManager.register(listener);
        try {
            GCVMThreadListIterator threadIterator = GCVMThreadListIterator.fromJ9JavaVM(DTFJContext.getVm());
            while (threadIterator.hasNext() && !listener.fatalCorruption()) {
                toIterate.add(new DTFJJavaThread(threadIterator.next()));
            }
        }
        catch (Throwable t) {
            CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
            toIterate.add(cd);
        }
        EventManager.unregister(listener);
        return toIterate.iterator();
    }

    public Object getTraceBuffer(String arg0, boolean arg1) throws com.ibm.dtfj.image.CorruptDataException {
        return new J9DDRCorruptData(DTFJContext.getProcess(), "Trace buffers are not available");
    }

    public String getFullVersion() throws com.ibm.dtfj.image.CorruptDataException {
        return this.getVersion();
    }

    public String getVersion() throws com.ibm.dtfj.image.CorruptDataException {
        String javaFullVersion = this.getRequiredSystemProperty("java.fullversion");
        String javaRuntimeVersion = this.getRequiredSystemProperty("java.runtime.version");
        String javaRuntimeName = this.getRequiredSystemProperty("java.runtime.name");
        String javaVMName = this.getRequiredSystemProperty("java.vm.name");
        String version = javaRuntimeName + "(build " + javaRuntimeVersion + ")\n";
        version = version + javaVMName + "(" + javaFullVersion + ")";
        return version;
    }

    private String getRequiredSystemProperty(String name) throws com.ibm.dtfj.image.CorruptDataException {
        String value = null;
        try {
            value = this.getSystemProperties().getProperty(name);
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
        if (value != null) {
            return value;
        }
        throw new DTFJCorruptDataException(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), "Couldn't find required system property " + name));
    }

    private Properties getSystemProperties() throws CorruptDataException {
        if (this.systemProperties == null) {
            this.systemProperties = DTFJContext.getVm().getSystemProperties();
        }
        return this.systemProperties;
    }

    public String toString() {
        return "Java Runtime 0x" + Long.toHexString(DTFJContext.getVm().getAddress());
    }

    public Iterator getMemoryCategories() throws DataUnavailable {
        throw new DataUnavailable("Not implemented");
    }

    public Iterator getMemorySections(boolean includeFreed) throws DataUnavailable {
        throw new DataUnavailable("Not implemented");
    }

    public JavaObject getNestedPackedObject(JavaClass jc, ImagePointer packedDataAddress) throws DataUnavailable {
        throw new DataUnavailable("Not implemented");
    }

    public JavaObject getNestedPackedArrayObject(JavaClass jc, ImagePointer i, int arrayLength) throws DataUnavailable {
        throw new DataUnavailable("Not implemented");
    }

    public class DTFJRootScanner
    extends RootScanner {
        protected DTFJRootScanner(MM_EnvironmentModronPointer env) throws CorruptDataException {
            super(env);
        }

        private int getReachabilityCode() {
            switch (this.getReachability()) {
                case STRONG: {
                    return 1;
                }
                case WEAK: {
                    return 3;
                }
            }
            throw new UnsupportedOperationException("Unknown reachability: " + (Object)((Object)this.getReachability()) + " found");
        }

        protected void doClassLoader(J9ClassLoaderPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaClassloader(slot).getObject(), "ClassLoader", 0, 10, this.getReachabilityCode()));
                }
                catch (com.ibm.dtfj.image.CorruptDataException e) {
                    DTFJJavaRuntime.this.references.add(e.getCorruptData());
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        protected void doClassSlot(J9ClassPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaClass(slot), "Class", 0, 2, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        protected void doDebuggerClassReference(J9DebuggerReferencePointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaClass(J9ClassPointer.cast(slot.object())), "DebuggerClassReference", 0, 7, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        protected void doDebuggerReference(J9DebuggerReferencePointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot.object()), "DebuggerReference", 0, 7, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        protected void doFinalizableSlot(GC_FinalizerJobPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(J9ObjectPointer.cast(slot._element())), "FinalizableObject", 0, 8, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        protected void doJNIGlobalReferenceSlot(J9ObjectPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot), "JNIGlobalReference", 0, 1, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        protected void doJNIWeakGlobalReference(J9ObjectPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot), "JNIWeakGlobalReference", 0, 1, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        protected void doJVMTIObjectTagSlot(J9ObjectPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot), "JVMTIObjectTagTable", 0, 0, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        protected void doMonitorReference(J9ThreadAbstractMonitorPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(J9ObjectPointer.cast(slot.userData())), "MonitorReference", 0, 3, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        protected void doPhantomReferenceSlot(J9ObjectPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot), "PhantomReferenceObject", 0, 7, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        protected void doRememberedSlot(J9ObjectPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot), "RememberedSlot", 0, 7, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        protected void doSoftReferenceSlot(J9ObjectPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot), "SoftReferenceObject", 0, 7, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        protected void doStringTableSlot(J9ObjectPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot), "StringTable", 0, 11, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        protected void doUnfinalizedSlot(J9ObjectPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot), "UnfinalizedObject", 0, 9, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        protected void doVMClassSlot(J9ClassPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaClass(slot), "VMClassSlot", 0, 2, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        protected void doVMThreadJNISlot(J9ObjectPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot), "Thread", 0, 6, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        protected void doVMThreadMonitorRecordSlot(J9ObjectPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot), "Thread", 0, 6, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        protected void doVMThreadSlot(J9ObjectPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot), "Thread", 0, 6, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        protected void doWeakReferenceSlot(J9ObjectPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot), "WeakReferenceObject", 0, 7, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }
    }
}

