/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.view.dtfj.java;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaReference;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.view.dtfj.image.J9DDRCorruptData;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImagePointer;
import com.ibm.j9ddr.vm23.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm23.j9.J9ObjectFieldOffsetIterator;
import com.ibm.j9ddr.vm23.j9.OptInfo;
import com.ibm.j9ddr.vm23.pointer.SelfRelativePointer;
import com.ibm.j9ddr.vm23.pointer.VoidPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ArrayClassPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm23.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm23.structure.J9Consts;
import com.ibm.j9ddr.vm23.structure.J9Object;
import com.ibm.j9ddr.vm23.types.U32;
import com.ibm.j9ddr.vm23.view.dtfj.DTFJContext;
import com.ibm.j9ddr.vm23.view.dtfj.java.DTFJJavaClassloader;
import com.ibm.j9ddr.vm23.view.dtfj.java.DTFJJavaField;
import com.ibm.j9ddr.vm23.view.dtfj.java.DTFJJavaFieldInstance;
import com.ibm.j9ddr.vm23.view.dtfj.java.DTFJJavaFieldStatic;
import com.ibm.j9ddr.vm23.view.dtfj.java.DTFJJavaMethod;
import com.ibm.j9ddr.vm23.view.dtfj.java.DTFJJavaObject;
import com.ibm.j9ddr.vm23.view.dtfj.java.DTFJJavaReference;
import com.ibm.j9ddr.vm23.view.dtfj.java.j9.DTFJConstantPoolIterator;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DTFJJavaClass
implements JavaClass {
    private static final int UNCHECKED_MARKER = 8;
    private static final int MARKER_IS_FALSE = 0;
    private static final int CLASS_IS_INTERFACE = 1;
    private static final int CLASS_IS_ARRAY = 1;
    private static final int CLASS_IS_OBJECT_ARRAY = 1;
    private final J9ClassPointer j9class;
    private DTFJJavaClassloader javaClassLoader;
    private static final Logger log = DTFJContext.getLogger();
    private J9ClassPointer superclass = null;
    private byte interfaceMarker = (byte)8;
    private byte arrayMarker = (byte)8;
    private byte objectArrayMarker = (byte)8;
    private SoftReference<DTFJJavaObject> classObject = null;
    private static final int MAX_CLASS_FIELDS = 65535;
    private static final int MAX_CLASS_METHODS = 65535;
    private DTFJJavaClass componentType;
    static final Map<J9ClassPointer, List<Object>> declaredFieldsCache = new HashMap<J9ClassPointer, List<Object>>();
    private J9DDRImagePointer id;
    static final Map<J9ClassPointer, Integer> modifiersCache = new HashMap<J9ClassPointer, Integer>();
    private List<Object> references = null;
    private static final Map<J9ClassPointer, SuperClassCacheEntry> superClassCache = new HashMap<J9ClassPointer, SuperClassCacheEntry>();

    public DTFJJavaClass(J9ClassPointer j9class) {
        this.j9class = j9class;
    }

    J9ClassPointer getJ9Class() {
        return this.j9class;
    }

    public JavaClassLoader getClassLoader() throws com.ibm.dtfj.image.CorruptDataException {
        if (this.javaClassLoader == null) {
            try {
                this.javaClassLoader = new DTFJJavaClassloader(this.j9class.classLoader());
            }
            catch (Throwable t) {
                throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
            }
        }
        return this.javaClassLoader;
    }

    public JavaClass getComponentType() throws com.ibm.dtfj.image.CorruptDataException {
        if (!this.isArray()) {
            throw new IllegalArgumentException("Class is not an array");
        }
        J9ArrayClassPointer arrayClass = J9ArrayClassPointer.cast(this.j9class);
        try {
            if (arrayClass.arity().eq(1L)) {
                if (this.componentType == null) {
                    try {
                        this.componentType = new DTFJJavaClass(J9ArrayClassPointer.cast(this.j9class).leafComponentType());
                    }
                    catch (CorruptDataException e) {
                        J9DDRDTFJUtils.newCorruptDataException(DTFJContext.getProcess(), e);
                    }
                }
                return this.componentType;
            }
            return new DTFJJavaClass(J9ArrayClassPointer.cast(this.j9class).componentType());
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
    }

    public Iterator getConstantPoolReferences() {
        try {
            if (this.isArray()) {
                return J9DDRDTFJUtils.emptyIterator();
            }
            return new DTFJConstantPoolIterator(this.j9class);
        }
        catch (Throwable t) {
            CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
            return J9DDRDTFJUtils.corruptIterator(cd);
        }
    }

    public Iterator getDeclaredFields() {
        List<Object> fieldList = declaredFieldsCache.get(this.j9class);
        if (fieldList == null) {
            fieldList = new LinkedList<Object>();
            try {
                J9ClassPointer superclass = J9ClassPointer.NULL;
                try {
                    superclass = this.getSuperClassPointer();
                }
                catch (CorruptDataException e1) {
                    fieldList.add(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), "Unable to determine superclass"));
                }
                U32 flags = new U32(3L);
                long fieldCount = this.j9class.romClass().romFieldCount().longValue();
                Iterator fields = null;
                if (fieldCount > 65535L) {
                    fieldList.add(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), "Corrupt field count"));
                } else {
                    fields = J9ObjectFieldOffsetIterator.J9ObjectFieldOffsetIteratorFor(this.j9class, superclass, flags);
                }
                while (fields.hasNext()) {
                    try {
                        J9ObjectFieldOffset field = (J9ObjectFieldOffset)fields.next();
                        log.fine(String.format("Declared field : %s", field.getName()));
                        if (field.isStatic()) {
                            fieldList.add(new DTFJJavaFieldStatic(this, field));
                        } else {
                            fieldList.add(new DTFJJavaFieldInstance(this, field));
                        }
                    }
                    catch (CorruptDataException e) {
                        fieldList.add(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), e));
                    }
                    if ((long)fieldList.size() <= fieldCount) continue;
                    fieldList.add(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), "Corrupt class returned more fields than it declared"));
                    break;
                }
            }
            catch (Throwable t) {
                fieldList.add(J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t));
            }
            if (fieldList.size() < 1024) {
                declaredFieldsCache.put(this.j9class, fieldList);
            }
        }
        return fieldList.iterator();
    }

    public Iterator getDeclaredMethods() {
        ArrayList<DTFJJavaMethod> methods;
        long methodCount;
        J9MethodPointer ramMethod;
        try {
            ramMethod = this.j9class.ramMethods();
            methodCount = this.j9class.romClass().romMethodCount().longValue();
            if (methodCount > 65535L) {
                J9DDRCorruptData cd = J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), "Corrupt class, maximum number of methods exceeded");
                return J9DDRDTFJUtils.corruptIterator(cd);
            }
            methods = new ArrayList<DTFJJavaMethod>((int)methodCount);
        }
        catch (Throwable t) {
            CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
            return J9DDRDTFJUtils.corruptIterator(cd);
        }
        int i = 0;
        while ((long)i < methodCount) {
            try {
                DTFJJavaMethod jmethod = new DTFJJavaMethod(this, ramMethod.add(i));
                methods.add(jmethod);
            }
            catch (Throwable t) {
                CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                methods.add((DTFJJavaMethod)cd);
            }
            ++i;
        }
        return methods.iterator();
    }

    public ImagePointer getID() {
        if (this.id == null) {
            this.id = DTFJContext.getImagePointer(this.j9class.getAddress());
        }
        return this.id;
    }

    public Iterator getInterfaces() {
        SelfRelativePointer interfaceName;
        ArrayList<String> interfaceNames;
        int interfaceCount;
        try {
            interfaceCount = this.j9class.romClass().interfaceCount().intValue();
            if (interfaceCount > 65535) {
                String msg = String.format("Invalid number of interfaces for class@0x%s", Long.toHexString(this.j9class.getAddress()));
                throw new CorruptDataException(msg);
            }
            interfaceNames = new ArrayList<String>(interfaceCount);
            interfaceName = this.j9class.romClass().interfaces();
        }
        catch (Throwable t) {
            CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
            return J9DDRDTFJUtils.corruptIterator(cd);
        }
        try {
            for (int i = 0; i < interfaceCount; ++i) {
                VoidPointer namePointer = interfaceName.add(i).get();
                try {
                    interfaceNames.add(J9UTF8Pointer.cast(namePointer).stringValue());
                    continue;
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    interfaceNames.add((String)cd);
                }
            }
        }
        catch (Throwable t) {
            CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
            interfaceNames.add((String)cd);
        }
        return interfaceNames.iterator();
    }

    public int getModifiers() throws com.ibm.dtfj.image.CorruptDataException {
        Integer cachedModifiers = modifiersCache.get(this.j9class);
        if (cachedModifiers == null) {
            try {
                cachedModifiers = (int)this.j9class.romClass().modifiers().longValue();
                modifiersCache.put(this.j9class, cachedModifiers);
            }
            catch (Throwable t) {
                throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
            }
        }
        return cachedModifiers;
    }

    public String getName() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            if (this.isArray()) {
                return J9ClassHelper.getArrayName(this.j9class);
            }
            return this.j9class.getName();
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
    }

    boolean isObjectArray() throws com.ibm.dtfj.image.CorruptDataException, CorruptDataException {
        if (this.objectArrayMarker == 8) {
            J9ArrayClassPointer arrayClass;
            this.objectArrayMarker = this.isArray() ? ((arrayClass = J9ArrayClassPointer.cast(this.j9class)).arity().gt(1) || this.getName().charAt(1) == 'L' ? (byte)1 : 0) : (byte)0;
        }
        return this.objectArrayMarker == 1;
    }

    public JavaObject getObject() throws com.ibm.dtfj.image.CorruptDataException {
        DTFJJavaObject obj = null;
        if (this.classObject != null) {
            obj = this.classObject.get();
        }
        if (obj == null) {
            try {
                obj = new DTFJJavaObject(J9ObjectPointer.cast(this.j9class));
                this.classObject = new SoftReference<DTFJJavaObject>(obj);
            }
            catch (Throwable t) {
                throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
            }
        }
        return obj;
    }

    public Iterator getReferences() {
        if (this.references == null) {
            this.references = new ArrayList<Object>();
            this.addConstantPoolReferences(this.references);
            this.addStaticFieldReferences(this.references);
            this.addSuperclassReference(this.references);
            this.addClassLoaderReference(this.references);
            this.addClassObjectReference(this.references);
        }
        return this.references.iterator();
    }

    private void addStaticFieldReferences(List<Object> references) {
        Iterator declaredFieldIt = this.getDeclaredFields();
        while (declaredFieldIt.hasNext()) {
            DTFJJavaField jField = (DTFJJavaField)declaredFieldIt.next();
            if (!(jField instanceof DTFJJavaFieldStatic)) continue;
            try {
                JavaObject jObject;
                char type = jField.getSignature().charAt(0);
                if (type != 'L' && type != '[' || (jObject = (JavaObject)jField.get(null)) == null) continue;
                String fieldName = jField.getName();
                String description = "Static field";
                if (null != fieldName) {
                    description = description + " [field name:" + fieldName + "]";
                }
                DTFJJavaReference jRef = new DTFJJavaReference(this, jObject, description, 8, 0, 1);
                references.add(jRef);
            }
            catch (MemoryAccessException e) {
                references.add(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), e.getMessage()));
            }
            catch (Throwable t) {
                CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                references.add(cd);
            }
        }
    }

    private void addSuperclassReference(List<Object> coll) {
        DTFJJavaReference jRef = null;
        try {
            JavaClass superClass = this.getSuperclass();
            if (null != superClass) {
                jRef = new DTFJJavaReference(this, superClass, "Superclass", 10, 0, 1);
                coll.add(jRef);
            }
        }
        catch (com.ibm.dtfj.image.CorruptDataException e) {
            coll.add(e.getCorruptData());
        }
    }

    private void addClassLoaderReference(List<Object> coll) {
        DTFJJavaReference jRef = null;
        try {
            JavaObject classLoaderObject;
            JavaClassLoader classLoader = this.getClassLoader();
            if (null != classLoader && null != (classLoaderObject = classLoader.getObject())) {
                jRef = new DTFJJavaReference(this, classLoaderObject, "Classloader", 4, 0, 1);
                coll.add(jRef);
            }
        }
        catch (com.ibm.dtfj.image.CorruptDataException e) {
            coll.add(e.getCorruptData());
        }
    }

    private void addClassObjectReference(List<Object> coll) {
        DTFJJavaReference jRef = null;
        try {
            JavaObject classObject = this.getObject();
            if (null != classObject) {
                jRef = new DTFJJavaReference(this, classObject, "Class object", 12, 0, 1);
                coll.add(jRef);
            }
        }
        catch (com.ibm.dtfj.image.CorruptDataException e) {
            coll.add(e.getCorruptData());
        }
    }

    private JavaReference addConstantPoolReferences(List<Object> references) {
        DTFJJavaReference jRef = null;
        Iterator constantPoolIt = this.getConstantPoolReferences();
        while (constantPoolIt.hasNext()) {
            Object cpObject = constantPoolIt.next();
            if (cpObject instanceof JavaObject) {
                jRef = new DTFJJavaReference(this, cpObject, "Constant Pool Object", 9, 0, 1);
            } else if (cpObject instanceof JavaClass) {
                jRef = new DTFJJavaReference(this, cpObject, "Constant Pool Class", 9, 0, 1);
            }
            if (null == jRef) continue;
            references.add(jRef);
        }
        return jRef;
    }

    private J9ClassPointer getSuperClassPointer() throws CorruptDataException {
        if (this.superclass == null) {
            this.superclass = J9ClassPointer.SUPERCLASS(this.j9class);
        }
        return this.superclass;
    }

    public JavaClass getSuperclass() throws com.ibm.dtfj.image.CorruptDataException {
        SuperClassCacheEntry cachedEntry = superClassCache.get(this.j9class);
        if (null == cachedEntry) {
            try {
                J9ClassPointer sclass;
                cachedEntry = this.isInterface() ? new SuperClassCacheEntry(null) : ((sclass = this.getSuperClassPointer()) == null || sclass.isNull() ? new SuperClassCacheEntry(null) : new SuperClassCacheEntry(new DTFJJavaClass(sclass)));
                superClassCache.put(this.j9class, cachedEntry);
            }
            catch (Throwable t) {
                throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
            }
        }
        return cachedEntry.superClass;
    }

    private boolean isInterface() throws CorruptDataException {
        if (this.interfaceMarker == 8) {
            J9ROMClassPointer romclass = this.j9class.romClass();
            this.interfaceMarker = romclass.modifiers().allBitsIn(J9Consts.J9_JAVA_INTERFACE) ? (byte)1 : 0;
        }
        return this.interfaceMarker == 1;
    }

    public boolean isArray() throws com.ibm.dtfj.image.CorruptDataException {
        if (this.arrayMarker == 8) {
            this.arrayMarker = ((long)this.getModifiers() & J9Consts.J9_JAVA_CLASS_ARRAY) != 0L ? (byte)1 : 0;
        }
        return this.arrayMarker == 1;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof DTFJJavaClass) {
            DTFJJavaClass objImpl = (DTFJJavaClass)obj;
            return this.j9class.getAddress() == objImpl.j9class.getAddress();
        }
        return false;
    }

    public int hashCode() {
        return (int)this.j9class.getAddress();
    }

    public String getFilename() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            return OptInfo.getSourceFileNameForROMClass(this.j9class.romClass());
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
    }

    public String toString() {
        try {
            return this.getName();
        }
        catch (com.ibm.dtfj.image.CorruptDataException e) {
            return "JavaClass 0x" + Long.toHexString(this.j9class.getAddress()) + " (exception reading class name)";
        }
    }

    public long getInstanceSize() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            return this.j9class.totalInstanceSize().longValue() + J9Object.SIZEOF;
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
    }

    public JavaObject getProtectionDomain() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        try {
            J9ObjectPointer ptr = this.j9class.protectionDomain();
            if (ptr.isNull()) {
                return null;
            }
            return new DTFJJavaObject(ptr);
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
    }

    public boolean isPacked() {
        return false;
    }

    public long getPackedDataSize() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        return 0L;
    }

    private static class SuperClassCacheEntry {
        public final JavaClass superClass;

        public SuperClassCacheEntry(JavaClass superClass) {
            this.superClass = superClass;
        }
    }
}

