/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.tools.ddrinteractive.structureformat.base;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.BaseFieldFormatter;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.FormatWalkResult;
import com.ibm.j9ddr.tools.ddrinteractive.IStructureFormatter;
import com.ibm.j9ddr.tools.ddrinteractive.StructureCommandUtil;
import com.ibm.j9ddr.vm23.pointer.I32Pointer;
import com.ibm.j9ddr.vm23.pointer.IDATAPointer;
import com.ibm.j9ddr.vm23.pointer.Pointer;
import java.io.PrintStream;

public class J9SRPFormatter
extends BaseFieldFormatter {
    private final int typeCode;
    private final String srpPrefix;
    private final boolean wide;

    public J9SRPFormatter(int typeCode, String srpPrefix, boolean wide) {
        this.typeCode = typeCode;
        this.srpPrefix = srpPrefix;
        this.wide = wide;
    }

    private String stripSRP(String type) {
        type = type.trim();
        return type.substring(this.srpPrefix.length(), type.length() - 1);
    }

    public FormatWalkResult format(String name, String type, String declaredType, int thisTypeCode, long address, PrintStream out, Context context, IStructureFormatter structureFormatter) throws CorruptDataException {
        long offset;
        Pointer ptr;
        if (thisTypeCode != this.typeCode) {
            return FormatWalkResult.KEEP_WALKING;
        }
        if (this.wide) {
            ptr = IDATAPointer.cast(address);
            offset = ((IDATAPointer)ptr).at(0L).longValue();
        } else {
            ptr = I32Pointer.cast(address);
            offset = ((I32Pointer)ptr).at(0L).longValue();
        }
        if (declaredType.contains("(")) {
            String srpType = this.stripSRP(declaredType);
            structureFormatter.formatField(name, srpType, srpType, address + offset, out, context);
        } else {
            out.print("!j9x ");
            out.print(StructureCommandUtil.formatPointer(address + offset, context));
        }
        return FormatWalkResult.STOP_WALKING;
    }
}

