/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.pointer.helper;

import com.ibm.j9ddr.AddressedCorruptDataException;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.InvalidDataTypeException;
import com.ibm.j9ddr.vm23.pointer.generated.J9ArrayClassPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm23.structure.J9Consts;
import java.util.HashMap;
import java.util.Map;

public class J9ClassHelper {
    private static final Map<String, Character> TYPE_MAP = new HashMap<String, Character>();
    private static final int MAXIMUM_ARRAY_ARITY = 100;

    public static String getArrayName(J9ClassPointer clazz) throws CorruptDataException {
        J9ArrayClassPointer arrayClass = J9ArrayClassPointer.cast(clazz);
        StringBuilder name = new StringBuilder();
        int arity = 0;
        try {
            arity = arrayClass.arity().intValue();
        }
        catch (InvalidDataTypeException e) {
            throw new AddressedCorruptDataException(arrayClass.getAddress(), "Array arity larger than MAXINT");
        }
        if (arity > 100) {
            throw new AddressedCorruptDataException(arrayClass.getAddress(), "Very high arity " + arity + " from array class 0x" + Long.toHexString(arrayClass.getAddress()));
        }
        for (int i = 0; i < arity; ++i) {
            name.append('[');
        }
        String elementClassName = arrayClass.leafComponentType().getName();
        Character type = TYPE_MAP.get(elementClassName);
        if (type != null) {
            name.append(type);
        } else {
            name.append('L');
            name.append(elementClassName);
            name.append(";");
        }
        return name.toString();
    }

    public static boolean isArrayClass(J9ClassPointer clazz) throws CorruptDataException {
        long modifiers = clazz.romClass().modifiers().longValue();
        return (modifiers & J9Consts.J9_JAVA_CLASS_ARRAY) != 0L;
    }

    public static long depth(J9ClassPointer clazz) throws CorruptDataException {
        return clazz.classDepthAndFlags().longValue() & J9Consts.J9_JAVA_CLASS_DEPTH_MASK;
    }

    static {
        TYPE_MAP.put("boolean", Character.valueOf('Z'));
        TYPE_MAP.put("byte", Character.valueOf('B'));
        TYPE_MAP.put("char", Character.valueOf('C'));
        TYPE_MAP.put("short", Character.valueOf('S'));
        TYPE_MAP.put("int", Character.valueOf('I'));
        TYPE_MAP.put("long", Character.valueOf('J'));
        TYPE_MAP.put("float", Character.valueOf('F'));
        TYPE_MAP.put("double", Character.valueOf('D'));
    }
}

