/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm23.pointer.AbstractPointer;
import com.ibm.j9ddr.vm23.pointer.PointerPointer;
import com.ibm.j9ddr.vm23.pointer.StructurePointer;
import com.ibm.j9ddr.vm23.pointer.U16Pointer;
import com.ibm.j9ddr.vm23.pointer.UDATAPointer;
import com.ibm.j9ddr.vm23.pointer.VoidPointer;
import com.ibm.j9ddr.vm23.structure.J9Pool;
import com.ibm.j9ddr.vm23.types.Scalar;
import com.ibm.j9ddr.vm23.types.U16;
import com.ibm.j9ddr.vm23.types.UDATA;

@GeneratedPointerClass(structureClass=J9Pool.class)
public class J9PoolPointer
extends StructurePointer {
    public static final J9PoolPointer NULL = new J9PoolPointer(0L);
    private static final boolean CACHE_FIELDS = false;
    private static final boolean CACHE_CLASS = false;

    protected J9PoolPointer(long address) {
        super(address);
    }

    public static J9PoolPointer cast(AbstractPointer structure) {
        return J9PoolPointer.cast(structure.getAddress());
    }

    public static J9PoolPointer cast(UDATA udata) {
        return J9PoolPointer.cast(udata.longValue());
    }

    public static J9PoolPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new J9PoolPointer(address);
    }

    public J9PoolPointer add(long count) {
        return J9PoolPointer.cast(this.address + J9Pool.SIZEOF * count);
    }

    public J9PoolPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    public J9PoolPointer addOffset(long offset) {
        return J9PoolPointer.cast(this.address + offset);
    }

    public J9PoolPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    public J9PoolPointer sub(long count) {
        return J9PoolPointer.cast(this.address - J9Pool.SIZEOF * count);
    }

    public J9PoolPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    public J9PoolPointer subOffset(long offset) {
        return J9PoolPointer.cast(this.address - offset);
    }

    public J9PoolPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    public J9PoolPointer untag(long mask) {
        return J9PoolPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public J9PoolPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    protected long sizeOfBaseType() {
        return J9Pool.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_activePuddleOffset_", declaredType="struct J9Pool*")
    public J9PoolPointer activePuddle() throws CorruptDataException {
        long pointer = this.getPointerAtOffset(J9Pool._activePuddleOffset_);
        return J9PoolPointer.cast(pointer);
    }

    public PointerPointer activePuddleEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9Pool._activePuddleOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_alignmentOffset_", declaredType="U16")
    public U16 alignment() throws CorruptDataException {
        return new U16(this.getShortAtOffset(J9Pool._alignmentOffset_));
    }

    public U16Pointer alignmentEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U16Pointer.cast(this.address + (long)J9Pool._alignmentOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_elementSizeOffset_", declaredType="UDATA")
    public UDATA elementSize() throws CorruptDataException {
        return new UDATA(this.getUDATAAtOffset(J9Pool._elementSizeOffset_));
    }

    public UDATAPointer elementSizeEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return UDATAPointer.cast(this.address + (long)J9Pool._elementSizeOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_firstElementAddressOffset_", declaredType="void*")
    public VoidPointer firstElementAddress() throws CorruptDataException {
        return VoidPointer.cast(this.getPointerAtOffset(J9Pool._firstElementAddressOffset_));
    }

    public PointerPointer firstElementAddressEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9Pool._firstElementAddressOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_firstFreeSlotOffset_", declaredType="UDATA*")
    public UDATAPointer firstFreeSlot() throws CorruptDataException {
        return UDATAPointer.cast(this.getPointerAtOffset(J9Pool._firstFreeSlotOffset_));
    }

    public PointerPointer firstFreeSlotEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9Pool._firstFreeSlotOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_flagsOffset_", declaredType="U16")
    public U16 flags() throws CorruptDataException {
        return new U16(this.getShortAtOffset(J9Pool._flagsOffset_));
    }

    public U16Pointer flagsEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U16Pointer.cast(this.address + (long)J9Pool._flagsOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_maxUsedElementsOffset_", declaredType="UDATA")
    public UDATA maxUsedElements() throws CorruptDataException {
        return new UDATA(this.getUDATAAtOffset(J9Pool._maxUsedElementsOffset_));
    }

    public UDATAPointer maxUsedElementsEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return UDATAPointer.cast(this.address + (long)J9Pool._maxUsedElementsOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_memAllocOffset_", declaredType="void*")
    public VoidPointer memAlloc() throws CorruptDataException {
        return VoidPointer.cast(this.getPointerAtOffset(J9Pool._memAllocOffset_));
    }

    public PointerPointer memAllocEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9Pool._memAllocOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_memFreeOffset_", declaredType="void*")
    public VoidPointer memFree() throws CorruptDataException {
        return VoidPointer.cast(this.getPointerAtOffset(J9Pool._memFreeOffset_));
    }

    public PointerPointer memFreeEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9Pool._memFreeOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_nextPoolOffset_", declaredType="struct J9Pool*")
    public J9PoolPointer nextPool() throws CorruptDataException {
        long pointer = this.getPointerAtOffset(J9Pool._nextPoolOffset_);
        return J9PoolPointer.cast(pointer);
    }

    public PointerPointer nextPoolEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9Pool._nextPoolOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_numberOfElementsOffset_", declaredType="UDATA")
    public UDATA numberOfElements() throws CorruptDataException {
        return new UDATA(this.getUDATAAtOffset(J9Pool._numberOfElementsOffset_));
    }

    public UDATAPointer numberOfElementsEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return UDATAPointer.cast(this.address + (long)J9Pool._numberOfElementsOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_usedElementsOffset_", declaredType="UDATA")
    public UDATA usedElements() throws CorruptDataException {
        return new UDATA(this.getUDATAAtOffset(J9Pool._usedElementsOffset_));
    }

    public UDATAPointer usedElementsEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return UDATAPointer.cast(this.address + (long)J9Pool._usedElementsOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_userDataOffset_", declaredType="void*")
    public VoidPointer userData() throws CorruptDataException {
        return VoidPointer.cast(this.getPointerAtOffset(J9Pool._userDataOffset_));
    }

    public PointerPointer userDataEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9Pool._userDataOffset_);
    }
}

