/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.j9.walkers;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.memory.Addresses;
import com.ibm.j9ddr.events.IEventListener;
import com.ibm.j9ddr.vm23.events.EventManager;
import com.ibm.j9ddr.vm23.j9.DataType;
import com.ibm.j9ddr.vm23.j9.gc.GCObjectHeapIterator;
import com.ibm.j9ddr.vm23.j9.gc.GCObjectModel;
import com.ibm.j9ddr.vm23.j9.gc.GCSegmentIterator;
import com.ibm.j9ddr.vm23.j9.walkers.HeapWalkerEvents;
import com.ibm.j9ddr.vm23.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9MemorySegmentListPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9MemorySegmentPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ObjectPointer;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeapWalker
implements IEventListener {
    private static final int STATE_INIT = 0;
    private static final int STATE_OBJECT_LIVE = 1;
    private static final int STATE_OBJECT_DEAD = 2;
    private static final int STATE_SCANNING_LIVE = 3;
    private static final int STATE_SCANNING_DEAD = 4;
    private static final int STATE_FINISHED = 5;
    private int state = 0;
    private final Logger log = Logger.getLogger("j9ddr.walkers");
    private final J9MemorySegmentPointer segment;
    private final GCObjectHeapIterator heapIterator;
    private final GCObjectModel objectModel;
    private J9ObjectPointer object = null;
    private int segmentIndex = -1;
    private long objectCount = 0L;
    private long totalObjectCount = 0L;
    private boolean lastObjectCorrupt = false;
    private final HeapWalkerEvents events;
    private Set<Object> localFlatLockedMonitors;
    private static Map<J9MemorySegmentPointer, Set<Object>> flatLockedMonitorsBySegment = new HashMap<J9MemorySegmentPointer, Set<Object>>();
    private static SortedSet<Object> flatLockedMonitors;

    public HeapWalker(J9JavaVMPointer vm, J9MemorySegmentPointer ptr, HeapWalkerEvents sink) throws CorruptDataException {
        this.segment = ptr;
        this.objectModel = GCObjectModel.fromJ9JavaVM(vm);
        this.heapIterator = GCObjectHeapIterator.fromJ9MemorySegment(vm, this.segment, true, true);
        this.events = sink;
        if (!flatLockedMonitorsBySegment.containsKey(ptr)) {
            this.localFlatLockedMonitors = new HashSet<Object>();
        }
    }

    public boolean hasNext() {
        EventManager.register(this);
        boolean result = this.heapIterator.hasNext();
        if (this.localFlatLockedMonitors != null && !flatLockedMonitorsBySegment.containsKey(this.segment) && !result) {
            flatLockedMonitorsBySegment.put(this.segment, this.localFlatLockedMonitors);
            this.localFlatLockedMonitors = null;
        }
        EventManager.unregister(this);
        return result;
    }

    public void walk() {
        if (this.hasNext()) {
            try {
                this.object = this.heapIterator.next();
                this.doState(this.objectModel, this.object);
                if (!this.hasNext()) {
                    this.state = 5;
                    this.doState(this.objectModel, this.object);
                }
            }
            catch (CorruptDataException e) {
                this.events.doCorruptData(e);
            }
        } else {
            throw new NoSuchElementException("The heap walk is complete");
        }
    }

    private void doState(GCObjectModel objectModel, J9ObjectPointer object) throws CorruptDataException {
        switch (this.state) {
            case 0: {
                this.log.fine("Scanning J9MemorySegment @ 0x" + Long.toHexString(this.segment.getAddress()));
                if (!objectModel.isDeadObject(object)) {
                    this.state = 1;
                    this.doState(objectModel, object);
                    break;
                }
                this.events.doDeadObject(object);
                break;
            }
            case 1: {
                ++this.segmentIndex;
                this.log.fine(String.format("\tStarting scan of heap segment %d start=0x%08x", this.segmentIndex, object.getAddress()));
                ++this.objectCount;
                this.state = 3;
                this.events.doSectionStart(object.getAddress());
                this.events.doLiveObject(object);
                if (this.localFlatLockedMonitors == null) break;
                this.processFlatMonitor(object);
                break;
            }
            case 2: {
                this.log.fine(String.format(" end=0x%08x object count = %d\n", object.getAddress(), this.objectCount));
                this.totalObjectCount += this.objectCount;
                this.objectCount = 0L;
                this.state = 4;
                this.events.doSectionEnd(object.getAddress());
                this.events.doDeadObject(object);
                break;
            }
            case 3: {
                if (objectModel.isDeadObject(object)) {
                    this.state = 2;
                    this.doState(objectModel, object);
                    break;
                }
                ++this.objectCount;
                this.events.doLiveObject(object);
                if (this.localFlatLockedMonitors == null) break;
                this.processFlatMonitor(object);
                break;
            }
            case 4: {
                if (!objectModel.isDeadObject(object)) {
                    this.state = 1;
                    this.doState(objectModel, object);
                    break;
                }
                this.events.doDeadObject(object);
                break;
            }
            case 5: {
                long address = object.getAddress();
                if (!objectModel.isDeadObject(object)) {
                    address += objectModel.getSizeInBytesWithHeader(object).longValue();
                }
                this.log.fine(String.format(" end=0x%08x object count = %d\n", address, this.objectCount));
                this.totalObjectCount += this.objectCount;
                this.log.fine("Total object count = " + this.totalObjectCount);
                this.events.doSectionEnd(address);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid state of " + this.state + " was detected");
            }
        }
    }

    private void processFlatMonitor(J9ObjectPointer object) {
        try {
            long lockWord;
            long monitor = object.monitor().longValue();
            if (monitor != 0L && (lockWord = monitor) != 0L && (lockWord & 1L) == 0L) {
                this.localFlatLockedMonitors.add(object);
            }
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Could not process flat monitor", e, false);
        }
    }

    public static Collection<?> getFlatLockedMonitors() throws CorruptDataException {
        if (null == flatLockedMonitors) {
            HeapWalker.initializeFlatLockedMonitors();
        }
        return flatLockedMonitors;
    }

    private static void initializeFlatLockedMonitors() throws CorruptDataException {
        J9JavaVMPointer vm = DataType.getJ9RASPointer().getVM();
        J9MemorySegmentListPointer segments = vm.objectMemorySegments();
        GCSegmentIterator segmentIterator = GCSegmentIterator.fromJ9MemorySegmentList(segments, 0L);
        flatLockedMonitors = new TreeSet<Object>(new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                J9ObjectPointer obj1 = (J9ObjectPointer)o1;
                J9ObjectPointer obj2 = (J9ObjectPointer)o2;
                return Addresses.greaterThan(obj1.getAddress(), obj2.getAddress()) ? 1 : (obj1.getAddress() == obj2.getAddress() ? 0 : -1);
            }
        });
        while (segmentIterator.hasNext()) {
            J9MemorySegmentPointer segment = segmentIterator.next();
            if (!flatLockedMonitorsBySegment.containsKey(segment)) {
                HeapWalker.doSegmentHeapWalk(vm, segment);
            }
            assert (flatLockedMonitorsBySegment.containsKey(segment));
            flatLockedMonitors.addAll((Collection<Object>)flatLockedMonitorsBySegment.get(segment));
        }
    }

    private static void doSegmentHeapWalk(J9JavaVMPointer vm, J9MemorySegmentPointer segment) throws CorruptDataException {
        HeapWalker walker = new HeapWalker(vm, segment, new DummyHeapWalkerEvents());
        while (walker.hasNext()) {
            walker.walk();
        }
    }

    @Override
    public void corruptData(String message, CorruptDataException e, boolean fatal) {
        if (!this.lastObjectCorrupt) {
            this.lastObjectCorrupt = true;
            this.events.doCorruptData(e);
        }
    }

    private static final class DummyHeapWalkerEvents
    implements HeapWalkerEvents {
        private DummyHeapWalkerEvents() {
        }

        public void doSectionStart(long address) {
        }

        public void doSectionEnd(long address) {
        }

        public void doLiveObject(J9ObjectPointer object) {
        }

        public void doDeadObject(J9ObjectPointer object) {
        }

        public void doCorruptData(CorruptDataException e) {
        }
    }
}

