/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.j9.stackwalker;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.j9.AlgorithmPicker;
import com.ibm.j9ddr.vm23.j9.BaseAlgorithm;
import com.ibm.j9ddr.vm23.j9.IAlgorithm;
import com.ibm.j9ddr.vm23.j9.stackwalker.JITStackWalker;
import com.ibm.j9ddr.vm23.j9.stackwalker.MapIterator;
import com.ibm.j9ddr.vm23.j9.stackwalker.StackWalkerUtils;
import com.ibm.j9ddr.vm23.j9.stackwalker.WalkState;
import com.ibm.j9ddr.vm23.pointer.PointerPointer;
import com.ibm.j9ddr.vm23.pointer.U16Pointer;
import com.ibm.j9ddr.vm23.pointer.U32Pointer;
import com.ibm.j9ddr.vm23.pointer.U8Pointer;
import com.ibm.j9ddr.vm23.pointer.UDATAPointer;
import com.ibm.j9ddr.vm23.pointer.VoidPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9JITExceptionTablePointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9JITStackAtlasPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm23.pointer.generated.TRBuildFlags;
import com.ibm.j9ddr.vm23.pointer.generated.TR_ByteCodeInfoPointer;
import com.ibm.j9ddr.vm23.pointer.generated.TR_InlinedCallSitePointer;
import com.ibm.j9ddr.vm23.structure.J9JITStackAtlas;
import com.ibm.j9ddr.vm23.structure.J9StackWalkConstants;
import com.ibm.j9ddr.vm23.types.I16;
import com.ibm.j9ddr.vm23.types.I32;
import com.ibm.j9ddr.vm23.types.Scalar;
import com.ibm.j9ddr.vm23.types.U16;
import com.ibm.j9ddr.vm23.types.U32;
import com.ibm.j9ddr.vm23.types.U64;
import com.ibm.j9ddr.vm23.types.U8;
import com.ibm.j9ddr.vm23.types.UDATA;
import com.ibm.j9ddr.vm23.types.UScalar;
import java.util.LinkedList;

public class MethodMetaData {
    public static final long REGISTER_MAP_VALUE_FOR_GAP = -86062338L;
    public static final long BYTE_CODE_INFO_VALUE_FOR_GAP = 0L;
    public static final long INTERNAL_PTR_REG_MASK = TRBuildFlags.host_POWER ? 262144L : Integer.MIN_VALUE;
    private static MethodMetaDataImpl impl;
    private static final AlgorithmPicker<MethodMetaDataImpl> picker;

    public static I16 getJitTotalFrameSize(J9JITExceptionTablePointer md) throws CorruptDataException {
        return MethodMetaData.getImpl().getJitTotalFrameSize(md);
    }

    public static VoidPointer getJitInlinedCallInfo(J9JITExceptionTablePointer md) throws CorruptDataException {
        return MethodMetaData.getImpl().getJitInlinedCallInfo(md);
    }

    public static void jitAddSpilledRegistersForDataResolve(WalkState walkState) throws CorruptDataException {
        MethodMetaData.getImpl().jitAddSpilledRegistersForDataResolve(walkState);
    }

    public static UDATA getJitDataResolvePushes() throws CorruptDataException {
        return MethodMetaData.getImpl().getJitDataResolvePushes();
    }

    public static VoidPointer getStackMapFromJitPC(J9JavaVMPointer javaVM, J9JITExceptionTablePointer methodMetaData, UDATA jitPC) throws CorruptDataException {
        return MethodMetaData.getImpl().getStackMapFromJitPC(javaVM, methodMetaData, jitPC);
    }

    public static J9JITStackAtlasPointer getJitGCStackAtlas(J9JITExceptionTablePointer md) throws CorruptDataException {
        return MethodMetaData.getImpl().getJitGCStackAtlas(md);
    }

    public static VoidPointer getFirstInlinedCallSite(J9JITExceptionTablePointer methodMetaData, VoidPointer stackMap) throws CorruptDataException {
        return MethodMetaData.getImpl().getFirstInlinedCallSite(methodMetaData, stackMap);
    }

    public static UDATA getJitInlineDepthFromCallSite(J9JITExceptionTablePointer methodMetaData, VoidPointer inlinedCallSite) throws CorruptDataException {
        return MethodMetaData.getImpl().getJitInlineDepthFromCallSite(methodMetaData, inlinedCallSite);
    }

    public static boolean hasMoreInlinedMethods(VoidPointer inlinedCallSite) throws CorruptDataException {
        return MethodMetaData.getImpl().hasMoreInlinedMethods(inlinedCallSite);
    }

    public static VoidPointer getInlinedMethod(VoidPointer inlinedCallSite) throws CorruptDataException {
        return MethodMetaData.getImpl().getInlinedMethod(inlinedCallSite);
    }

    public static UDATA getCurrentByteCodeIndexAndIsSameReceiver(J9JITExceptionTablePointer methodMetaData, VoidPointer stackMap, VoidPointer currentInlinedCallSite, boolean[] isSameReceiver) throws CorruptDataException {
        return MethodMetaData.getImpl().getCurrentByteCodeIndexAndIsSameReceiver(methodMetaData, stackMap, currentInlinedCallSite, isSameReceiver);
    }

    public static void jitAddSpilledRegisters(WalkState walkState) throws CorruptDataException {
        MethodMetaData.getImpl().jitAddSpilledRegisters(walkState);
    }

    public static void jitAddSpilledRegisters(WalkState walkState, VoidPointer stackMap) throws CorruptDataException {
        MethodMetaData.getImpl().jitAddSpilledRegisters(walkState, stackMap);
    }

    public static UDATAPointer getObjectArgScanCursor(WalkState walkState) throws CorruptDataException {
        return MethodMetaData.getImpl().getObjectArgScanCursor(walkState);
    }

    public static U8Pointer getJitDescriptionCursor(VoidPointer stackMap, WalkState walkState) throws CorruptDataException {
        return MethodMetaData.getImpl().getJitDescriptionCursor(stackMap, walkState);
    }

    public static U16 getJitNumberOfMapBytes(J9JITStackAtlasPointer sa) throws CorruptDataException {
        return MethodMetaData.getImpl().getJitNumberOfMapBytes(sa);
    }

    public static U32 getJitRegisterMap(J9JITExceptionTablePointer methodMetaData, VoidPointer stackMap) throws CorruptDataException {
        return MethodMetaData.getImpl().getJitRegisterMap(methodMetaData, stackMap);
    }

    public static U8Pointer getNextDescriptionCursor(J9JITExceptionTablePointer metadata, VoidPointer stackMap, U8Pointer jitDescriptionCursor) throws CorruptDataException {
        return MethodMetaData.getImpl().getNextDescriptionCursor(metadata, stackMap, jitDescriptionCursor);
    }

    public static U16 getJitNumberOfParmSlots(J9JITStackAtlasPointer sa) throws CorruptDataException {
        return MethodMetaData.getImpl().getJitNumberOfParmSlots(sa);
    }

    public static U8Pointer getJitInternalPointerMap(J9JITStackAtlasPointer sa) throws CorruptDataException {
        return MethodMetaData.getImpl().getJitInternalPointerMap(sa);
    }

    public static void walkJITFrameSlotsForInternalPointers(WalkState walkState, U8Pointer jitDescriptionCursor, UDATAPointer scanCursor, VoidPointer stackMap, J9JITStackAtlasPointer gcStackAtlas) throws CorruptDataException {
        MethodMetaData.getImpl().walkJITFrameSlotsForInternalPointers(walkState, jitDescriptionCursor, scanCursor, stackMap, gcStackAtlas);
    }

    public static VoidPointer getNextInlinedCallSite(J9JITExceptionTablePointer methodMetaData, VoidPointer inlinedCallSite) throws CorruptDataException {
        return MethodMetaData.getImpl().getNextInlinedCallSite(methodMetaData, inlinedCallSite);
    }

    public static U8 getNextDescriptionBit(U8Pointer jitDescriptionCursor) throws CorruptDataException {
        return MethodMetaData.getImpl().getNextDescriptionBit(jitDescriptionCursor);
    }

    public static UDATAPointer getObjectTempScanCursor(WalkState walkState) throws CorruptDataException {
        return MethodMetaData.getImpl().getObjectTempScanCursor(walkState);
    }

    public static int getJitRecompilationResolvePushes() {
        return MethodMetaData.getImpl().getJitRecompilationResolvePushes();
    }

    public static int getJitVirtualMethodResolvePushes() {
        return MethodMetaData.getImpl().getJitVirtualMethodResolvePushes();
    }

    public static int getJitStaticMethodResolvePushes() {
        return MethodMetaData.getImpl().getJitStaticMethodResolvePushes();
    }

    public static VoidPointer getStackAllocMapFromJitPC(J9JavaVMPointer javaVM, J9JITExceptionTablePointer methodMetaData, UDATA jitPC, VoidPointer curStackMap) throws CorruptDataException {
        return MethodMetaData.getImpl().getStackAllocMapFromJitPC(javaVM, methodMetaData, jitPC, curStackMap);
    }

    public static U8Pointer getJitStackSlots(J9JITExceptionTablePointer metaData, VoidPointer stackMap) throws CorruptDataException {
        return MethodMetaData.getImpl().getJitStackSlots(metaData, stackMap);
    }

    public static void markClassesInInlineRanges(J9JITExceptionTablePointer metaData, WalkState walkState) throws CorruptDataException {
        MethodMetaData.getImpl().markClassesInInlineRanges(metaData, walkState);
    }

    public static void jitGetMapsFromPC(J9JavaVMPointer javaVM, J9JITExceptionTablePointer methodMetaData, UDATA jitPC, JITMaps maps) throws CorruptDataException {
        MethodMetaData.getImpl().jitGetMapsFromPC(javaVM, methodMetaData, jitPC, maps);
    }

    private static MethodMetaDataImpl getImpl() {
        if (impl == null) {
            impl = picker.pickAlgorithm();
        }
        return impl;
    }

    static {
        picker = new AlgorithmPicker<MethodMetaDataImpl>("ALG_METHOD_META_DATA_VERSION"){

            @Override
            protected Iterable<? extends MethodMetaDataImpl> allAlgorithms() {
                LinkedList<MethodMetaData_23_V0> toReturn = new LinkedList<MethodMetaData_23_V0>();
                toReturn.add(new MethodMetaData_23_V0());
                return toReturn;
            }
        };
    }

    public static class JITMaps {
        public PointerPointer stackMap = PointerPointer.NULL;
        public PointerPointer inlineMap = PointerPointer.NULL;
    }

    private static interface MethodMetaDataImpl
    extends IAlgorithm {
        public UDATAPointer getObjectTempScanCursor(WalkState var1) throws CorruptDataException;

        public int getJitStaticMethodResolvePushes();

        public int getJitVirtualMethodResolvePushes();

        public int getJitRecompilationResolvePushes();

        public U8Pointer getJitDescriptionCursor(VoidPointer var1, WalkState var2) throws CorruptDataException;

        public void walkJITFrameSlotsForInternalPointers(WalkState var1, U8Pointer var2, UDATAPointer var3, VoidPointer var4, J9JITStackAtlasPointer var5) throws CorruptDataException;

        public U8Pointer getJitInternalPointerMap(J9JITStackAtlasPointer var1) throws CorruptDataException;

        public U16 getJitNumberOfParmSlots(J9JITStackAtlasPointer var1) throws CorruptDataException;

        public U8Pointer getNextDescriptionCursor(J9JITExceptionTablePointer var1, VoidPointer var2, U8Pointer var3) throws CorruptDataException;

        public U32 getJitRegisterMap(J9JITExceptionTablePointer var1, VoidPointer var2) throws CorruptDataException;

        public U16 getJitNumberOfMapBytes(J9JITStackAtlasPointer var1) throws CorruptDataException;

        public I16 getJitTotalFrameSize(J9JITExceptionTablePointer var1) throws CorruptDataException;

        public UDATAPointer getObjectArgScanCursor(WalkState var1) throws CorruptDataException;

        public UDATA getCurrentByteCodeIndexAndIsSameReceiver(J9JITExceptionTablePointer var1, VoidPointer var2, VoidPointer var3, boolean[] var4) throws CorruptDataException;

        public boolean hasMoreInlinedMethods(VoidPointer var1) throws CorruptDataException;

        public VoidPointer getInlinedMethod(VoidPointer var1) throws CorruptDataException;

        public UDATA getJitInlineDepthFromCallSite(J9JITExceptionTablePointer var1, VoidPointer var2) throws CorruptDataException;

        public VoidPointer getFirstInlinedCallSite(J9JITExceptionTablePointer var1, VoidPointer var2) throws CorruptDataException;

        public VoidPointer getNextInlinedCallSite(J9JITExceptionTablePointer var1, VoidPointer var2) throws CorruptDataException;

        public J9JITStackAtlasPointer getJitGCStackAtlas(J9JITExceptionTablePointer var1) throws CorruptDataException;

        public VoidPointer getStackMapFromJitPC(J9JavaVMPointer var1, J9JITExceptionTablePointer var2, UDATA var3) throws CorruptDataException;

        public UDATA getJitDataResolvePushes() throws CorruptDataException;

        public void jitAddSpilledRegistersForDataResolve(WalkState var1) throws CorruptDataException;

        public VoidPointer getJitInlinedCallInfo(J9JITExceptionTablePointer var1) throws CorruptDataException;

        public void jitGetMapsFromPC(J9JavaVMPointer var1, J9JITExceptionTablePointer var2, UDATA var3, JITMaps var4) throws CorruptDataException;

        public void jitAddSpilledRegisters(WalkState var1) throws CorruptDataException;

        public void jitAddSpilledRegisters(WalkState var1, VoidPointer var2) throws CorruptDataException;

        public U8 getNextDescriptionBit(U8Pointer var1) throws CorruptDataException;

        public VoidPointer getStackAllocMapFromJitPC(J9JavaVMPointer var1, J9JITExceptionTablePointer var2, UDATA var3, VoidPointer var4) throws CorruptDataException;

        public U8Pointer getJitStackSlots(J9JITExceptionTablePointer var1, VoidPointer var2) throws CorruptDataException;

        public void markClassesInInlineRanges(J9JITExceptionTablePointer var1, WalkState var2) throws CorruptDataException;
    }

    private static class MethodMetaData_23_V0
    extends BaseAlgorithm
    implements MethodMetaDataImpl {
        private static boolean alignStackMaps = TRBuildFlags.host_ARM || TRBuildFlags.host_SH4 || TRBuildFlags.host_MIPS;

        protected MethodMetaData_23_V0() {
            super(30, 0);
        }

        public I16 getJitTotalFrameSize(J9JITExceptionTablePointer md) throws CorruptDataException {
            return new I16(md.totalFrameSize());
        }

        public VoidPointer getJitInlinedCallInfo(J9JITExceptionTablePointer md) throws CorruptDataException {
            return md.inlinedCalls();
        }

        public void jitAddSpilledRegistersForDataResolve(WalkState walkState) throws CorruptDataException {
            UDATAPointer slotCursor = walkState.unwindSP.add(MethodMetaData_23_V0.getJitSlotsBeforeSavesInDataResolve());
            int mapCursor = 0;
            int i = 0;
            while ((long)i < J9StackWalkConstants.J9SW_POTENTIAL_SAVED_REGISTERS) {
                walkState.registerEAs[mapCursor++] = slotCursor;
                slotCursor = slotCursor.add(1L);
                ++i;
            }
            StackWalkerUtils.swPrintf(walkState, 2, "\t{0} slots skipped before scalar registers", MethodMetaData_23_V0.getJitSlotsBeforeSavesInDataResolve());
            JITStackWalker.jitPrintRegisterMapArray(walkState, "DataResolve");
        }

        private static UDATA getJitSlotsBeforeSavesInDataResolve() {
            if (TRBuildFlags.host_X86 && TRBuildFlags.host_64BIT) {
                return new UDATA(16L);
            }
            if (TRBuildFlags.host_X86) {
                return new UDATA(20L);
            }
            return new UDATA(0L);
        }

        public void jitAddSpilledRegisters(WalkState walkState) throws CorruptDataException {
            UDATA saveOffset = new UDATA(0L);
            UDATA lowestRegister = new UDATA(0L);
            int mapCursor = 0;
            UDATA registerSaveDescription = this.getJitRegisterSaveDescription(walkState.jitInfo);
            if (TRBuildFlags.host_X86) {
                UDATA prologuePushes = new UDATA(this.getJitProloguePushes(walkState.jitInfo));
                if (!prologuePushes.eq(0L)) {
                    UDATAPointer saveCursor = walkState.bp.sub(new UDATA(this.getJitScalarTempSlots(walkState.jitInfo)).add(new UDATA(this.getJitObjectTempSlots(walkState.jitInfo))).add(prologuePushes));
                    registerSaveDescription = registerSaveDescription.bitAnd(J9StackWalkConstants.J9SW_REGISTER_MAP_MASK);
                    do {
                        if (registerSaveDescription.anyBitsIn(1L)) {
                            walkState.registerEAs[mapCursor] = saveCursor;
                            saveCursor = saveCursor.add(1L);
                        }
                        ++mapCursor;
                    } while (!(registerSaveDescription = registerSaveDescription.rightShift(1)).eq(0L));
                }
            } else if (TRBuildFlags.host_POWER || TRBuildFlags.host_MIPS) {
                UDATA savedGPRs = registerSaveDescription.bitAnd(31);
                if (TRBuildFlags.host_POWER) {
                    saveOffset = registerSaveDescription.rightShift(11);
                    lowestRegister = new UDATA(32L).sub(savedGPRs);
                } else if (TRBuildFlags.host_MIPS) {
                    saveOffset = registerSaveDescription.rightShift(13);
                    lowestRegister = new UDATA(24L).sub(savedGPRs);
                }
                UDATAPointer saveCursor = walkState.bp.subOffset(saveOffset);
                mapCursor += lowestRegister.intValue();
                while (!savedGPRs.eq(0L)) {
                    walkState.registerEAs[mapCursor++] = saveCursor;
                    saveCursor = saveCursor.add(1L);
                    savedGPRs = savedGPRs.sub(1L);
                }
            } else if (TRBuildFlags.host_ARM || TRBuildFlags.host_SH4 || TRBuildFlags.host_S390) {
                UDATA savedGPRs = registerSaveDescription.bitAnd(65535);
                if (!savedGPRs.eq(0L)) {
                    saveOffset = registerSaveDescription.rightShift(16).bitAnd(65535);
                    UDATAPointer saveCursor = walkState.bp.subOffset(saveOffset);
                    do {
                        if (savedGPRs.anyBitsIn(1L)) {
                            walkState.registerEAs[mapCursor] = saveCursor;
                            saveCursor = saveCursor.add(1L);
                        }
                        ++mapCursor;
                    } while (!(savedGPRs = savedGPRs.rightShift(1)).eq(0L));
                }
            } else {
                throw new InternalError("Bad TR platform state. Should be impossible");
            }
            JITStackWalker.jitPrintRegisterMapArray(walkState, "Frame");
        }

        public void jitAddSpilledRegisters(WalkState walkState, VoidPointer stackMap) throws CorruptDataException {
            throw new UnsupportedOperationException("Not implemented at 2.3");
        }

        private UDATA getJitRegisterSaveDescription(J9JITExceptionTablePointer md) throws CorruptDataException {
            return md.registerSaveDescription();
        }

        public U16 getJitProloguePushes(J9JITExceptionTablePointer md) throws CorruptDataException {
            return md.prologuePushes();
        }

        public I16 getJitScalarTempSlots(J9JITExceptionTablePointer md) throws CorruptDataException {
            return md.scalarTempSlots();
        }

        public I16 getJitObjectTempSlots(J9JITExceptionTablePointer md) throws CorruptDataException {
            return md.objectTempSlots();
        }

        public UDATA getJitDataResolvePushes() throws CorruptDataException {
            if (TRBuildFlags.host_X86 && TRBuildFlags.host_64BIT) {
                return new UDATA(35L);
            }
            if (TRBuildFlags.host_X86) {
                return new UDATA(32L);
            }
            if (TRBuildFlags.host_ARM) {
                return new UDATA(12L);
            }
            if (TRBuildFlags.host_S390) {
                return new UDATA(16L);
            }
            if (TRBuildFlags.host_POWER) {
                return new UDATA(33L);
            }
            if (TRBuildFlags.host_MIPS) {
                return new UDATA(32L);
            }
            if (TRBuildFlags.host_SH4) {
                return new UDATA(16L);
            }
            return new UDATA(0L);
        }

        public VoidPointer getStackMapFromJitPC(J9JavaVMPointer javaVM, J9JITExceptionTablePointer methodMetaData, UDATA jitPC) throws CorruptDataException {
            JITMaps maps = new JITMaps();
            this.jitGetMapsFromPC(javaVM, methodMetaData, jitPC, maps);
            return VoidPointer.cast(maps.stackMap);
        }

        public J9JITStackAtlasPointer getJitGCStackAtlas(J9JITExceptionTablePointer md) throws CorruptDataException {
            return J9JITStackAtlasPointer.cast(md.gcStackAtlas());
        }

        public void jitGetMapsFromPC(J9JavaVMPointer javaVM, J9JITExceptionTablePointer methodMetaData, UDATA jitPC, JITMaps maps) throws CorruptDataException {
            MapIterator i = new MapIterator();
            UDATA offsetPC = jitPC.sub(methodMetaData.startPC()).sub(1L);
            boolean fourByteOffsets = MethodMetaData_23_V0.HAS_FOUR_BYTE_OFFSET(methodMetaData);
            maps.stackMap = PointerPointer.NULL;
            maps.inlineMap = PointerPointer.NULL;
            if (methodMetaData.gcStackAtlas().isNull()) {
                return;
            }
            this.initializeIterator(i, methodMetaData);
            this.findMapsAtPC(i, offsetPC, maps, fourByteOffsets);
        }

        private void findMapsAtPC(MapIterator i, UDATA offsetPC, JITMaps maps, boolean fourByteOffsets) throws CorruptDataException {
            while (this.getNextMap(i, fourByteOffsets).notNull()) {
                if (!this.matchingRange(i, offsetPC)) continue;
                maps.stackMap = MethodMetaData_23_V0.currentStackMap(i);
                maps.inlineMap = MethodMetaData_23_V0.currentInlineMap(i);
                break;
            }
        }

        private static PointerPointer currentInlineMap(MapIterator i) {
            return i._isGap ? PointerPointer.NULL : PointerPointer.cast(i._currentInlineMap);
        }

        private static PointerPointer currentStackMap(MapIterator i) {
            return i._isGap ? PointerPointer.NULL : PointerPointer.cast(i._currentStackMap);
        }

        private boolean matchingRange(MapIterator i, UDATA offset) {
            return i._rangeStartOffset.lte(offset) && offset.lte(i._rangeEndOffset);
        }

        private U8Pointer getNextMap(MapIterator i, boolean fourByteOffsets) throws CorruptDataException {
            i._currentMap = i._nextMap;
            if (i._currentMap.notNull()) {
                i._isGap = MethodMetaData_23_V0.IS_GAP_RANGE(fourByteOffsets, i._currentMap);
                if (!i._isGap) {
                    i._currentInlineMap = i._currentMap;
                    if (!MethodMetaData_23_V0.IS_BYTECODEINFO_MAP(fourByteOffsets, i._currentMap)) {
                        i._currentStackMap = i._currentMap;
                    }
                }
                i._rangeStartOffset = MethodMetaData_23_V0.GET_LOW_PC_OFFSET_VALUE(fourByteOffsets, i._currentMap);
                i._mapIndex = i._mapIndex.add(1);
                if (i._mapIndex.lt(i._stackAtlas.numberOfMaps())) {
                    i._nextMap = MethodMetaData_23_V0.GET_NEXT_STACK_MAP(fourByteOffsets, i._currentMap, i._stackAtlas);
                    i._rangeEndOffset = MethodMetaData_23_V0.GET_LOW_PC_OFFSET_VALUE(fourByteOffsets, i._nextMap).sub(1L);
                } else {
                    i._nextMap = U8Pointer.NULL;
                    i._rangeEndOffset = i._methodMetaData.endPC().sub(i._methodMetaData.startPC()).sub(1L);
                }
            }
            return i._currentMap;
        }

        private static U32 GET_BYTECODEINFO_VALUE(boolean fourByteOffset, U8Pointer stackMap) throws CorruptDataException {
            return U32Pointer.cast(stackMap.add(MethodMetaData_23_V0.SIZEOF_MAP_OFFSET(fourByteOffset))).at(0L);
        }

        private static U32 GET_REGISTER_MAP_VALUE(boolean fourByteOffset, U8Pointer stackMap) throws CorruptDataException {
            return U32Pointer.cast(stackMap.add(MethodMetaData_23_V0.SIZEOF_MAP_OFFSET(fourByteOffset)).add(4L)).at(0L);
        }

        private static UDATA GET_LOW_PC_OFFSET_VALUE(boolean fourByteOffset, U8Pointer stackMap) throws CorruptDataException {
            UScalar returnValue = null;
            returnValue = fourByteOffset ? U32Pointer.cast(MethodMetaData_23_V0.ADDRESS_OF_LOW_PC_OFFSET_IN_STACK_MAP(fourByteOffset, stackMap)).at(0L) : U16Pointer.cast(MethodMetaData_23_V0.ADDRESS_OF_LOW_PC_OFFSET_IN_STACK_MAP(fourByteOffset, stackMap)).at(0L);
            return new UDATA(returnValue);
        }

        private static U32 GET_SIZEOF_GAP_MAP(boolean fourByteOffset) {
            return new U32(8L).add(MethodMetaData_23_V0.SIZEOF_MAP_OFFSET(fourByteOffset));
        }

        private static U32 GET_SIZEOF_STACK_MAP_NOT_INCLUDE_INTERNAL_PTR(boolean fourByteOffset, J9JITStackAtlasPointer atlas) throws CorruptDataException {
            return new U32(8L).add(MethodMetaData_23_V0.SIZEOF_MAP_OFFSET(fourByteOffset)).add(atlas.numberOfMapBytes());
        }

        private static U32 GET_SIZEOF_BYTECODEINFO_MAP(boolean fourByteOffset) {
            return new U32(4L).add(MethodMetaData_23_V0.SIZEOF_MAP_OFFSET(fourByteOffset));
        }

        private static U8Pointer ADDRESS_OF_BYTECODEINFO_IN_STACK_MAP(boolean fourByteOffset, U8Pointer stackMap) {
            return stackMap.add(MethodMetaData_23_V0.SIZEOF_MAP_OFFSET(fourByteOffset));
        }

        private static U8Pointer ADDRESS_OF_LOW_PC_OFFSET_IN_STACK_MAP(boolean fourByteOffset, U8Pointer stackMap) {
            return stackMap;
        }

        private static U8Pointer ADDRESS_OF_REGISTERMAP(boolean fourByteOffset, U8Pointer stackMap) {
            return stackMap.add(MethodMetaData_23_V0.SIZEOF_MAP_OFFSET(fourByteOffset)).add(4L);
        }

        private static boolean RANGE_NEEDS_FOUR_BYTE_OFFSET(Scalar s) {
            return !new U16(s).eq(new U64(s));
        }

        private static boolean HAS_FOUR_BYTE_OFFSET(J9JITExceptionTablePointer md) throws CorruptDataException {
            return MethodMetaData_23_V0.RANGE_NEEDS_FOUR_BYTE_OFFSET(md.endPC().sub(md.startPC()));
        }

        private static U32 SIZEOF_MAP_OFFSET(boolean fourByteOffset) {
            return alignStackMaps || fourByteOffset ? new U32(4L) : new U32(2L);
        }

        private static boolean IS_GAP_RANGE(boolean fourByteOffset, U8Pointer stackMap) throws CorruptDataException {
            return MethodMetaData_23_V0.GET_BYTECODEINFO_VALUE(fourByteOffset, stackMap).eq(0L) && MethodMetaData_23_V0.GET_REGISTER_MAP_VALUE(fourByteOffset, stackMap).eq(-86062338L);
        }

        private static boolean IS_BYTECODEINFO_MAP(boolean fourByteOffset, U8Pointer stackMap) throws CorruptDataException {
            return !TR_ByteCodeInfoPointer.cast(MethodMetaData_23_V0.ADDRESS_OF_BYTECODEINFO_IN_STACK_MAP(fourByteOffset, stackMap))._doNotProfile().eq(0L);
        }

        private static U8Pointer GET_NEXT_STACK_MAP(boolean fourByteOffset, U8Pointer stackMap, J9JITStackAtlasPointer atlas) throws CorruptDataException {
            U8Pointer nextStackMap = stackMap;
            if (MethodMetaData_23_V0.IS_BYTECODEINFO_MAP(fourByteOffset, stackMap)) {
                nextStackMap = nextStackMap.add(MethodMetaData_23_V0.GET_SIZEOF_BYTECODEINFO_MAP(fourByteOffset));
            } else if (MethodMetaData_23_V0.IS_GAP_RANGE(fourByteOffset, stackMap)) {
                nextStackMap = nextStackMap.add(MethodMetaData_23_V0.GET_SIZEOF_GAP_MAP(fourByteOffset));
            } else {
                nextStackMap = nextStackMap.add(MethodMetaData_23_V0.GET_SIZEOF_STACK_MAP_NOT_INCLUDE_INTERNAL_PTR(fourByteOffset, atlas));
                if (MethodMetaData_23_V0.GET_REGISTER_MAP_VALUE(fourByteOffset, stackMap).anyBitsIn(INTERNAL_PTR_REG_MASK) && atlas.internalPointerMap().notNull()) {
                    nextStackMap = nextStackMap.add(new U32(1L).add(stackMap.add(MethodMetaData_23_V0.GET_SIZEOF_GAP_MAP(fourByteOffset)).at(0L)));
                }
            }
            return nextStackMap;
        }

        private void initializeIterator(MapIterator i, J9JITExceptionTablePointer methodMetaData) throws CorruptDataException {
            i._methodMetaData = methodMetaData;
            i._stackAtlas = J9JITStackAtlasPointer.cast(methodMetaData.gcStackAtlas());
            i._currentStackMap = U8Pointer.NULL;
            i._currentInlineMap = U8Pointer.NULL;
            i._nextMap = this.getFirstStackMap(U8Pointer.cast(i._stackAtlas));
            i._mapIndex = new U32(0L);
        }

        private U8Pointer getFirstStackMap(U8Pointer mapBits) {
            return mapBits.add(J9JITStackAtlas.SIZEOF);
        }

        public VoidPointer getFirstInlinedCallSite(J9JITExceptionTablePointer methodMetaData, VoidPointer stackMap) throws CorruptDataException {
            return this.getFirstInlinedCallSiteWithByteCodeInfo(methodMetaData, stackMap, VoidPointer.NULL);
        }

        private VoidPointer getFirstInlinedCallSiteWithByteCodeInfo(J9JITExceptionTablePointer methodMetaData, VoidPointer stackMap, VoidPointer byteCodeInfo) throws CorruptDataException {
            TR_InlinedCallSitePointer inlinedCallSiteArray = TR_InlinedCallSitePointer.cast(this.getJitInlinedCallInfo(methodMetaData));
            if (inlinedCallSiteArray.notNull()) {
                I32 cix;
                TR_InlinedCallSitePointer firstInlinedCallSite = TR_InlinedCallSitePointer.NULL;
                if (byteCodeInfo.isNull()) {
                    byteCodeInfo = VoidPointer.cast(MethodMetaData_23_V0.ADDRESS_OF_BYTECODEINFO_IN_STACK_MAP(MethodMetaData_23_V0.HAS_FOUR_BYTE_OFFSET(methodMetaData), U8Pointer.cast(stackMap)));
                }
                if ((cix = TR_ByteCodeInfoPointer.cast(byteCodeInfo)._callerIndex()).lt(new I32(0L))) {
                    return VoidPointer.NULL;
                }
                firstInlinedCallSite = inlinedCallSiteArray.add(cix);
                return VoidPointer.cast(firstInlinedCallSite);
            }
            return VoidPointer.NULL;
        }

        public UDATA getJitInlineDepthFromCallSite(J9JITExceptionTablePointer methodMetaData, VoidPointer inlinedCallSite) throws CorruptDataException {
            UDATA inlineDepth = new UDATA(0L);
            do {
                inlineDepth = inlineDepth.add(1L);
            } while ((inlinedCallSite = this.getNextInlinedCallSite(methodMetaData, inlinedCallSite)).notNull());
            return inlineDepth;
        }

        public VoidPointer getNextInlinedCallSite(J9JITExceptionTablePointer methodMetaData, VoidPointer inlinedCallSite) throws CorruptDataException {
            TR_InlinedCallSitePointer nextInlinedCallSite = TR_InlinedCallSitePointer.NULL;
            TR_InlinedCallSitePointer inlinedCallSiteArray = TR_InlinedCallSitePointer.cast(this.getJitInlinedCallInfo(methodMetaData));
            if (this.hasMoreInlinedMethods(inlinedCallSite)) {
                TR_ByteCodeInfoPointer byteCodeInfo = this.getByteCodeInfo(inlinedCallSite);
                nextInlinedCallSite = inlinedCallSiteArray.add(byteCodeInfo._callerIndex());
            }
            return VoidPointer.cast(nextInlinedCallSite);
        }

        public boolean hasMoreInlinedMethods(VoidPointer inlinedCallSite) throws CorruptDataException {
            TR_ByteCodeInfoPointer byteCodeInfo = this.getByteCodeInfo(inlinedCallSite);
            return !byteCodeInfo._callerIndex().lt(new I32(0L));
        }

        private TR_ByteCodeInfoPointer getByteCodeInfo(VoidPointer inlinedCallSite) throws CorruptDataException {
            return TR_ByteCodeInfoPointer.cast(TR_InlinedCallSitePointer.cast(inlinedCallSite)._byteCodeInfoEA());
        }

        public VoidPointer getInlinedMethod(VoidPointer inlinedCallSite) throws CorruptDataException {
            return TR_InlinedCallSitePointer.cast(inlinedCallSite)._vmMethodInfo();
        }

        public UDATA getCurrentByteCodeIndexAndIsSameReceiver(J9JITExceptionTablePointer methodMetaData, VoidPointer stackMap, VoidPointer currentInlinedCallSite, boolean[] isSameReceiver) throws CorruptDataException {
            TR_ByteCodeInfoPointer byteCodeInfo = TR_ByteCodeInfoPointer.cast(this.getByteCodeInfoFromStackMap(methodMetaData, stackMap));
            if (currentInlinedCallSite.notNull()) {
                VoidPointer inlinedCallSite = this.getFirstInlinedCallSiteWithByteCodeInfo(methodMetaData, stackMap, VoidPointer.cast(byteCodeInfo));
                if (!inlinedCallSite.eq(currentInlinedCallSite)) {
                    VoidPointer previousInlinedCallSite;
                    do {
                        previousInlinedCallSite = inlinedCallSite;
                    } while (!(inlinedCallSite = this.getNextInlinedCallSite(methodMetaData, inlinedCallSite)).eq(currentInlinedCallSite));
                    byteCodeInfo = this.getByteCodeInfo(previousInlinedCallSite);
                }
            } else if (!byteCodeInfo._callerIndex().eq(-1L)) {
                VoidPointer inlinedCallSite = this.getFirstInlinedCallSiteWithByteCodeInfo(methodMetaData, stackMap, VoidPointer.cast(byteCodeInfo));
                while (this.hasMoreInlinedMethods(inlinedCallSite)) {
                    inlinedCallSite = this.getNextInlinedCallSite(methodMetaData, inlinedCallSite);
                }
                byteCodeInfo = this.getByteCodeInfo(inlinedCallSite);
            }
            if (isSameReceiver != null) {
                isSameReceiver[0] = !byteCodeInfo._isSameReceiver().eq(0L);
            }
            return new UDATA(byteCodeInfo._byteCodeIndex());
        }

        private VoidPointer getByteCodeInfoFromStackMap(J9JITExceptionTablePointer methodMetaData, VoidPointer stackMap) throws CorruptDataException {
            return VoidPointer.cast(MethodMetaData_23_V0.ADDRESS_OF_BYTECODEINFO_IN_STACK_MAP(MethodMetaData_23_V0.HAS_FOUR_BYTE_OFFSET(methodMetaData), U8Pointer.cast(stackMap)));
        }

        public UDATAPointer getObjectArgScanCursor(WalkState walkState) throws CorruptDataException {
            return UDATAPointer.cast(U8Pointer.cast(walkState.bp).addOffset(J9JITStackAtlasPointer.cast(walkState.jitInfo.gcStackAtlas()).parmBaseOffset()));
        }

        public U8Pointer getJitDescriptionCursor(VoidPointer stackMap, WalkState walkState) throws CorruptDataException {
            return U8Pointer.cast(stackMap.addOffset(MethodMetaData_23_V0.GET_SIZEOF_GAP_MAP(MethodMetaData_23_V0.HAS_FOUR_BYTE_OFFSET(walkState.jitInfo))));
        }

        public U16 getJitNumberOfMapBytes(J9JITStackAtlasPointer sa) throws CorruptDataException {
            return sa.numberOfMapBytes();
        }

        public U32 getJitRegisterMap(J9JITExceptionTablePointer methodMetaData, VoidPointer stackMap) throws CorruptDataException {
            return U32Pointer.cast(stackMap.addOffset(MethodMetaData_23_V0.SIZEOF_MAP_OFFSET(MethodMetaData_23_V0.HAS_FOUR_BYTE_OFFSET(methodMetaData))).addOffset(4L)).at(0L);
        }

        public U8Pointer getNextDescriptionCursor(J9JITExceptionTablePointer metadata, VoidPointer stackMap, U8Pointer jitDescriptionCursor) throws CorruptDataException {
            U8 variableInternalPtrSize = new U8(0L);
            if (this.getJitRegisterMap(metadata, stackMap).anyBitsIn(INTERNAL_PTR_REG_MASK) && this.getJitInternalPointerMap(this.getJitGCStackAtlas(metadata)).notNull()) {
                variableInternalPtrSize = jitDescriptionCursor.at(0L).add(1);
            }
            jitDescriptionCursor = jitDescriptionCursor.add(variableInternalPtrSize);
            return jitDescriptionCursor;
        }

        public U8Pointer getJitInternalPointerMap(J9JITStackAtlasPointer sa) throws CorruptDataException {
            return sa.internalPointerMap();
        }

        public U16 getJitNumberOfParmSlots(J9JITStackAtlasPointer sa) throws CorruptDataException {
            return sa.numberOfParmSlots();
        }

        public U8 getNextDescriptionBit(U8Pointer jitDescriptionCursor) throws CorruptDataException {
            return jitDescriptionCursor.at(0L);
        }

        public UDATAPointer getObjectTempScanCursor(WalkState walkState) throws CorruptDataException {
            return walkState.bp.addOffset(J9JITStackAtlasPointer.cast(walkState.jitInfo.gcStackAtlas()).localBaseOffset());
        }

        public int getJitRecompilationResolvePushes() {
            if (TRBuildFlags.host_X86 && TRBuildFlags.host_64BIT) {
                return 9;
            }
            if (TRBuildFlags.host_X86) {
                return 3;
            }
            if (TRBuildFlags.host_S390) {
                return 7 + 64 / UDATA.SIZEOF;
            }
            if (TRBuildFlags.host_POWER) {
                return 3;
            }
            return 0;
        }

        public int getJitVirtualMethodResolvePushes() {
            if (TRBuildFlags.host_X86 && TRBuildFlags.host_64BIT) {
                return 2;
            }
            if (TRBuildFlags.host_X86) {
                return 4;
            }
            if (TRBuildFlags.host_POWER) {
                return 0;
            }
            if (TRBuildFlags.host_SH4) {
                return 2;
            }
            return 0;
        }

        public int getJitStaticMethodResolvePushes() {
            if (TRBuildFlags.host_X86 && TRBuildFlags.host_64BIT) {
                return 1;
            }
            if (TRBuildFlags.host_X86) {
                return 1;
            }
            return 0;
        }

        public void walkJITFrameSlotsForInternalPointers(WalkState walkState, U8Pointer jitDescriptionCursor, UDATAPointer scanCursor, VoidPointer stackMap, J9JITStackAtlasPointer gcStackAtlas) throws CorruptDataException {
            VoidPointer internalPointerMap = VoidPointer.cast(gcStackAtlas.internalPointerMap());
            U8Pointer tempJitDescriptionCursor = U8Pointer.cast(internalPointerMap);
            UDATA parmStackMap = UDATAPointer.cast(tempJitDescriptionCursor).at(0L);
            if (parmStackMap.eq(UDATA.cast(stackMap))) {
                return;
            }
            tempJitDescriptionCursor = tempJitDescriptionCursor.add(UDATA.SIZEOF);
            StackWalkerUtils.swPrintf(walkState, 6, "Address {0}", StackWalkerUtils.formatPointer(tempJitDescriptionCursor));
            U8 numInternalPtrMapBytes = tempJitDescriptionCursor.at(0L);
            tempJitDescriptionCursor = tempJitDescriptionCursor.add(1L);
            if (alignStackMaps) {
                tempJitDescriptionCursor = tempJitDescriptionCursor.add(1L);
            }
            StackWalkerUtils.swPrintf(walkState, 6, "Num internal ptr map bytes {0}", numInternalPtrMapBytes);
            I16 indexOfFirstInternalPtr = new I16(U16Pointer.cast(tempJitDescriptionCursor).at(0L));
            StackWalkerUtils.swPrintf(walkState, 6, "Address {0}", StackWalkerUtils.formatPointer(tempJitDescriptionCursor));
            tempJitDescriptionCursor = tempJitDescriptionCursor.add(2L);
            StackWalkerUtils.swPrintf(walkState, 6, "Index of first internal ptr {0}", indexOfFirstInternalPtr);
            I16 offsetOfFirstInternalPtr = new I16(U16Pointer.cast(tempJitDescriptionCursor).at(0L));
            StackWalkerUtils.swPrintf(walkState, 6, "Address {0}", StackWalkerUtils.formatPointer(tempJitDescriptionCursor));
            tempJitDescriptionCursor = tempJitDescriptionCursor.add(2L);
            StackWalkerUtils.swPrintf(walkState, 6, "Offset of first internal ptr {0}", offsetOfFirstInternalPtr);
            StackWalkerUtils.swPrintf(walkState, 6, "Address {0}", StackWalkerUtils.formatPointer(tempJitDescriptionCursor));
            U8 numDistinctPinningArrays = tempJitDescriptionCursor.at(0L);
            tempJitDescriptionCursor = tempJitDescriptionCursor.add(1L);
            StackWalkerUtils.swPrintf(walkState, 6, "Num distinct pinning arrays {0}", numDistinctPinningArrays);
            U8 i = new U8(0L);
            while (i.lt(numDistinctPinningArrays)) {
                U8 currPinningArrayIndex = tempJitDescriptionCursor.at(0L);
                tempJitDescriptionCursor = tempJitDescriptionCursor.add(1L);
                U8 numInternalPtrsForArray = tempJitDescriptionCursor.at(0L);
                tempJitDescriptionCursor = tempJitDescriptionCursor.add(1L);
                PointerPointer currPinningArrayCursor = PointerPointer.cast(walkState.bp.addOffset(offsetOfFirstInternalPtr.add(new U16(currPinningArrayIndex).mult(UDATA.SIZEOF))));
                J9ObjectPointer oldPinningArrayAddress = J9ObjectPointer.cast(currPinningArrayCursor.at(0L));
                StackWalkerUtils.swPrintf(walkState, 6, "Before object slot walk &address : {0} address : {1} bp {2} offset of first internal ptr {3}", StackWalkerUtils.formatPointer(currPinningArrayCursor), StackWalkerUtils.formatPointer(oldPinningArrayAddress), StackWalkerUtils.formatPointer(walkState.bp), offsetOfFirstInternalPtr);
                walkState.callBacks.objectSlotWalkFunction(walkState.walkThread, walkState, currPinningArrayCursor);
                ++walkState.slotIndex;
                StackWalkerUtils.swPrintf(walkState, 6, "For pinning array {0} num internal pointer stack slots {1}", currPinningArrayIndex, numInternalPtrsForArray);
                tempJitDescriptionCursor = tempJitDescriptionCursor.add(numInternalPtrsForArray);
                i = i.add(1);
            }
        }

        public VoidPointer getStackAllocMapFromJitPC(J9JavaVMPointer javaVM, J9JITExceptionTablePointer methodMetaData, UDATA jitPC, VoidPointer curStackMap) throws CorruptDataException {
            throw new UnsupportedOperationException("getStackAllocMapFromJitPC not implemented at 2.3");
        }

        public U8Pointer getJitStackSlots(J9JITExceptionTablePointer metaData, VoidPointer stackMap) {
            throw new UnsupportedOperationException("getJitStackSlots not implemented at 2.3");
        }

        public void markClassesInInlineRanges(J9JITExceptionTablePointer metaData, WalkState walkState) throws CorruptDataException {
            throw new UnsupportedOperationException("markClassesInInlineRanges not implemented at 2.3");
        }
    }
}

