/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm23.j9.gc.GCIterator;
import com.ibm.j9ddr.vm23.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm23.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9VMThreadPointer;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GCVMThreadSlotIterator
extends GCIterator {
    protected Iterator<J9ObjectPointer> iterator;

    protected void addSlot(ArrayList<J9ObjectPointer> slots, J9ObjectPointer slot, boolean include) {
        if (include && slot.notNull()) {
            slots.add(slot);
        }
    }

    protected GCVMThreadSlotIterator(J9VMThreadPointer vmThread) throws CorruptDataException {
        ArrayList<J9ObjectPointer> slots = new ArrayList<J9ObjectPointer>();
        this.addSlot(slots, J9ObjectPointer.cast(vmThread.jitException()), J9BuildFlags.interp_nativeSupport);
        this.addSlot(slots, vmThread.currentException(), true);
        this.addSlot(slots, vmThread.threadObject(), true);
        this.addSlot(slots, vmThread.allocateObjectSave1(), true);
        this.addSlot(slots, vmThread.allocateObjectSave2(), true);
        this.addSlot(slots, vmThread.allocateObjectSave3(), true);
        this.addSlot(slots, vmThread.allocateObjectSave4(), true);
        this.addSlot(slots, vmThread.allocateObjectSavePrivate1(), true);
        this.addSlot(slots, vmThread.stopThrowable(), J9BuildFlags.opt_deprecatedMethods);
        this.addSlot(slots, vmThread.outOfMemoryError(), true);
        if (AlgorithmVersion.getVersionOf("ALG_GC_THREAD_SLOT_ITERATOR_VERSION").getAlgorithmVersion() == 1) {
            if (J9BuildFlags.opt_realTimeLockingSupport) {
                this.addSlot(slots, vmThread.blockingEnterObject(), true);
            }
        } else {
            this.addSlot(slots, vmThread.blockingEnterObject(), true);
        }
        this.iterator = slots.iterator();
    }

    public static GCVMThreadSlotIterator fromJ9VMThread(J9VMThreadPointer vmThread) throws CorruptDataException {
        return new GCVMThreadSlotIterator(vmThread);
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public J9ObjectPointer next() {
        return this.iterator.next();
    }
}

