/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.events.EventManager;
import com.ibm.j9ddr.vm23.j9.gc.GCIterator;
import com.ibm.j9ddr.vm23.pointer.U8Pointer;
import com.ibm.j9ddr.vm23.pointer.UDATAPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9MemorySegmentPointer;
import com.ibm.j9ddr.vm23.structure.J9Object;
import java.util.NoSuchElementException;

public class GCClassHeapIterator
extends GCIterator {
    private boolean isJIT;
    private J9MemorySegmentPointer memorySegment;
    private U8Pointer scanPointer;

    protected GCClassHeapIterator(J9JavaVMPointer vm, J9MemorySegmentPointer memorySegment) throws CorruptDataException {
        this.isJIT = vm.jitConfig().notNull();
        this.memorySegment = memorySegment;
        this.scanPointer = memorySegment.heapBase();
    }

    public static GCClassHeapIterator fromJ9MemorySegment(J9JavaVMPointer vm, J9MemorySegmentPointer memorySegment) throws CorruptDataException {
        return new GCClassHeapIterator(vm, memorySegment);
    }

    public boolean hasNext() {
        try {
            return this.scanPointer.lt(this.memorySegment.heapAlloc());
        }
        catch (CorruptDataException cde) {
            EventManager.raiseCorruptDataEvent("Error determining location within heap", cde, true);
            return false;
        }
    }

    public J9ClassPointer next() {
        try {
            if (this.hasNext()) {
                if (this.isJIT) {
                    this.scanPointer = this.scanPointer.add(UDATAPointer.cast(this.scanPointer).at(0L));
                }
                J9ClassPointer clazz = J9ClassPointer.cast(this.scanPointer);
                this.scanPointer = this.scanPointer.add(clazz.size());
                this.scanPointer = this.scanPointer.add(J9Object.SIZEOF);
                return clazz;
            }
            throw new NoSuchElementException("There are no more items available through this iterator");
        }
        catch (CorruptDataException cde) {
            EventManager.raiseCorruptDataEvent("Could not set the current class", cde, false);
            return null;
        }
    }
}

