/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IteratorHelpers {
    public static <T> Iterator<T> combineIterators(final Iterator<T> ... iterators) {
        return new Iterator<T>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                while (this.index < iterators.length) {
                    if (iterators[this.index].hasNext()) {
                        return true;
                    }
                    ++this.index;
                }
                return false;
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    return iterators[this.index].next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> List<T> toList(Iterator<T> it) {
        ArrayList<T> list = new ArrayList<T>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public static <T> Iterator<T> filterIterator(final Iterator<T> it, final IteratorFilter<T> filter) {
        return new Iterator<T>(){
            private T current;

            @Override
            public boolean hasNext() {
                if (this.current != null) {
                    return true;
                }
                while (this.current == null && it.hasNext()) {
                    Object possible = it.next();
                    if (!filter.accept(possible)) continue;
                    this.current = possible;
                    return true;
                }
                return false;
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    Object toReturn = this.current;
                    this.current = null;
                    return toReturn;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IteratorFilter<T> {
        public boolean accept(T var1);
    }
}

