/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.xml;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImageFactory;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaField;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.j9ddr.tools.xml.XMLComparisonUnitTest;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Logger;

public abstract class DTFJTest
extends XMLComparisonUnitTest {
    private static Logger log = Logger.getLogger("j9ddr.view.dtfj");
    private int indent = 0;
    private FileWriter out = null;

    public File parseCoreFilePath(String path) {
        File core = new File(path);
        if (core.exists()) {
            return core;
        }
        throw new IllegalArgumentException("The path specified to the core file " + path + " is not valid");
    }

    public abstract ImageFactory getImageFactory();

    public JavaRuntime getRuntime(File core) throws Exception {
        ImageFactory factory = this.getImageFactory();
        Image image = factory.getImage(core);
        log.finest("Image returned: " + image);
        Iterator addressSpaceIt = image.getAddressSpaces();
        while (addressSpaceIt.hasNext()) {
            Object asObj = addressSpaceIt.next();
            if (asObj instanceof CorruptData) {
                log.warning("Corrupt AddressSpace returned: " + asObj);
                continue;
            }
            if (asObj instanceof ImageAddressSpace) {
                ImageAddressSpace as = (ImageAddressSpace)asObj;
                log.finest("Address Space: " + as + " found");
                Iterator processIterator = as.getProcesses();
                while (processIterator.hasNext()) {
                    Object processObj = processIterator.next();
                    if (processObj instanceof CorruptData) {
                        log.warning("Corrupt ImageProcess returned: " + asObj);
                        continue;
                    }
                    if (processObj instanceof ImageProcess) {
                        ImageProcess process = (ImageProcess)processObj;
                        log.finest("ImageProcess: " + process + " found");
                        Iterator runtimeIterator = process.getRuntimes();
                        while (runtimeIterator.hasNext()) {
                            Object runtimeObj = runtimeIterator.next();
                            if (runtimeObj instanceof CorruptData) {
                                log.warning("Corrupt ImageProcess returned: " + asObj);
                                continue;
                            }
                            if (runtimeObj instanceof JavaRuntime) {
                                JavaRuntime runtime = (JavaRuntime)runtimeObj;
                                log.finer("JavaRuntime found: " + runtime + ", was loaded by " + runtime.getClass().getClassLoader());
                                return runtime;
                            }
                            throw new ClassCastException("Unexpected type from Runtime iterator: " + runtimeObj.getClass() + ": " + runtimeObj);
                        }
                        continue;
                    }
                    throw new ClassCastException("Unexpected type from Process iterator: " + processObj.getClass() + ": " + processObj);
                }
                continue;
            }
            throw new ClassCastException("Unexpected type from AddressSpace iterator: " + asObj.getClass() + ": " + asObj);
        }
        throw new RuntimeException("Could not find a Java Runtime");
    }

    protected void writeIndent() throws Exception {
        for (int i = 0; i < this.indent; ++i) {
            this.out.write("\t");
        }
    }

    protected void createWriter(File path) throws IOException {
        this.out = new FileWriter(path);
    }

    protected void startTag(String data) throws Exception {
        ++this.indent;
        this.writeIndent();
        this.out.write(data);
    }

    protected void endTag(String data) throws Exception {
        this.writeIndent();
        this.out.write(data);
        --this.indent;
    }

    protected void tag(String data) throws Exception {
        ++this.indent;
        this.writeIndent();
        this.out.write(data);
        --this.indent;
    }

    protected void write(String data) throws Exception {
        this.out.write(data);
    }

    protected void closeWriter() throws Exception {
        this.out.close();
    }

    protected void writeObject(JavaObject obj, long index) throws Exception {
        this.startTag("<object");
        this.write(" index=\"" + index + "\"");
        this.write(" address=\"0x" + Long.toHexString(obj.getID().getAddress()) + "\"");
        this.write(" size=\"0x" + Long.toHexString(obj.getSize()) + "\"");
        this.write(">\n");
        this.writeClass(obj.getJavaClass());
        this.tag("<toString>" + obj.toString() + "</toString>\n");
        this.tag("<persistentHashCode>" + obj.getPersistentHashcode() + "</persistentHashCode>\n");
        if (obj.isArray()) {
            this.tag("<array elementCount=\"0x" + Long.toHexString(obj.getArraySize()) + "\" />\n");
        }
        Iterator sections = obj.getSections();
        while (sections.hasNext()) {
            ImageSection section = (ImageSection)sections.next();
            this.writeSection(section);
        }
        this.endTag("</object>\n");
    }

    protected void writeClass(JavaClass clazz) throws Exception {
        this.startTag("<class name=\"" + clazz.getName() + "\">\n");
        if (clazz.getSuperclass() == null) {
            this.tag("<super>null</super>\n");
        } else {
            this.startTag("<super>\n");
            this.writeClass(clazz.getSuperclass());
            this.endTag("</super>\n");
        }
        this.startTag("<fields>\n");
        Iterator i = clazz.getDeclaredFields();
        while (i.hasNext()) {
            this.writeField((JavaField)i.next());
        }
        this.endTag("</fields>\n");
        this.endTag("</class>\n");
    }

    protected void writeField(JavaField field) throws Exception {
        this.tag("<field name=\"" + this.getSafeString(field.getName()) + "\" signature=\"" + field.getSignature() + "\" />\n");
    }

    private String getSafeString(String data) {
        String result = data.replace('<', '-');
        return result.replace('<', '-');
    }

    protected void writeSection(ImageSection section) throws Exception {
        this.startTag("<section address=\"0x" + section.getBaseAddress().toString() + "\"");
        this.write(" size=\"0x" + Long.toHexString(section.getSize()) + "\"");
        this.write(" name=\"" + section.getName());
        this.endTag("\" />\n");
    }
}

