/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive.commands;

import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import java.io.PrintStream;

public class SnapFormatWrapperCommand
extends Command {
    public SnapFormatWrapperCommand() {
        this.addCommand("snapformat", "[<filename>]", "format trace buffers to a specified file or stdout");
        this.addCommand("snapformat", "-help", "print detailed help");
        this.addCommand("snapformat", "[-f <filename>] [-d <datfile_directory>] [-t <j9vmthread id>] [-s <filter>]", "format trace buffers for all threads or just the specified thread to a file or stdout using the specified .dat files");
    }

    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        if (args.length > 0 && (args[0].equals("-help") || args[0].equals("-h") || args[0].equals("-?"))) {
            out.println("Format selected trace buffers.");
            out.println();
            out.println("   -f <filename>            Write output to the specified file (default is stdout)");
            out.println();
            out.println("   -d <datfile_directory>   Set the directory to search for the trace format database");
            out.println();
            out.println("   -t <thread_id>           Only output trace information for the specified J9VMThread");
            out.println();
            out.println("   -s <filter>              Only output tracepoints that match the filter expression.");
            out.println("                            A filter expression consists of one or more tracepoint IDs");
            out.println("                            combined with AND, OR, and NOT operators (&, |, !).");
            out.println("      Examples:");
            out.println("         -s j9vm                            Print all tracepoints in component 'j9vm'");
            out.println("         -s j9vm|j9mm                       Print all tracepoints in components 'j9vm' and 'j9mm'");
            out.println("         -s {entry}                         Only print 'Entry' tracepoints");
            out.println("         -s j9vm.0-99                       Only print 'j9vm' tracepoints with IDs below 100");
            out.println("         -s j9scar&!(j9scar.59|j9scar.60)   Print j9scar tracepoints except for 59 and 60");
            return;
        }
        try {
            Class<?> snapFormatCommandCls = Class.forName("com.ibm.j9ddr.tools.ddrinteractive.commands.SnapFormatCommand");
            Object snapFormatCommandInstance = snapFormatCommandCls.newInstance();
            if (!(snapFormatCommandInstance instanceof Command)) {
                throw new DDRInteractiveCommandException("Unable to format trace. Could not create formatter.");
            }
            Command c = (Command)snapFormatCommandInstance;
            c.run(command, args, context, out);
        }
        catch (ClassNotFoundException e) {
            throw new DDRInteractiveCommandException("Unable to format trace. " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new DDRInteractiveCommandException("Unable to format trace. " + e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new DDRInteractiveCommandException("Unable to format trace. " + e.getMessage(), e);
        }
        catch (SecurityException e) {
            throw new DDRInteractiveCommandException("Unable to format trace. " + e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new DDRInteractiveCommandException("Unable to format trace. " + e.getMessage(), e);
        }
    }
}

