/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive.commands;

import com.ibm.dtfj.image.ImageModule;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.corereaders.ILibraryDependentCore;
import com.ibm.j9ddr.corereaders.memory.IModule;
import com.ibm.j9ddr.libraries.CoreFileResolver;
import com.ibm.j9ddr.libraries.FooterLibraryEntry;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractive;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.tools.ddrinteractive.annotations.DebugExtension;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageProcess;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;

@DebugExtension(VMVersion="*", contentAssist="dclibs")
public class NativeLibrariesCommand
extends Command {
    protected String hexformat = null;

    public NativeLibrariesCommand() {
        this.addCommand("dclibs", "", "List the native libraries collected by DC");
        this.addCommand("dclibs", "extract", "Extract collected libraries into the same directory as the core file");
        this.addCommand("dclibs", "extract overwrite", "as !libs extract, but overwrite any existing files");
        this.addCommand("dclibs", "extract <full path to dir>", "Extract the collected libraries into the specified directory");
    }

    public void run(String cmd, String[] args, Context ctx, PrintStream out) throws DDRInteractiveCommandException {
        this.hexformat = "0x%0" + ctx.process.bytesPerPointer() * 2 + "x";
        if (DDRInteractive.getPath() == null || DDRInteractive.getPath().length() == 0) {
            out.println("DDR Interactive was not invoked with a command line pointing to a core file. Aborting command");
            return;
        }
        if (args.length == 0) {
            this.showLibList(ctx, out);
            return;
        }
        if (args.length >= 1) {
            boolean overwrite = false;
            if (args[0].toLowerCase().equals("extract")) {
                File extractTo = null;
                if (args.length == 2) {
                    if (args[1].equalsIgnoreCase("overwrite")) {
                        overwrite = true;
                    } else {
                        extractTo = new File(args[1]);
                        if (!extractTo.exists()) {
                            out.println("The specified extraction directory does not exist. " + extractTo.getAbsolutePath());
                            return;
                        }
                    }
                }
                this.extractLibs(ctx, out, extractTo, overwrite);
                return;
            }
        }
        out.println("Command not recognised");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void extractLibs(Context ctx, PrintStream out, File path, boolean overwrite) {
        if (path == null) {
            boolean useCurrentDir;
            boolean bl = useCurrentDir = !DDRInteractive.getPath().contains(File.separator);
            if (useCurrentDir) {
                String curdir = System.getProperty("user.dir");
                path = new File(curdir);
            } else {
                path = new File(DDRInteractive.getPath());
                if (path.isFile()) {
                    path = path.getParentFile();
                }
            }
        }
        out.println("Extracting libraries to : " + path.getAbsolutePath());
        LibReader reader = new LibReader();
        try {
            for (FooterLibraryEntry entry : reader.getEntries()) {
                File library;
                if (entry == null) continue;
                String dir = entry.getPath();
                if (dir.charAt(0) == '/') {
                    dir = dir.substring(1);
                }
                if (File.separatorChar == '\\' && dir.contains("/")) {
                    dir.replace('/', '\\');
                }
                if ((library = new File(path, dir).getCanonicalFile()).isFile()) {
                    if (library.getParentFile() != null) {
                        library.getParentFile().mkdirs();
                    }
                    if (library.exists()) {
                        if (overwrite) {
                            out.println("Deleting existing library");
                            library.delete();
                        } else {
                            out.println("Library " + library.getPath() + " already exists on disk so skipping (to overwrite run !dclibs extract overwrite)");
                            continue;
                        }
                    }
                } else if (!library.getParentFile().equals(path)) {
                    library.getParentFile().mkdirs();
                }
                out.println("Extracting " + library);
                reader.extractLibrary(entry.getPath(), library);
            }
            return;
        }
        catch (IOException e) {
            out.println("Error extracting libraries : " + e.getMessage());
        }
    }

    private void getExeFromDDR(Context ctx, PrintStream out) {
        try {
            ICore core = ctx.process.getAddressSpace().getCore();
            if (ILibraryDependentCore.class.isAssignableFrom(core.getClass())) {
                ILibraryDependentCore ldcore = (ILibraryDependentCore)core;
                J9DDRImageProcess proc = new J9DDRImageProcess(ctx.process);
                ImageModule exe = proc.getExecutable();
                out.println("exe = " + exe.getName());
                ldcore.executablePathHint(exe.getName());
            }
        }
        catch (Exception e) {
            out.println("Could not determine EXE name using DDR : " + e.getMessage());
        }
    }

    private void showLibList(Context ctx, PrintStream out) {
        LibReader reader = new LibReader();
        out.println("Showing library list for " + DDRInteractive.getPath());
        Collection<? extends IModule> libs = null;
        try {
            libs = ctx.process.getModules();
        }
        catch (CorruptDataException e) {
            out.println("Corrupt data exception when retrieving list of libraries : " + e.getMessage());
            return;
        }
        this.getExeFromDDR(ctx, out);
        for (IModule iModule : libs) {
            try {
                out.println("Lib : " + iModule.getName());
                FooterLibraryEntry entry = reader.getEntry(iModule.getName());
                if (entry == null) {
                    out.println("\tLibrary is not appended to the core file, it may be present on the local disk");
                    continue;
                }
                out.println("\tLibrary has been collected");
                out.println("\tPath : " + entry.getPath());
                out.println("\tName : " + entry.getName());
                out.println("\tSize : " + entry.getSize());
            }
            catch (CorruptDataException e) {
                out.println("Library name is corrupt");
            }
        }
    }

    private class LibReader
    extends CoreFileResolver {
        public LibReader() {
            super(DDRInteractive.getPath());
        }

        public FooterLibraryEntry getEntry(String path) {
            if (this.footer == null) {
                return null;
            }
            return this.footer.findEntry(path);
        }

        public FooterLibraryEntry[] getEntries() {
            return this.footer.getEntries();
        }
    }
}

