/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive.commands;

import com.ibm.j9ddr.command.CommandParser;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import java.io.PrintStream;
import java.text.ParseException;

public class LimitCommand
extends Command {
    public LimitCommand() {
        this.addCommand("limit", "<timeout> <command> [<args>]", "run another command; terminate if it exceeds the timeout");
    }

    public void run(String command, final String[] args, final Context context, final PrintStream out) throws DDRInteractiveCommandException {
        String[] newArgs;
        if (args.length < 2) {
            out.println("The limit command requires a timeout and another command to run as an argument.");
            return;
        }
        long timeout = Integer.parseInt(args[0]) * 1000;
        if (args.length > 2) {
            newArgs = new String[args.length - 2];
            System.arraycopy(args, 2, newArgs, 0, newArgs.length);
        } else {
            newArgs = new String[]{};
        }
        Thread runner = new Thread("LimitCommand: " + args[1]){

            public void run() {
                try {
                    CommandParser commandParser = new CommandParser(args[1], newArgs);
                    context.execute(commandParser, out);
                }
                catch (ParseException e) {
                    e.printStackTrace(out);
                }
            }
        };
        runner.start();
        try {
            runner.join(timeout);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (runner.isAlive()) {
            runner.stop(new DDRInteractiveCommandException("Timeout exceeded!"));
        }
    }
}

