/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ant;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PrefixJUnitResults
extends Task {
    private String prefix = null;
    private File outputDirectory = null;
    private List<FileSet> fileSets = new LinkedList<FileSet>();
    private boolean verbose = false;

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setOutputDir(File outputDir) {
        this.outputDirectory = outputDir;
    }

    public void addFileset(FileSet fileset) {
        this.fileSets.add(fileset);
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void execute() throws BuildException {
        if (this.fileSets.size() == 0) {
            throw new BuildException("No filesets supplied.");
        }
        if (this.prefix == null) {
            throw new BuildException("prefix not specified");
        }
        int count = 0;
        for (FileSet thisFileSet : this.fileSets) {
            DirectoryScanner scanner = thisFileSet.getDirectoryScanner(this.getProject());
            String[] files = scanner.getIncludedFiles();
            if (files.length == 0) {
                this.log("Empty fileset supplied");
            }
            for (String fileName : files) {
                File thisFile = new File(scanner.getBasedir(), fileName);
                try {
                    if (!thisFile.exists()) {
                        this.log("Ignoring " + thisFile.getCanonicalPath() + ", because it doesn't exist");
                        continue;
                    }
                    this.process(thisFile);
                    ++count;
                }
                catch (IOException ex) {
                    throw new BuildException((Throwable)ex);
                }
                catch (SAXException e) {
                    throw new BuildException((Throwable)e);
                }
            }
        }
        this.log("Processed " + count + " XML files");
    }

    private void process(File xmlFile) throws IOException, SAXException {
        File outputFile = this.getOutputFile(xmlFile);
        if (this.verbose) {
            this.log("Mapping " + xmlFile.getAbsolutePath() + " to " + outputFile.getAbsolutePath());
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        Document doc = builder.parse(new InputSource(new FileReader(xmlFile)));
        NodeList testSuiteNodes = doc.getElementsByTagName("testsuite");
        if (testSuiteNodes.getLength() == 0) {
            this.log("Couldn't find testsuite node in " + xmlFile.getAbsolutePath());
        }
        for (int i = 0; i < testSuiteNodes.getLength(); ++i) {
            Node thisTestSuite = testSuiteNodes.item(i);
            NamedNodeMap attributes = thisTestSuite.getAttributes();
            Attr nameNode = (Attr)attributes.getNamedItem("name");
            if (null == nameNode) {
                this.log("Couldn't find name attribute on testsuite element in " + xmlFile.getAbsolutePath());
                continue;
            }
            String oldValue = nameNode.getValue();
            nameNode.setValue(this.prefix + "." + oldValue);
        }
        NodeList testCaseNodes = doc.getElementsByTagName("testcase");
        for (int i = 0; i < testCaseNodes.getLength(); ++i) {
            Node thisTestCase = testCaseNodes.item(i);
            NamedNodeMap attributes = thisTestCase.getAttributes();
            Attr classNameNode = (Attr)attributes.getNamedItem("classname");
            if (null == classNameNode) {
                this.log("Couldn't find classname attribute on testcase element in " + xmlFile.getAbsolutePath());
                continue;
            }
            String oldValue = classNameNode.getValue();
            classNameNode.setValue(this.prefix + "." + oldValue);
        }
        DOMImplementationLS ls = (DOMImplementationLS)((Object)builder.getDOMImplementation());
        LSSerializer serializer = ls.createLSSerializer();
        LSOutput xmlSink = ls.createLSOutput();
        xmlSink.setCharacterStream(new FileWriter(outputFile));
        serializer.write(doc, xmlSink);
    }

    private File getOutputFile(File inputFile) {
        String fileName = inputFile.getName();
        fileName = fileName.startsWith("TEST-") ? "TEST-" + this.prefix + "." + fileName.substring(5) : this.prefix + "." + fileName;
        File outputFile = new File(this.outputDirectory, fileName);
        return outputFile;
    }
}

