/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.Image;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageFactory;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DTFJWalker {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final Stack<String> path = new Stack();
    private final ArrayList<InvocationResult> results = new ArrayList();

    public static void main(String[] args) {
        DTFJWalker walker = new DTFJWalker();
        if (args.length != 1) {
            DTFJWalker.printHelp();
            System.exit(1);
        }
        walker.walkCoreFile(args[0]);
    }

    private static void printHelp() {
        System.out.println("Usage :\n\njava com.ibm.j9ddr.tools.DTFJWalker <core file>\n");
        System.out.println("<core file>       : the path and file name of the core file");
    }

    public void walkCoreFile(String path) {
        File file = new File(path);
        this.walkCoreFile(file);
    }

    public void walkCoreFile(File file) {
        J9DDRImageFactory factory = new J9DDRImageFactory();
        Image image = null;
        try {
            image = factory.getImage(file);
        }
        catch (IOException e) {
            System.err.println("Failed to create an Image from the core file : " + e.getMessage());
            this.logger.log(Level.WARNING, "Failed to create Image from core file", e);
            return;
        }
        try {
            Method iterator = image.getClass().getDeclaredMethod("getAddressSpaces", null);
            this.iterate(image, iterator, 100);
        }
        catch (Exception e) {
            System.err.println("Failed to get address space iterator method : " + e.getMessage());
            this.logger.log(Level.WARNING, "Failed to get address space iterator method", e);
            return;
        }
        System.out.println("Walk complete");
        this.showResults();
    }

    private void showResults() {
        for (InvocationResult result : this.results) {
            System.out.println(result.toString());
        }
    }

    private void iterate(Object object, Method iterator, int maxItems) {
        this.path.push(this.getNameFromMethod(iterator));
        iterator.setAccessible(true);
        try {
            Object result = iterator.invoke(object, (Object[])null);
            if (result instanceof Iterator) {
                Iterator list = (Iterator)result;
                for (int count = 0; list.hasNext() && count < maxItems; ++count) {
                    Method[] methods;
                    Object data = list.next();
                    if (data instanceof CorruptData) {
                        this.results.add(new InvocationResult(this.getCurrentPath(), (CorruptData)data));
                        continue;
                    }
                    for (Method method : methods = data.getClass().getMethods()) {
                        if (!method.getReturnType().getSimpleName().equals("Iterator")) continue;
                        this.path.push("[" + count + "]/");
                        this.iterate(data, method, maxItems);
                        this.path.pop();
                    }
                }
            }
            if (result instanceof CorruptData) {
                this.results.add(new InvocationResult(this.getCurrentPath(), (CorruptData)result));
            }
        }
        catch (Exception e) {
            System.err.println("Exception thrown by iterator : " + e.getMessage());
            this.logger.log(Level.WARNING, "Exception thrown by iterator", e);
            this.results.add(new InvocationResult(this.getCurrentPath(), e.getCause()));
        }
        this.path.pop();
    }

    private String getCurrentPath() {
        Iterator elements = this.path.iterator();
        StringBuilder builder = new StringBuilder();
        while (elements.hasNext()) {
            builder.append((String)elements.next());
        }
        return builder.toString();
    }

    private String getNameFromMethod(Method method) {
        String name = method.getName();
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) >= 'a') continue;
            return name.substring(i);
        }
        return name;
    }

    private class InvocationResult {
        private final String path;
        private final CorruptData corruptData;
        private final Throwable exception;

        InvocationResult(String path, CorruptData corruptData, Throwable exception) {
            this.path = path;
            this.corruptData = corruptData;
            this.exception = exception;
        }

        InvocationResult(String path, CorruptData corruptData) {
            this.path = path;
            this.corruptData = corruptData;
            this.exception = null;
        }

        InvocationResult(String path, Throwable exception) {
            this.path = path;
            this.corruptData = null;
            this.exception = exception;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.path);
            builder.append(" = ");
            if (null != this.corruptData) {
                builder.append(this.corruptData.toString());
            }
            if (null != this.exception) {
                builder.append(this.exception.getClass().getName());
                builder.append("[");
                builder.append(this.exception.getMessage());
                builder.append("] ");
            }
            return builder.toString();
        }
    }
}

