/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class BasicFormatter
extends Formatter {
    public String format(LogRecord record) {
        MessageFormat format = new MessageFormat(record.getMessage());
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        String sourceName = record.getSourceClassName();
        String methodName = record.getSourceMethodName();
        if (sourceName != null && methodName != null) {
            pw.print(sourceName);
            pw.print(".");
            pw.print(methodName);
            pw.print(": ");
        } else if (sourceName != null) {
            pw.print(sourceName);
            pw.print(": ");
        } else if (methodName != null) {
            pw.print(methodName);
            pw.print(": ");
        }
        format.format(record.getParameters(), writer.getBuffer(), (FieldPosition)null);
        Throwable thrown = record.getThrown();
        if (thrown != null) {
            pw.println(". Throwable stack:");
            thrown.printStackTrace(pw);
        }
        pw.println();
        pw.flush();
        return writer.toString();
    }
}

