/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.libraries;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class MonitoredFileOutputStream
extends FileOutputStream {
    private int bytesWritten = 0;

    public MonitoredFileOutputStream(File file, boolean append) throws FileNotFoundException {
        super(file, append);
    }

    public MonitoredFileOutputStream(File file) throws FileNotFoundException {
        super(file);
    }

    public MonitoredFileOutputStream(FileDescriptor fdObj) {
        super(fdObj);
    }

    public MonitoredFileOutputStream(String name, boolean append) throws FileNotFoundException {
        super(name, append);
    }

    public MonitoredFileOutputStream(String name) throws FileNotFoundException {
        super(name);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.bytesWritten += len;
        super.write(b, off, len);
    }

    public void write(byte[] b) throws IOException {
        this.bytesWritten += b.length;
        super.write(b);
    }

    public void write(int b) throws IOException {
        ++this.bytesWritten;
        super.write(b);
    }

    public int getBytesWritten() {
        return this.bytesWritten;
    }

    public byte[] getBytesWrittenAsArray() {
        byte[] data = new byte[4];
        for (int i = 0; i < data.length; ++i) {
            int shift = (3 - i) * 8;
            data[i] = (byte)((this.bytesWritten & 255 << shift) >> shift);
        }
        return data;
    }
}

