/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.libraries;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImageModule;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.j9ddr.corereaders.CoreReader;
import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.corereaders.ILibraryDependentCore;
import com.ibm.j9ddr.libraries.LibraryAdapter;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DDRLibraryAdapter
implements LibraryAdapter {
    private static final Logger logger = Logger.getLogger("com.ibm.j9ddr.libraries");
    private ArrayList<String> moduleNames = null;
    private final ArrayList<String> errorMessages = new ArrayList();

    @Override
    public ArrayList<String> getErrorMessages() {
        return this.errorMessages;
    }

    @Override
    public ArrayList<String> getLibraryList(File coreFile) {
        if (this.moduleNames == null) {
            this.constructLibraryList(coreFile);
        }
        return this.moduleNames;
    }

    @Override
    public boolean isLibraryCollectionRequired(File coreFile) {
        ICore reader = this.getReader(coreFile.getPath());
        return reader instanceof ILibraryDependentCore;
    }

    private ICore getReader(String path) {
        ICore reader;
        try {
            reader = CoreReader.readCoreFile(path);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Could not open core file", e);
            this.errorMessages.add(e.getMessage());
            return null;
        }
        return reader;
    }

    private void constructLibraryList(File coreFile) {
        boolean isAIX;
        Image image;
        this.moduleNames = new ArrayList();
        J9DDRImageFactory factory = new J9DDRImageFactory();
        try {
            image = factory.getImage(coreFile);
            isAIX = image.getSystemType().toLowerCase().startsWith("aix");
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Could not open core file", e);
            this.errorMessages.add(e.getMessage());
            return;
        }
        catch (CorruptDataException e) {
            logger.log(Level.SEVERE, "Could not determine system type", e);
            this.errorMessages.add(e.getMessage());
            return;
        }
        catch (DataUnavailable e) {
            logger.log(Level.SEVERE, "Could not determine system type", e);
            this.errorMessages.add(e.getMessage());
            return;
        }
        Iterator spaces = image.getAddressSpaces();
        while (spaces.hasNext()) {
            ImageAddressSpace space = (ImageAddressSpace)spaces.next();
            Iterator procs = space.getProcesses();
            while (procs.hasNext()) {
                ImageProcess proc = (ImageProcess)procs.next();
                try {
                    ImageModule exe = proc.getExecutable();
                    this.moduleNames.add(exe.getName());
                    Iterator libraries = proc.getLibraries();
                    while (libraries.hasNext()) {
                        ImageModule module = (ImageModule)libraries.next();
                        String key = null;
                        try {
                            if (isAIX) {
                                key = module.getName();
                                int pos = key.indexOf(".a(");
                                if (pos != -1 && key.lastIndexOf(41) == key.length() - 1) {
                                    key = key.substring(0, pos + 2);
                                }
                            } else {
                                key = module.getName();
                            }
                            logger.fine("Module : " + key);
                            if (this.moduleNames.contains(key)) continue;
                            this.moduleNames.add(key);
                        }
                        catch (Exception e) {
                            logger.log(Level.WARNING, "Error getting module name", e);
                        }
                    }
                }
                catch (DataUnavailable e) {
                    logger.log(Level.WARNING, "Error getting library list", e);
                    this.errorMessages.add(e.getMessage());
                }
                catch (CorruptDataException e) {
                    logger.log(Level.WARNING, "Error getting library list", e);
                    this.errorMessages.add(e.getMessage());
                }
            }
        }
    }
}

