/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.util;

import java.io.Serializable;
import java.util.Random;

public final class BitStream
implements Serializable {
    private int[] bits;
    private int index;
    private int bitOffset;
    private boolean writing = true;
    private int currentWord;
    private static final int[] log2bytes = new int[]{-1, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    static final int[] nextUnsetBit = new int[256];

    public BitStream() {
        this(25);
    }

    public BitStream(int numInts) {
        this.bits = new int[numInts];
    }

    public void rewind() {
        this.index = 0;
        this.bitOffset = 0;
        this.writing = false;
        this.currentWord = this.bits[this.index];
    }

    public void reset() {
        this.rewind();
        this.bits[0] = 0;
        this.writing = true;
    }

    private void writeIntInWord(int n, int len) {
        assert (len > 0) : len;
        if (len < 32) {
            n &= (1 << len) - 1;
        }
        int b = this.bits[this.index];
        this.bits[this.index] = b |= n << 32 - (this.bitOffset + len);
        this.bitOffset += len;
    }

    public void writeLongBits(long n, int len) {
        assert (len < 64) : len;
        this.writeIntBits((int)(n >> 32), len - 32);
        this.writeIntBits((int)n, 32);
    }

    public void writeIntBits(int n, int len) {
        assert (len > 0 && len <= 32) : len;
        if (len < 32 - this.bitOffset) {
            this.writeIntInWord(n, len);
        } else {
            int firstlen = 32 - this.bitOffset;
            int secondlen = len + this.bitOffset - 32;
            if (firstlen > 0) {
                this.writeIntInWord(n >>> secondlen, firstlen);
            }
            if (secondlen > 0) {
                this.nextWord();
                this.bits[this.index] = 0;
                this.writeIntInWord(n, secondlen);
            }
        }
    }

    public void nextWord() {
        ++this.index;
        if (this.index >= this.bits.length) {
            int[] tmp = new int[this.bits.length * 2];
            System.arraycopy(this.bits, 0, tmp, 0, this.bits.length);
            this.bits = tmp;
        } else if (this.writing) {
            this.bits[this.index] = 0;
        }
        this.currentWord = this.bits[this.index];
        this.bitOffset = 0;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        assert (!this.writing);
        this.index = index;
        this.currentWord = this.bits[index];
        this.bitOffset = 0;
    }

    private int readIntInWord(int len) {
        int n = this.currentWord >> 32 - (this.bitOffset + len);
        if (len < 32) {
            n &= (1 << len) - 1;
        }
        this.bitOffset += len;
        return n;
    }

    public int readIntBits(int len) {
        assert (len > 0 && len <= 32) : len;
        if (len < 32 - this.bitOffset) {
            return this.readIntInWord(len);
        }
        int firstlen = 32 - this.bitOffset;
        int secondlen = len + this.bitOffset - 32;
        int first = 0;
        if (firstlen > 0) {
            first = this.readIntInWord(firstlen);
        }
        int second = 0;
        if (secondlen > 0) {
            this.nextWord();
            second = this.readIntInWord(secondlen);
        }
        return first << secondlen | second;
    }

    public long readLongBits(int len) {
        assert (len < 64) : len;
        if (len <= 32) {
            return this.readIntBits(len);
        }
        long upper = this.readIntBits(len - 32);
        assert (upper >= 0L) : upper;
        long lower = this.readIntBits(32);
        return upper << 32 | lower & 0xFFFFFFFFL;
    }

    public static int log2(int n) {
        int bit = 0;
        while ((n & 0xFFFFFF00) != 0) {
            bit += 8;
            n >>>= 8;
        }
        return bit + log2bytes[n];
    }

    public int writeDelta(int n) {
        int msb = BitStream.log2(++n);
        int r = this.writeGamma(msb);
        if (msb != 0) {
            this.writeIntBits(n, msb);
        }
        return r + msb;
    }

    public int writeGamma(int n) {
        int msb = BitStream.log2(++n);
        int r = this.writeUnary(msb);
        if (msb != 0) {
            this.writeIntBits(n, msb);
        }
        return r + msb;
    }

    public int writeUnary(int n) {
        for (int i = 0; i < n; ++i) {
            this.writeIntBits(1, 1);
        }
        this.writeIntBits(0, 1);
        return n + 1;
    }

    public int readDelta() {
        int msb = this.readGamma();
        return msb == 0 ? 0 : (1 << msb | this.readIntBits(msb)) - 1;
    }

    public int readGamma() {
        int msb = this.readUnary();
        return msb == 0 ? 0 : (1 << msb | this.readIntBits(msb)) - 1;
    }

    public int readUnary() {
        int word = this.currentWord;
        int offset = this.bitOffset;
        int result = 0;
        while (offset <= 24) {
            int b = nextUnsetBit[word >> 24 - offset & 0xFF];
            if (b != -1) {
                this.bitOffset = offset + b + 1;
                return result + b;
            }
            offset += 8;
            result += 8;
        }
        while (true) {
            if (offset == 32) {
                this.nextWord();
                word = this.currentWord;
                offset = 0;
            }
            if ((word & Integer.MIN_VALUE >>> offset) == 0) {
                this.bitOffset = offset + 1;
                return result;
            }
            ++result;
            ++offset;
        }
    }

    public int writeVariableByte(int n) {
        return this.writevb(n, true);
    }

    private int writevb(int n, boolean end) {
        int r = 0;
        if (n >= 128 || n < 0) {
            r += this.writevb(n >>> 7, false);
        }
        n &= 0x7F;
        if (end) {
            n |= 0x80;
        }
        this.writeIntBits(n, 8);
        return r + 8;
    }

    public int readVariableByte() {
        int n = 0;
        while (true) {
            int b = this.readIntBits(8);
            n |= b & 0x7F;
            if ((b & 0x80) != 0) {
                return n;
            }
            n <<= 7;
        }
    }

    public int writeGolombRice(int n, int k) {
        int r = this.writeUnary(n >>> k);
        this.writeIntBits(n, k);
        return r + k;
    }

    public int readGolombRice(int k) {
        int n = this.readUnary() << k;
        return n | this.readIntBits(k);
    }

    public int memoryUsage() {
        return this.bits.length * 4;
    }

    public static void main(String[] args) {
        boolean DELTA = true;
        int GAMMA = 2;
        int FIXED_BITS = 3;
        int VARIABLE_BYTE = 4;
        int GOLOMB = 5;
        int MAX = 5;
        int COUNT = 8000;
        BitStream bs = new BitStream();
        Random rand = new Random(0L);
        if (args.length != 0) {
            for (int i = 0; i < 4000; ++i) {
                System.out.println("" + i + ": gamma " + bs.writeGamma(i) + " delta " + bs.writeDelta(i) + " variable " + bs.writeVariableByte(i) + " g(2) " + bs.writeGolombRice(i, 2) + " g(3) " + bs.writeGolombRice(i, 3) + " g(5) " + bs.writeGolombRice(i, 5) + " g(7) " + bs.writeGolombRice(i, 7) + " g(8) " + bs.writeGolombRice(i, 8));
                bs.reset();
            }
            return;
        }
        for (int i = 0; i < 10; ++i) {
            int j;
            bs.reset();
            int[] trueNumbers = new int[8000];
            byte[] codes = new byte[8000];
            byte[] numBits = new byte[8000];
            block16: for (j = 0; j < 8000; ++j) {
                int n;
                int bits = rand.nextInt(31);
                int max = 1 << bits;
                trueNumbers[j] = n = rand.nextInt();
                codes[j] = (byte)(rand.nextInt(5) + 1);
                switch (codes[j]) {
                    case 1: {
                        System.out.println("doing " + j + " n " + n + " code " + codes[j]);
                        bs.writeDelta(n);
                        continue block16;
                    }
                    case 2: {
                        System.out.println("doing " + j + " n " + n + " code " + codes[j]);
                        bs.writeGamma(n);
                        continue block16;
                    }
                    case 3: {
                        numBits[j] = (byte)(rand.nextInt(32) + 1);
                        bs.writeIntBits(n, numBits[j]);
                        int mask = (int)((1L << numBits[j]) - 1L);
                        int n2 = j;
                        trueNumbers[n2] = trueNumbers[n2] & mask;
                        System.out.println("doing " + j + " n " + n + " code " + codes[j] + " bits " + numBits[j]);
                        continue block16;
                    }
                    case 4: {
                        System.out.println("doing " + j + " n " + n + " code " + codes[j]);
                        bs.writeVariableByte(n);
                        continue block16;
                    }
                    case 5: {
                        numBits[j] = (byte)(rand.nextInt(8) + 15);
                        System.out.println("doing " + j + " n " + n + " code " + codes[j] + " k " + numBits[j]);
                        bs.writeGolombRice(n, numBits[j]);
                    }
                }
            }
            System.out.println("done write for " + i);
            bs.rewind();
            block17: for (j = 0; j < 8000; ++j) {
                int n = trueNumbers[j];
                switch (codes[j]) {
                    case 1: {
                        int k = bs.readDelta();
                        System.out.println("doing " + j + " k " + k + " code " + codes[j]);
                        if (k == n) continue block17;
                        throw new Error("delta: expected " + n + " but got " + k);
                    }
                    case 2: {
                        int k = bs.readGamma();
                        System.out.println("doing " + j + " k " + k + " code " + codes[j]);
                        if (k == n) continue block17;
                        throw new Error("gamma: expected " + n + " but got " + k);
                    }
                    case 3: {
                        int k = bs.readIntBits(numBits[j]);
                        System.out.println("doing " + j + " k " + k + " code " + codes[j] + " bits " + numBits[j]);
                        if (k == n) continue block17;
                        throw new Error("fixed bits: expected " + n + " but got " + k);
                    }
                    case 4: {
                        int k = bs.readVariableByte();
                        System.out.println("doing " + j + " k " + k + " code " + codes[j]);
                        if (k == n) continue block17;
                        throw new Error("variable byte: expected " + n + " but got " + k);
                    }
                    case 5: {
                        int k = bs.readGolombRice(numBits[j]);
                        System.out.println("doing " + j + " k " + k + " code " + codes[j]);
                        if (k == n) continue block17;
                        throw new Error("golomb: expected " + n + " but got " + k);
                    }
                }
            }
            System.out.println("done " + i);
        }
    }

    static {
        block0: for (int i = 0; i < 256; ++i) {
            BitStream.nextUnsetBit[i] = -1;
            for (int j = 0; j < 8; ++j) {
                if ((128 >> j & i) != 0) continue;
                BitStream.nextUnsetBit[i] = j;
                continue block0;
            }
        }
    }
}

