/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader;

import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.AddressSpace;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.stream.ImageInputStreamImpl;

public final class AddressSpaceImageInputStream
extends ImageInputStreamImpl {
    private AddressSpace space;
    private static Logger log = Logger.getLogger("j9ddr.core_readers");

    public AddressSpaceImageInputStream(AddressSpace space) {
        this.space = space;
    }

    public int read() throws IOException {
        return this.space.read(this.streamPos++);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.space.read(this.streamPos, b, off, len);
        this.streamPos += (long)len;
        return len;
    }

    public void seek(long pos) throws IOException {
        if (pos <= 0L) {
            throw new IOException("attempt to seek to invalid pos: 0x" + AddressSpaceImageInputStream.hex(pos));
        }
        super.seek(pos);
        if (log.isLoggable(Level.FINER)) {
            log.finer("seek to 0x" + AddressSpaceImageInputStream.hex(pos) + " streamPos now 0x" + AddressSpaceImageInputStream.hex(this.streamPos));
        }
    }

    public int readInt() throws IOException {
        int ret = this.space.readInt(this.streamPos);
        this.streamPos += 4L;
        return ret;
    }

    public long readUnsignedInt() throws IOException {
        long ret = this.space.readUnsignedInt(this.streamPos);
        this.streamPos += 4L;
        return ret;
    }

    public long readLong() throws IOException {
        long ret = this.space.readLong(this.streamPos);
        this.streamPos += 8L;
        return ret;
    }

    private static String hex(long i) {
        return Long.toHexString(i);
    }
}

