/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.memory;

import com.ibm.j9ddr.corereaders.AbstractCoreReader;
import com.ibm.j9ddr.corereaders.memory.IMemorySource;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.corereaders.memory.ProtectedMemoryRange;
import java.io.IOException;

public class DumpMemorySource
extends ProtectedMemoryRange
implements IMemorySource {
    private final long fileOffset;
    private final AbstractCoreReader coreReader;
    private final int addressSpaceId;
    private final String name;

    protected DumpMemorySource(DumpMemorySource d) {
        this(d.baseAddress, d.size, d.fileOffset, d.addressSpaceId, d.coreReader, d.name, d.shared, d.readOnly, d.executable);
    }

    public DumpMemorySource(long baseAddress, long size, long fileOffset, AbstractCoreReader reader) {
        this(baseAddress, size, fileOffset, 0, reader, null, false, false, true);
    }

    public DumpMemorySource(long baseAddress, long size, long fileOffset, AbstractCoreReader reader, boolean shared, boolean readOnly, boolean executable) {
        this(baseAddress, size, fileOffset, 0, reader, null, shared, readOnly, executable);
    }

    public DumpMemorySource(long baseAddress, long size, long fileOffset, int addressSpaceId, AbstractCoreReader reader, String name) {
        this(baseAddress, size, fileOffset, addressSpaceId, reader, name, false, false, true);
    }

    public DumpMemorySource(long baseAddress, long size, long fileOffset, int addressSpaceId, AbstractCoreReader reader, String name, boolean shared, boolean readOnly, boolean executable) {
        super(baseAddress, size);
        this.fileOffset = fileOffset;
        this.addressSpaceId = addressSpaceId;
        this.coreReader = reader;
        this.shared = shared;
        this.readOnly = readOnly;
        this.executable = executable;
        this.name = name;
    }

    public int getAddressSpaceId() {
        return this.addressSpaceId;
    }

    public int getBytes(long address, byte[] buffer, int offset, int length) throws MemoryFault {
        long rangeOffset = address - this.baseAddress;
        if (rangeOffset < 0L || rangeOffset > this.size) {
            throw new IllegalArgumentException("Address " + Long.toHexString(address) + " is not in this range");
        }
        try {
            this.coreReader.seek(this.fileOffset + rangeOffset);
            this.coreReader.readFully(buffer, offset, length);
        }
        catch (IOException ex) {
            throw new MemoryFault(address, "Memory fault caused by IOException reading dump.", ex);
        }
        return length;
    }

    public long getFileOffset() {
        return this.fileOffset;
    }

    public String getName() {
        return this.name;
    }
}

