/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.elf.unwind;

import com.ibm.j9ddr.corereaders.elf.unwind.Unwind;
import com.ibm.j9ddr.corereaders.elf.unwind.UnwindTable;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStream;

class CIE {
    private final Unwind unwind;
    protected String augmentationStr;
    protected byte[] augmentationData;
    private byte personalityRoutinePointerEncoding;
    private long personalityRoutinePointer;
    private byte lsdaPointerEncoding;
    byte fdePointerEncoding = 0;
    private byte[] initialInstructions;
    private long startPos;
    private long length;
    private byte cieVersion;
    long codeAlignmentFactor;
    long dataAlignmentFactor;
    public final long returnAddressRegister;
    final ByteOrder byteOrder;
    final int wordSize;
    private boolean signalHandlerFrame;

    public CIE(Unwind unwind, ImageInputStream cfiStream, long startPos, long length) throws IOException {
        int initalInstructionsSize;
        this.unwind = unwind;
        this.startPos = startPos - 4L;
        this.length = length;
        this.byteOrder = this.unwind.process.getByteOrder();
        this.wordSize = this.unwind.process.bytesPerPointer();
        this.cieVersion = cfiStream.readByte();
        if (this.cieVersion != 1 && this.cieVersion != 3) {
            throw new IOException(String.format("Invalid CIE version %d", this.cieVersion));
        }
        byte[] augmentationStrBytes = new byte[5];
        int augmentationStrIndex = 0;
        augmentationStrBytes[0] = cfiStream.readByte();
        while (augmentationStrBytes[augmentationStrIndex++] != 0) {
            augmentationStrBytes[augmentationStrIndex] = cfiStream.readByte();
        }
        this.augmentationStr = new String(augmentationStrBytes, "ASCII");
        if ("eh".equals(this.augmentationStr)) {
            long ehData = this.unwind.process.bytesPerPointer() == 8 ? cfiStream.readLong() : (long)cfiStream.readInt();
        }
        this.codeAlignmentFactor = Unwind.readUnsignedLEB128(cfiStream);
        this.dataAlignmentFactor = Unwind.readSignedLEB128(cfiStream);
        this.returnAddressRegister = this.cieVersion == 1 ? (long)cfiStream.readByte() : Unwind.readUnsignedLEB128(cfiStream);
        if (this.augmentationStr.startsWith("z")) {
            long augmentationLength = Unwind.readUnsignedLEB128(cfiStream);
            this.parseAugmentationData(cfiStream, this.augmentationStr);
        }
        if ((initalInstructionsSize = (int)(length - (cfiStream.getStreamPosition() - startPos))) < 0) {
            throw new IOException(String.format("Negative size %d for initial instructions in CIE", initalInstructionsSize));
        }
        this.initialInstructions = new byte[initalInstructionsSize];
        cfiStream.read(this.initialInstructions, 0, this.initialInstructions.length);
        int remainder = (int)(cfiStream.getStreamPosition() % (long)this.unwind.process.bytesPerPointer());
        cfiStream.read(new byte[remainder], 0, remainder);
    }

    private void parseAugmentationData(ImageInputStream cfiStream, String augmenString) throws IOException {
        for (int i = 0; i < augmenString.length(); ++i) {
            if ('z' == augmenString.charAt(i)) continue;
            if ('P' == augmenString.charAt(i)) {
                this.personalityRoutinePointerEncoding = cfiStream.readByte();
                this.personalityRoutinePointer = this.unwind.readEncodedPC(cfiStream, this.personalityRoutinePointerEncoding);
            }
            if ('L' == augmenString.charAt(i)) {
                this.lsdaPointerEncoding = cfiStream.readByte();
            }
            if ('R' == augmenString.charAt(i)) {
                this.fdePointerEncoding = cfiStream.readByte();
            }
            if ('S' != augmenString.charAt(i)) continue;
            this.signalHandlerFrame = true;
        }
    }

    public void dump(PrintStream out) throws IOException {
        out.printf("Position 0x%x, length 0x%x, CIE ptr 0x%x\n", this.startPos, this.length, 0);
        out.printf("\tVersion %d\n", this.cieVersion);
        out.printf("\tAugmentation String: %s\n", this.augmentationStr);
        out.printf("\tCode Alignment: %d\n", this.codeAlignmentFactor);
        out.printf("\tData Alignment: %d\n", this.dataAlignmentFactor);
        out.printf("\tReturn Addr Reg: %d\n", this.returnAddressRegister);
        UnwindTable.dumpInstructions(out, this.initialInstructions, this);
        out.println();
    }

    public byte[] getInitialInstructions() {
        return this.initialInstructions;
    }
}

