/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.debugger;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.corereaders.debugger.DataEntry;
import com.ibm.j9ddr.corereaders.debugger.JniAddressSpace;
import com.ibm.j9ddr.corereaders.debugger.JniOutputStream;
import com.ibm.j9ddr.corereaders.debugger.JniRegisters;
import com.ibm.j9ddr.corereaders.debugger.JniRegistersAMD64;
import com.ibm.j9ddr.corereaders.debugger.JniRegistersIA32;
import com.ibm.j9ddr.corereaders.debugger.JniRegistersPPC32;
import com.ibm.j9ddr.corereaders.debugger.JniRegistersPPC64;
import com.ibm.j9ddr.corereaders.debugger.JniRegistersS39031;
import com.ibm.j9ddr.corereaders.debugger.JniRegistersS39064;
import com.ibm.j9ddr.corereaders.debugger.JniSearchableMemory;
import com.ibm.j9ddr.corereaders.debugger.JniThread;
import com.ibm.j9ddr.corereaders.memory.IAddressSpace;
import com.ibm.j9ddr.corereaders.memory.IModule;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.corereaders.osthread.IOSThread;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JniProcess
extends JniSearchableMemory
implements IProcess {
    public static final int TARGET_TYPE_UNKNOWN = 0;
    public static final int TARGET_TYPE_X86_32 = 1;
    public static final int TARGET_TYPE_X86_64 = 2;
    public static final int TARGET_TYPE_S390_31 = 3;
    public static final int TARGET_TYPE_S390_64 = 4;
    public static final int TARGET_TYPE_PPC_32 = 5;
    public static final int TARGET_TYPE_PPC_64 = 6;
    public static final int TARGET_TYPE_ARM = 7;
    public static final int TARGET_TYPE_IA64 = 8;
    private final JniAddressSpace addressSpace;
    private JniRegisters _registers;
    private List<DataEntry> _threadEntries = new ArrayList<DataEntry>();

    @Override
    public native int bytesPerPointer();

    @Override
    public native int getSignalNumber() throws DataUnavailableException;

    @Override
    public native long getProcessId() throws CorruptDataException;

    public native long[] getThreadIds();

    public native int getTargetArchitecture();

    public JniProcess(JniAddressSpace addressSpace) {
        this.addressSpace = addressSpace;
        try {
            this._registers = this.getRegisterFile();
        }
        catch (DataUnavailableException e) {
            PrintWriter outputStream = new PrintWriter(new JniOutputStream());
            e.printStackTrace(outputStream);
        }
    }

    private JniRegisters getRegisterFile() throws DataUnavailableException {
        int targetProcessorType = this.getTargetArchitecture();
        switch (targetProcessorType) {
            case 1: {
                return new JniRegistersIA32();
            }
            case 2: {
                return new JniRegistersAMD64();
            }
            case 5: {
                return new JniRegistersPPC32();
            }
            case 6: {
                return new JniRegistersPPC64();
            }
            case 3: {
                return new JniRegistersS39031();
            }
            case 4: {
                return new JniRegistersS39064();
            }
        }
        throw new DataUnavailableException("Architecture type " + targetProcessorType + " not implemented");
    }

    @Override
    public long getPointerAt(long address) throws MemoryFault {
        return super.getPointerAt(address, this.bytesPerPointer());
    }

    @Override
    public String getCommandLine() throws DataUnavailableException, CorruptDataException {
        throw new DataUnavailableException("not implemented yet");
    }

    @Override
    public Properties getEnvironmentVariables() throws DataUnavailableException, CorruptDataException {
        throw new DataUnavailableException("not implemented yet");
    }

    @Override
    public String getProcedureNameForAddress(long address) throws DataUnavailableException, CorruptDataException {
        throw new DataUnavailableException("not implemented yet");
    }

    @Override
    public String getProcedureNameForAddress(long address, boolean dtfjFormat) throws DataUnavailableException, CorruptDataException {
        throw new DataUnavailableException("not implemented yet");
    }

    @Override
    public IAddressSpace getAddressSpace() {
        return this.addressSpace;
    }

    @Override
    public IModule getExecutable() throws CorruptDataException {
        throw new CorruptDataException("Unimplemented");
    }

    @Override
    public Collection<? extends IModule> getModules() throws CorruptDataException {
        throw new CorruptDataException("Unimplemented");
    }

    @Override
    public Collection<? extends IOSThread> getThreads() throws CorruptDataException {
        ArrayList<JniThread> threads = new ArrayList<JniThread>(this._threadEntries.size());
        long[] tidList = this.getThreadIds();
        if (tidList == null) {
            return null;
        }
        for (long tid : tidList) {
            this._registers.readRegisters(tid);
            JniThread thread = new JniThread(tid, this._registers, null);
            threads.add(thread);
        }
        return threads;
    }

    @Override
    public boolean isFailingProcess() throws DataUnavailableException {
        throw new DataUnavailableException("Not available here");
    }
}

