/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CTypeParser {
    private static final Pattern arrayPattern = Pattern.compile("(.*?)\\s*((?:\\[[^\\]]*\\]\\s*)+)$");
    private static final Pattern pointerPattern = Pattern.compile("(.*?)\\s*((?:[*]\\s*)+)$");
    private static final Pattern bitfieldPattern = Pattern.compile("(.*?)\\s*(:\\s*\\d+)$");
    private static final Pattern trailingConstPattern = Pattern.compile("(.*?)(?<=[\\s*])const$");
    private static final Pattern trailingVolatilePattern = Pattern.compile("(.*?)(?<=[\\s*])volatile$");
    private String suffix = "";
    private String prefix = "";
    protected String coreType;
    private String cType;
    private String blobType;
    private String cppType;
    private int ordinal = 0;

    public static CTypeParser fromBlob(String declaration) {
        return new CTypeParser(TypeCodec.decode(declaration));
    }

    public static CTypeParser fromNative(String declaration) {
        return new CTypeParser(declaration);
    }

    public CTypeParser(String typeDeclaration) {
        this.coreType = typeDeclaration == null ? "null" : typeDeclaration.trim();
        Result result = this.processPrefix(this.coreType);
        this.prefix = result.meta;
        result = this.processSuffix(result.updatedType);
        this.suffix = result.meta;
        this.generateCType(result.updatedType);
        this.generateCPPType(result.updatedType);
        this.generateBlobType(result.updatedType);
        this.setOrdinal();
    }

    public String getDeclaredType() {
        return this.coreType;
    }

    private Result processPrefix(String type) {
        Result result = new Result(type);
        String prefix = "";
        if (type.startsWith("const ")) {
            prefix = "const ";
            type = type.substring("const".length()).trim();
        }
        if (type.startsWith("volatile ")) {
            prefix = "volatile ";
            type = type.substring("volatile".length()).trim();
        }
        result.updatedType = type;
        result.meta = prefix;
        return result;
    }

    private Result processSuffix(String type) {
        Result result = new Result(type);
        StringBuilder suffixBuilder = new StringBuilder();
        while (true) {
            Matcher m;
            if ((m = arrayPattern.matcher(type)).find()) {
                type = m.group(1);
                suffixBuilder.insert(0, this.stripSpaces(m.group(2)));
            } else {
                m = pointerPattern.matcher(type);
                if (m.find()) {
                    type = m.group(1);
                    suffixBuilder.insert(0, this.stripSpaces(m.group(2)));
                } else {
                    m = bitfieldPattern.matcher(type);
                    if (m.find()) {
                        type = m.group(1);
                        suffixBuilder.insert(0, this.stripSpaces(m.group(2)));
                    } else {
                        m = trailingConstPattern.matcher(type);
                        if (m.find()) {
                            type = m.group(1);
                            suffixBuilder.insert(0, " const ");
                        } else {
                            m = trailingVolatilePattern.matcher(type);
                            if (!m.find()) break;
                            type = m.group(1);
                            suffixBuilder.insert(0, " volatile ");
                        }
                    }
                }
            }
            type = type.trim();
        }
        result.updatedType = type;
        result.meta = suffixBuilder.toString().trim();
        return result;
    }

    private void generateCType(String type) {
        this.cType = TypeCodec.encode(type);
        this.cType = this.cType.replace("const char", "U8");
        this.cType = this.cType.replace("const ", "");
    }

    private void generateBlobType(String type) {
        this.blobType = this.cType;
    }

    private void generateCPPType(String type) {
        this.cppType = type.equals("bool") ? "U32" : type;
    }

    private void setOrdinal() {
        int templateDepth = 0;
        int castDepth = 0;
        block7: for (int i = 0; i < this.coreType.length(); ++i) {
            switch (this.coreType.charAt(i)) {
                case ',': {
                    if (templateDepth <= 0 || castDepth != 0) continue block7;
                    ++this.ordinal;
                    continue block7;
                }
                case '<': {
                    ++templateDepth;
                    continue block7;
                }
                case '(': {
                    ++castDepth;
                    continue block7;
                }
                case ')': {
                    --castDepth;
                    continue block7;
                }
                case '>': {
                    --templateDepth;
                    continue block7;
                }
            }
        }
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public String getMacroVersion() {
        return this.ordinal == 0 ? "" : String.valueOf(this.ordinal);
    }

    private String stripSpaces(String input) {
        StringBuilder builder = new StringBuilder();
        for (char c : input.toCharArray()) {
            if (Character.isWhitespace(c)) continue;
            builder.append(c);
        }
        return builder.toString();
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Deprecated
    public String getCoreType() {
        return this.cType;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getCType() {
        return this.cType;
    }

    public String getBlobType() {
        return this.blobType;
    }

    public String getCPPType() {
        return this.cppType;
    }

    public boolean hasTemplate() {
        return TypeCodec.hasTemplate(this.coreType);
    }

    public JavaType getJavaType() {
        return new JavaType();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof String) {
            CTypeParser cp = new CTypeParser((String)o);
            return this.equals(cp);
        }
        if (o instanceof CTypeParser) {
            CTypeParser cp = (CTypeParser)o;
            return this.cType.equals(cp.cType);
        }
        return false;
    }

    public String toString() {
        return "Java type : " + this.getBlobType() + ", C type : " + this.getCType() + ", C++ type : " + this.getCPPType();
    }

    public class JavaType {
        private String packageFragment = "";
        private String shortName;
        private String name;
        private String template = "";

        JavaType() {
            int current = 0;
            int pos = CTypeParser.this.blobType.indexOf("__");
            StringBuilder fragment = new StringBuilder();
            block4: while (pos != -1) {
                switch (CTypeParser.this.blobType.charAt(pos + 2)) {
                    case 'A': {
                        fragment.append(CTypeParser.this.blobType.substring(current, pos));
                        fragment.append('/');
                        current = pos + 3;
                        pos = CTypeParser.this.blobType.indexOf("__", current);
                        continue block4;
                    }
                    case 'H': {
                        this.shortName = CTypeParser.this.blobType.substring(current, pos);
                        int end = CTypeParser.this.blobType.endsWith("__I") ? CTypeParser.this.blobType.length() - 3 : CTypeParser.this.blobType.length();
                        this.template = CTypeParser.this.blobType.substring(pos + 3, end);
                        pos = -1;
                        continue block4;
                    }
                }
                pos = -1;
            }
            this.packageFragment = fragment.length() > 0 ? fragment.substring(0, fragment.length() - 1) : fragment.toString();
            this.name = CTypeParser.this.blobType.substring(current);
            if (this.shortName == null) {
                this.shortName = this.name;
            }
        }

        public boolean hasPackageFragment() {
            return this.packageFragment.length() != 0;
        }

        public String getPackageFragment(TypeFormat format) {
            return this.getPackageFragment(TypeFormat.JAVA_SLASH, this.packageFragment, format);
        }

        public String getPackageFragment(TypeFormat from, String packageFragment, TypeFormat to) {
            String replace = TypeFormat.JAVA_SLASH.equals((Object)from) ? "/" : ".";
            switch (to) {
                case NATIVE: {
                    return packageFragment.replace(replace, "::");
                }
                case BLOB: {
                    return packageFragment.replace(replace, "__A");
                }
                case JAVA_DOT: {
                    if (!TypeFormat.JAVA_SLASH.equals((Object)from)) break;
                    return packageFragment.replace("/", ".");
                }
                case JAVA_SLASH: {
                    if (!TypeFormat.JAVA_DOT.equals((Object)from)) break;
                    return packageFragment.replace(".", "/");
                }
                default: {
                    return packageFragment;
                }
            }
            return packageFragment;
        }

        public String getShortName() {
            return this.shortName;
        }

        public String getName() {
            return this.name;
        }

        public String getTemplate() {
            return this.template;
        }

        public String toString() {
            if (this.packageFragment.length() == 0) {
                return this.shortName;
            }
            return this.packageFragment + "/" + this.shortName;
        }
    }

    private class Result {
        public final String originalType;
        public String updatedType;
        public String meta;

        public Result(String type) {
            this.originalType = type;
        }
    }

    private static class TypeCodec {
        private static final Map<String, String> codec = new LinkedHashMap<String, String>();

        private TypeCodec() {
        }

        static String encode(String name) {
            for (String key : codec.keySet()) {
                name = name.replace(key, codec.get(key));
            }
            return name;
        }

        static String decode(String name) {
            for (Map.Entry<String, String> entry : codec.entrySet()) {
                name = name.replace(entry.getValue(), entry.getKey());
            }
            return name;
        }

        static boolean hasTemplate(String declaration) {
            int pos = declaration.indexOf(60);
            if (pos != -1) {
                return true;
            }
            return declaration.contains("__H") || declaration.contains("__B");
        }

        static boolean hasNamespace(String declaration) {
            int pos = declaration.indexOf("::");
            if (pos != -1) {
                return true;
            }
            return declaration.contains("__A");
        }

        static {
            codec.put("::", "__A");
            codec.put("< <", "__B");
            codec.put("> >", "__C");
            codec.put(" *", "__D");
            codec.put("*", "__D");
            codec.put("(", "__E");
            codec.put(")", "__F");
            codec.put(", ", "__G");
            codec.put(",", "__G");
            codec.put("<", "__H");
            codec.put(">", "__I");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TypeFormat {
        NATIVE,
        BLOB,
        JAVA_SLASH,
        JAVA_DOT;

    }
}

